/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.synapse.neat;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.encog.neural.networks.synapse.neat.NEATLink;
import org.encog.neural.networks.synapse.neat.NEATNeuronType;
import org.encog.persist.annotations.EGAttribute;
import org.encog.persist.annotations.EGIgnore;
import org.encog.persist.annotations.EGReferenceable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EGReferenceable
public class NEATNeuron
implements Serializable {
    private static final long serialVersionUID = -2815145950124389743L;
    @EGAttribute
    private double activationResponse;
    private final List<NEATLink> inboundLinks = new ArrayList<NEATLink>();
    @EGAttribute
    private long neuronID;
    @EGAttribute
    private NEATNeuronType neuronType;
    @EGAttribute
    private double output;
    private List<NEATLink> outputboundLinks = new ArrayList<NEATLink>();
    @EGAttribute
    private int posX;
    @EGAttribute
    private int posY;
    @EGAttribute
    private double splitX;
    @EGAttribute
    private double splitY;
    @EGIgnore
    private double sumActivation;

    public NEATNeuron() {
    }

    public NEATNeuron(NEATNeuronType nEATNeuronType, long l, double d, double d2, double d3) {
        this.neuronType = nEATNeuronType;
        this.neuronID = l;
        this.splitY = d;
        this.splitX = d2;
        this.activationResponse = d3;
        this.posX = 0;
        this.posY = 0;
        this.output = 0.0;
        this.sumActivation = 0.0;
    }

    public double getActivationResponse() {
        return this.activationResponse;
    }

    public List<NEATLink> getInboundLinks() {
        return this.inboundLinks;
    }

    public long getNeuronID() {
        return this.neuronID;
    }

    public NEATNeuronType getNeuronType() {
        return this.neuronType;
    }

    public double getOutput() {
        return this.output;
    }

    public List<NEATLink> getOutputboundLinks() {
        return this.outputboundLinks;
    }

    public int getPosX() {
        return this.posX;
    }

    public int getPosY() {
        return this.posY;
    }

    public double getSplitX() {
        return this.splitX;
    }

    public double getSplitY() {
        return this.splitY;
    }

    public double getSumActivation() {
        return this.sumActivation;
    }

    public void setOutput(double d) {
        this.output = d;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[NEATNeuron:id=");
        stringBuilder.append(this.neuronID);
        stringBuilder.append(",type=");
        switch (this.neuronType) {
            case Input: {
                stringBuilder.append("I");
                break;
            }
            case Output: {
                stringBuilder.append("O");
                break;
            }
            case Bias: {
                stringBuilder.append("B");
                break;
            }
            case Hidden: {
                stringBuilder.append("H");
                break;
            }
            default: {
                stringBuilder.append("Unknown");
            }
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

