/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.logic;

import org.encog.neural.NeuralNetworkError;
import org.encog.neural.data.NeuralData;
import org.encog.neural.data.basic.BasicNeuralData;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.NeuralOutputHolder;
import org.encog.neural.networks.layers.Layer;
import org.encog.neural.networks.logic.NeuralLogic;
import org.encog.neural.networks.synapse.Synapse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeedforwardLogic
implements NeuralLogic {
    private static final long serialVersionUID = 1779691422598188487L;
    private static final transient Logger LOGGER = LoggerFactory.getLogger(FeedforwardLogic.class);
    private BasicNetwork network;

    public NeuralData compute(NeuralData neuralData, NeuralOutputHolder neuralOutputHolder) {
        if (neuralOutputHolder == null && this.network.getStructure().getFlat() != null) {
            this.network.getStructure().updateFlatNetwork();
            BasicNeuralData basicNeuralData = new BasicNeuralData(this.network.getStructure().getFlat().getOutputCount());
            this.network.getStructure().getFlat().compute(neuralData.getData(), basicNeuralData.getData());
            return basicNeuralData;
        }
        this.network.getStructure().updateFlatNetwork();
        Layer layer = this.network.getLayer("INPUT");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Pattern {} presented to neural network", (Object)neuralData);
        }
        NeuralOutputHolder neuralOutputHolder2 = neuralOutputHolder == null ? new NeuralOutputHolder() : neuralOutputHolder;
        this.compute(neuralOutputHolder2, layer, neuralData, null);
        return neuralOutputHolder2.getOutput();
    }

    private void compute(NeuralOutputHolder neuralOutputHolder, Layer layer, NeuralData neuralData, Synapse synapse) {
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Processing layer: {}, input= {}", (Object)layer, (Object)neuralData);
            }
            this.network.getStructure().updateFlatNetwork();
            this.preprocessLayer(layer, neuralData, synapse);
            for (Synapse synapse2 : layer.getNext()) {
                if (neuralOutputHolder.getResult().containsKey(synapse2)) continue;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Processing synapse: {}", (Object)synapse2);
                }
                NeuralData neuralData2 = synapse2.compute(neuralData);
                neuralData2 = synapse2.getToLayer().compute(neuralData2);
                synapse2.getToLayer().process(neuralData2);
                neuralOutputHolder.getResult().put(synapse2, neuralData);
                this.compute(neuralOutputHolder, synapse2.getToLayer(), neuralData2, synapse2);
                Layer layer2 = this.network.getLayer("OUTPUT");
                if (synapse2.getToLayer() != layer2) continue;
                neuralOutputHolder.setOutput(neuralData2);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new NeuralNetworkError("Size mismatch on input of size " + neuralData.size() + " and layer: ", arrayIndexOutOfBoundsException);
        }
    }

    public BasicNetwork getNetwork() {
        return this.network;
    }

    public void init(BasicNetwork basicNetwork) {
        this.network = basicNetwork;
    }

    public void preprocessLayer(Layer layer, NeuralData neuralData, Synapse synapse) {
    }
}

