/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.logic;

import org.encog.engine.util.BoundMath;
import org.encog.mathutil.randomize.RangeRandomizer;
import org.encog.neural.NeuralNetworkError;
import org.encog.neural.data.NeuralData;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.NeuralOutputHolder;
import org.encog.neural.networks.layers.Layer;
import org.encog.neural.networks.logic.ThermalLogic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoltzmannLogic
extends ThermalLogic {
    private static final long serialVersionUID = 8067779325187120187L;
    public static final String PROPERTY_RUN_CYCLES = "RCYCLE";
    public static final String PROPERTY_ANNEAL_CYCLES = "ACYCLE";
    public static final String PROPERTY_TEMPERATURE = "TEMPERATURE";
    private static final transient Logger LOGGER = LoggerFactory.getLogger(BoltzmannLogic.class);
    private double temperature;
    private int[] on;
    private int[] off;
    private int annealCycles;
    private int runCycles;

    public NeuralData compute(NeuralData neuralData, NeuralOutputHolder neuralOutputHolder) {
        if (LOGGER.isErrorEnabled()) {
            LOGGER.error("Compute on BasicNetwork cannot be used, rather call the run method on the logic class.");
        }
        throw new NeuralNetworkError("Compute on BasicNetwork cannot be used, rather call the run method on the logic class.");
    }

    public void decreaseTemperature(double d) {
        this.temperature *= d;
    }

    public void establishEquilibrium() {
        int n;
        int n2;
        int n3 = this.getThermalSynapse().getFromNeuronCount();
        for (n2 = 0; n2 < n3; ++n2) {
            this.on[n2] = 0;
            this.off[n2] = 0;
        }
        for (n = 0; n < this.runCycles * n3; ++n) {
            this.run((int)RangeRandomizer.randomize(0.0, n3 - 1));
        }
        for (n = 0; n < this.annealCycles * n3; ++n) {
            n2 = (int)RangeRandomizer.randomize(0.0, n3 - 1);
            this.run(n2);
            if (this.getCurrentState().getBoolean(n2)) {
                int n4 = n2;
                this.on[n4] = this.on[n4] + 1;
                continue;
            }
            int n5 = n2;
            this.off[n5] = this.off[n5] + 1;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            this.getCurrentState().setData(n2, this.on[n2] > this.off[n2]);
        }
    }

    public double getTemperature() {
        return this.temperature;
    }

    public void init(BasicNetwork basicNetwork) {
        super.init(basicNetwork);
        Layer layer = this.getNetwork().getLayer("INPUT");
        this.on = new int[layer.getNeuronCount()];
        this.off = new int[layer.getNeuronCount()];
        this.temperature = this.getNetwork().getPropertyDouble(PROPERTY_TEMPERATURE);
        this.runCycles = (int)this.getNetwork().getPropertyLong(PROPERTY_RUN_CYCLES);
        this.annealCycles = (int)this.getNetwork().getPropertyLong(PROPERTY_ANNEAL_CYCLES);
    }

    public void run() {
        int n = this.getThermalSynapse().getFromNeuronCount();
        for (int i = 0; i < n; ++i) {
            this.run(i);
        }
    }

    void run(int n) {
        int n2 = this.getThermalSynapse().getFromNeuronCount();
        double d = 0.0;
        for (int i = 0; i < n2; ++i) {
            d += this.getThermalSynapse().getMatrix().get(n, i) * (double)(this.getCurrentState().getBoolean(i) ? 1 : 0);
        }
        double d2 = 1.0 / (1.0 + BoundMath.exp(-(d -= this.getThermalLayer().getBiasWeight(n)) / this.temperature));
        if (RangeRandomizer.randomize(0.0, 1.0) <= d2) {
            this.getCurrentState().setData(n, true);
        } else {
            this.getCurrentState().setData(n, false);
        }
    }

    public void setTemperature(double d) {
        this.temperature = d;
    }
}

