/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.layers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.encog.engine.network.activation.ActivationFunction;
import org.encog.engine.network.activation.ActivationTANH;
import org.encog.neural.NeuralNetworkError;
import org.encog.neural.data.NeuralData;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.layers.Layer;
import org.encog.neural.networks.synapse.DirectSynapse;
import org.encog.neural.networks.synapse.OneToOneSynapse;
import org.encog.neural.networks.synapse.Synapse;
import org.encog.neural.networks.synapse.SynapseType;
import org.encog.neural.networks.synapse.WeightedSynapse;
import org.encog.neural.networks.synapse.WeightlessSynapse;
import org.encog.neural.networks.synapse.neat.NEATSynapse;
import org.encog.persist.EncogCollection;
import org.encog.persist.Persistor;
import org.encog.persist.persistors.BasicLayerPersistor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicLayer
implements Layer,
Serializable {
    private static final long serialVersionUID = -5682296868750703898L;
    private static final transient Logger LOGGER = LoggerFactory.getLogger(BasicLayer.class);
    private final List<Synapse> next = new ArrayList<Synapse>();
    private int x;
    private int y;
    private int id;
    private ActivationFunction activationFunction;
    private String description;
    private String name;
    private int neuronCount;
    private double[] biasWeights;
    private BasicNetwork network;
    private double biasActivation;

    public BasicLayer() {
        this(1);
    }

    public BasicLayer(ActivationFunction activationFunction, boolean bl, int n) {
        this.neuronCount = n;
        this.id = -1;
        this.biasActivation = 1.0;
        this.setActivationFunction(activationFunction);
        if (bl) {
            this.biasWeights = new double[n];
        }
    }

    public BasicLayer(int n) {
        this(new ActivationTANH(), true, n);
    }

    @Override
    public void addNext(Layer layer) {
        this.addNext(layer, SynapseType.Weighted);
    }

    @Override
    public void addNext(Layer layer, SynapseType synapseType) {
        Synapse synapse = null;
        if (this.network == null) {
            throw new NeuralNetworkError("Can't add to this layer, it is not yet part of a network itself.");
        }
        layer.setNetwork(this.network);
        this.network.getStructure().assignID(layer);
        switch (synapseType) {
            case OneToOne: {
                synapse = new OneToOneSynapse(this, layer);
                break;
            }
            case Weighted: {
                synapse = new WeightedSynapse(this, layer);
                break;
            }
            case Weightless: {
                synapse = new WeightlessSynapse(this, layer);
                break;
            }
            case Direct: {
                synapse = new DirectSynapse(this, layer);
                break;
            }
            case NEAT: {
                synapse = new NEATSynapse(this, layer);
                break;
            }
            default: {
                throw new NeuralNetworkError("Unknown synapse type");
            }
        }
        if (synapse == null) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("Unknown synapse type.");
            }
            throw new NeuralNetworkError("Unknown synapse type.");
        }
        this.next.add(synapse);
    }

    @Override
    public void addSynapse(Synapse synapse) {
        this.next.add(synapse);
    }

    @Override
    public int compareTo(Layer layer) {
        if (layer.getID() == this.getID()) {
            return 0;
        }
        if (layer.getID() > this.getID()) {
            return 1;
        }
        return -1;
    }

    @Override
    public NeuralData compute(NeuralData neuralData) {
        NeuralData neuralData2 = neuralData.clone();
        if (this.hasBias()) {
            for (int i = 0; i < this.biasWeights.length; ++i) {
                neuralData2.setData(i, neuralData2.getData(i) + this.biasWeights[i] * this.biasActivation);
            }
        }
        this.getActivationFunction().activationFunction(neuralData2.getData(), 0, neuralData2.getData().length);
        return neuralData2;
    }

    @Override
    public Persistor createPersistor() {
        return new BasicLayerPersistor();
    }

    @Override
    public ActivationFunction getActivationFunction() {
        return this.activationFunction;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public BasicNetwork getNetwork() {
        return this.network;
    }

    @Override
    public int getNeuronCount() {
        return this.neuronCount;
    }

    @Override
    public List<Synapse> getNext() {
        return this.next;
    }

    @Override
    public Collection<Layer> getNextLayers() {
        HashSet<Layer> hashSet = new HashSet<Layer>();
        for (Synapse synapse : this.next) {
            hashSet.add(synapse.getToLayer());
        }
        return hashSet;
    }

    @Override
    public double[] getBiasWeights() {
        return this.biasWeights;
    }

    @Override
    public double getBiasWeight(int n) {
        if (!this.hasBias()) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("Attempting to access bias on a layer that has no bias.");
            }
            throw new NeuralNetworkError("Attempting to access bias on a layer that has no bias.");
        }
        return this.biasWeights[n];
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public boolean hasBias() {
        return this.biasWeights != null;
    }

    @Override
    public boolean isConnectedTo(Layer layer) {
        for (Synapse synapse : this.next) {
            if (synapse.getToLayer() != layer) continue;
            return true;
        }
        return false;
    }

    public boolean isSelfConnected() {
        for (Synapse synapse : this.next) {
            if (!synapse.isSelfConnected()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void process(NeuralData neuralData) {
    }

    @Override
    public NeuralData recur() {
        return null;
    }

    @Override
    public void setActivationFunction(ActivationFunction activationFunction) {
        this.activationFunction = activationFunction;
    }

    @Override
    public void setDescription(String string) {
        this.description = string;
    }

    @Override
    public void setID(int n) {
        this.id = n;
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    @Override
    public void setNetwork(BasicNetwork basicNetwork) {
        this.network = basicNetwork;
    }

    @Override
    public void setNeuronCount(int n) {
        this.neuronCount = n;
    }

    @Override
    public void setBiasWeights(double[] dArray) {
        this.biasWeights = dArray;
    }

    @Override
    public void setBiasWeight(int n, double d) {
        if (!this.hasBias()) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("Attempting to set a bias weight on a layer that does not use bias.");
            }
            throw new NeuralNetworkError("Attempting to set a bias weight on a layer that does not use bias.");
        }
        this.biasWeights[n] = d;
    }

    @Override
    public void setX(int n) {
        this.x = n;
    }

    @Override
    public void setY(int n) {
        this.y = n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        stringBuilder.append(this.getClass().getSimpleName());
        stringBuilder.append("(");
        stringBuilder.append(this.getID());
        stringBuilder.append(")");
        stringBuilder.append(": neuronCount=");
        stringBuilder.append(this.neuronCount);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public double getBiasActivation() {
        return this.biasActivation;
    }

    @Override
    public void setBiasActivation(double d) {
        this.biasActivation = d;
    }

    @Override
    public EncogCollection getCollection() {
        return null;
    }

    @Override
    public void setCollection(EncogCollection encogCollection) {
    }
}

