/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.data.sql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.encog.neural.data.NeuralData;
import org.encog.neural.data.NeuralDataError;
import org.encog.neural.data.NeuralDataPair;
import org.encog.neural.data.NeuralDataSet;
import org.encog.neural.data.basic.BasicNeuralData;
import org.encog.neural.data.basic.BasicNeuralDataPair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLNeuralDataSet
implements NeuralDataSet {
    public static final String ADD_NOT_SUPPORTED = "Adds are not supported with this dataset, it is read only.";
    public static final String REMOVE_NOT_SUPPORTED = "Removes are not supported with this dataset, it is read only.";
    private Connection connection;
    private PreparedStatement statement;
    private boolean closeConnection;
    private final List<SQLNeuralDataSet> iterators = new ArrayList<SQLNeuralDataSet>();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final int inputSize;
    private final int idealSize;

    public SQLNeuralDataSet(Connection connection, String string, int n, int n2) {
        this.inputSize = n;
        this.idealSize = n2;
        this.connection = connection;
        this.closeConnection = false;
        try {
            this.statement = this.connection.prepareStatement(string);
        }
        catch (SQLException sQLException) {
            this.logger.error("Exception", (Throwable)sQLException);
            throw new NeuralDataError(sQLException);
        }
    }

    public SQLNeuralDataSet(String string, int n, int n2, String string2, String string3, String string4, String string5) {
        this.inputSize = n;
        this.idealSize = n2;
        this.closeConnection = true;
        try {
            Class.forName(string2);
            this.connection = string4 == null || string5 == null ? DriverManager.getConnection(string3) : DriverManager.getConnection(string3, string4, string5);
            this.statement = this.connection.prepareStatement(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.logger.error("Exception", (Throwable)classNotFoundException);
            throw new NeuralDataError(classNotFoundException);
        }
        catch (SQLException sQLException) {
            this.logger.error("Exception", (Throwable)sQLException);
            throw new NeuralDataError(sQLException);
        }
    }

    @Override
    public void add(NeuralData neuralData) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error(ADD_NOT_SUPPORTED);
        }
        throw new NeuralDataError(ADD_NOT_SUPPORTED);
    }

    @Override
    public void add(NeuralData neuralData, NeuralData neuralData2) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error(ADD_NOT_SUPPORTED);
        }
        throw new NeuralDataError(ADD_NOT_SUPPORTED);
    }

    @Override
    public void add(NeuralDataPair neuralDataPair) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error(ADD_NOT_SUPPORTED);
        }
        throw new NeuralDataError(ADD_NOT_SUPPORTED);
    }

    @Override
    public void close() {
        for (SQLNeuralDataSet sQLNeuralDataSet : this.iterators) {
            sQLNeuralDataSet.close();
        }
        try {
            this.statement.close();
            if (this.closeConnection) {
                this.connection.close();
            }
        }
        catch (SQLException sQLException) {
            this.logger.error("Exception", (Throwable)sQLException);
            throw new NeuralDataError(sQLException);
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public int getIdealSize() {
        return this.idealSize;
    }

    @Override
    public int getInputSize() {
        return this.inputSize;
    }

    public PreparedStatement getStatement() {
        return this.statement;
    }

    public boolean isCloseConnection() {
        return this.closeConnection;
    }

    @Override
    public Iterator<NeuralDataPair> iterator() {
        return new SQLNeuralIterator();
    }

    public void setCloseConnection(boolean bl) {
        this.closeConnection = bl;
    }

    @Override
    public boolean isSupervised() {
        return this.idealSize > 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SQLNeuralIterator
    implements Iterator<NeuralDataPair> {
        private final ResultSet results;
        private boolean dataReady;

        public SQLNeuralIterator() {
            try {
                this.results = SQLNeuralDataSet.this.statement.executeQuery();
            }
            catch (SQLException sQLException) {
                SQLNeuralDataSet.this.logger.error("Exception", (Throwable)sQLException);
                throw new NeuralDataError(sQLException);
            }
        }

        public void close() {
            try {
                this.results.close();
            }
            catch (SQLException sQLException) {
                SQLNeuralDataSet.this.logger.error("Exception", (Throwable)sQLException);
                throw new NeuralDataError(sQLException);
            }
        }

        @Override
        public boolean hasNext() {
            try {
                if (this.dataReady) {
                    return true;
                }
                if (this.results.next()) {
                    this.dataReady = true;
                    return true;
                }
                this.dataReady = false;
                return false;
            }
            catch (SQLException sQLException) {
                SQLNeuralDataSet.this.logger.error("Exception", (Throwable)sQLException);
                throw new NeuralDataError(sQLException);
            }
        }

        @Override
        public NeuralDataPair next() {
            try {
                double d;
                int n;
                BasicNeuralData basicNeuralData = new BasicNeuralData(SQLNeuralDataSet.this.inputSize);
                BasicNeuralData basicNeuralData2 = null;
                for (n = 0; n < SQLNeuralDataSet.this.inputSize; ++n) {
                    d = this.results.getDouble(n + 1);
                    basicNeuralData.setData(n, d);
                }
                if (SQLNeuralDataSet.this.idealSize > 0) {
                    basicNeuralData2 = new BasicNeuralData(SQLNeuralDataSet.this.idealSize);
                    for (n = 0; n < SQLNeuralDataSet.this.idealSize; ++n) {
                        d = this.results.getDouble(SQLNeuralDataSet.this.inputSize + n + 1);
                        basicNeuralData2.setData(n, d);
                    }
                }
                this.dataReady = false;
                return new BasicNeuralDataPair(basicNeuralData, basicNeuralData2);
            }
            catch (SQLException sQLException) {
                SQLNeuralDataSet.this.logger.error("Exception", (Throwable)sQLException);
                throw new NeuralDataError(sQLException);
            }
        }

        @Override
        public void remove() {
            if (SQLNeuralDataSet.this.logger.isErrorEnabled()) {
                SQLNeuralDataSet.this.logger.error(SQLNeuralDataSet.REMOVE_NOT_SUPPORTED);
            }
            throw new NeuralDataError(SQLNeuralDataSet.REMOVE_NOT_SUPPORTED);
        }
    }
}

