/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.data.bipolar;

import java.io.Serializable;
import org.encog.mathutil.matrices.BiPolarUtil;
import org.encog.neural.data.NeuralData;
import org.encog.neural.data.NeuralDataError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BiPolarNeuralData
implements NeuralData,
Serializable {
    private static final long serialVersionUID = -6082894455587612231L;
    private boolean[] data;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public BiPolarNeuralData(boolean[] blArray) {
        this.data = new boolean[blArray.length];
        System.arraycopy(blArray, 0, this.data, 0, blArray.length);
    }

    public BiPolarNeuralData(int n) {
        this.data = new boolean[n];
    }

    public void add(int n, double d) {
        throw new NeuralDataError("Add is not supported for bipolar data.");
    }

    public void clear() {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = false;
        }
    }

    public NeuralData clone() {
        BiPolarNeuralData biPolarNeuralData = new BiPolarNeuralData(this.size());
        for (int i = 0; i < this.size(); ++i) {
            biPolarNeuralData.setData(i, this.getData(i));
        }
        return biPolarNeuralData;
    }

    public boolean getBoolean(int n) {
        return this.data[n];
    }

    public double[] getData() {
        return BiPolarUtil.bipolar2double(this.data);
    }

    public double getData(int n) {
        return BiPolarUtil.bipolar2double(this.data[n]);
    }

    public void setData(double[] dArray) {
        this.data = BiPolarUtil.double2bipolar(dArray);
    }

    public void setData(int n, boolean bl) {
        this.data[n] = bl;
    }

    public void setData(int n, double d) {
        this.data[n] = BiPolarUtil.double2bipolar(d);
    }

    public int size() {
        return this.data.length;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        for (int i = 0; i < this.size(); ++i) {
            if (this.getData(i) > 0.0) {
                stringBuilder.append("T");
            } else {
                stringBuilder.append("F");
            }
            if (i == this.size() - 1) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

