/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.data.basic;

import java.io.Serializable;
import org.encog.neural.data.NeuralData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicNeuralData
implements NeuralData,
Serializable,
Cloneable {
    private static final long serialVersionUID = -3644304891793584603L;
    private double[] data;
    private final transient Logger logger = LoggerFactory.getLogger(this.getClass());

    public BasicNeuralData(double[] dArray) {
        this(dArray.length);
        System.arraycopy(dArray, 0, this.data, 0, dArray.length);
    }

    public BasicNeuralData(int n) {
        this.data = new double[n];
    }

    public BasicNeuralData(NeuralData neuralData) {
        this(neuralData.size());
        System.arraycopy(neuralData.getData(), 0, this.data, 0, neuralData.size());
    }

    public void add(int n, double d) {
        int n2 = n;
        this.data[n2] = this.data[n2] + d;
    }

    public void clear() {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = 0.0;
        }
    }

    public NeuralData clone() {
        return new BasicNeuralData(this);
    }

    public double[] getData() {
        return this.data;
    }

    public double getData(int n) {
        return this.data[n];
    }

    public void setData(double[] dArray) {
        this.data = dArray;
    }

    public void setData(int n, double d) {
        this.data[n] = d;
    }

    public int size() {
        return this.data.length;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("[BasicNeuralData:");
        for (int i = 0; i < this.data.length; ++i) {
            if (i != 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(this.data[i]);
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

