/*
 * Decompiled with CFR 0.152.
 */
package org.encog.mathutil.rbf;

import org.encog.engine.util.BoundMath;
import org.encog.mathutil.rbf.BasicRBF;

public class InverseMultiquadricFunction
extends BasicRBF {
    public InverseMultiquadricFunction(double d, double d2, double d3) {
        this.setCenters(new double[1]);
        this.getCenters()[0] = d;
        this.setPeak(d2);
        this.setWidth(d3);
    }

    public InverseMultiquadricFunction(double d, double[] dArray, double d2) {
        this.setCenters(dArray);
        this.setPeak(d);
        this.setWidth(d2);
    }

    public InverseMultiquadricFunction(int n) {
        this.setCenters(new double[n]);
        this.setPeak(1.0);
        this.setWidth(1.0);
    }

    public double calculate(double[] dArray) {
        double d = 0.0;
        double[] dArray2 = this.getCenters();
        double d2 = this.getWidth();
        for (int i = 0; i < dArray2.length; ++i) {
            d += Math.pow(dArray[i] - dArray2[i], 2.0) + d2 * d2;
        }
        return this.getPeak() / BoundMath.sqrt(d);
    }
}

