/*
 * Decompiled with CFR 0.152.
 */
package org.encog.mathutil.randomize;

import org.encog.mathutil.LinearCongruentialGenerator;
import org.encog.mathutil.randomize.BasicRandomizer;
import org.encog.neural.networks.BasicNetwork;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsistentRandomizer
extends BasicRandomizer {
    private final LinearCongruentialGenerator rand;
    private final double min;
    private final double max;
    private final int seed;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public ConsistentRandomizer(double d, double d2) {
        this(d2, d, 1000);
    }

    public ConsistentRandomizer(double d, double d2, int n) {
        this.max = d2;
        this.min = d;
        this.seed = n;
        this.rand = new LinearCongruentialGenerator(n);
    }

    public double randomize(double d) {
        return this.rand.range(this.min, this.max);
    }

    public void randomize(BasicNetwork basicNetwork) {
        this.rand.setSeed(this.seed);
        super.randomize(basicNetwork);
    }
}

