/*
 * Decompiled with CFR 0.152.
 */
package org.encog.engine.opencl;

import org.encog.engine.opencl.EncogCLDevice;
import org.encog.engine.opencl.EncogCLPlatform;
import org.encog.engine.opencl.kernels.EncogKernel;
import org.jocl.CL;
import org.jocl.Pointer;
import org.jocl.cl_command_queue;
import org.jocl.cl_context;
import org.jocl.cl_device_id;
import org.jocl.cl_kernel;
import org.jocl.cl_mem;

public class EncogCLQueue {
    private final cl_command_queue commands;
    private final EncogCLDevice device;

    public EncogCLQueue(EncogCLDevice encogCLDevice) {
        EncogCLPlatform encogCLPlatform = encogCLDevice.getPlatform();
        this.device = encogCLDevice;
        this.commands = CL.clCreateCommandQueue((cl_context)encogCLPlatform.getContext(), (cl_device_id)encogCLDevice.getDevice(), (long)0L, null);
    }

    public void array2Buffer(float[] fArray, cl_mem cl_mem2) {
        CL.clEnqueueWriteBuffer((cl_command_queue)this.commands, (cl_mem)cl_mem2, (boolean)true, (long)0L, (long)(4 * fArray.length), (Pointer)Pointer.to((float[])fArray), (int)0, null, null);
    }

    public void array2Buffer(int[] nArray, cl_mem cl_mem2) {
        CL.clEnqueueWriteBuffer((cl_command_queue)this.commands, (cl_mem)cl_mem2, (boolean)true, (long)0L, (long)(4 * nArray.length), (Pointer)Pointer.to((int[])nArray), (int)0, null, null);
    }

    public void buffer2Array(cl_mem cl_mem2, float[] fArray) {
        CL.clEnqueueReadBuffer((cl_command_queue)this.commands, (cl_mem)cl_mem2, (boolean)true, (long)0L, (long)(fArray.length * 4), (Pointer)Pointer.to((float[])fArray), (int)0, null, null);
    }

    public void buffer2Array(cl_mem cl_mem2, int[] nArray) {
        CL.clEnqueueReadBuffer((cl_command_queue)this.commands, (cl_mem)cl_mem2, (boolean)true, (long)0L, (long)(nArray.length * 4), (Pointer)Pointer.to((int[])nArray), (int)0, null, null);
    }

    public void execute(EncogKernel encogKernel) {
        long[] lArray = new long[]{encogKernel.getGlobalWork()};
        long[] lArray2 = new long[]{encogKernel.getLocalWork()};
        CL.clEnqueueNDRangeKernel((cl_command_queue)this.commands, (cl_kernel)encogKernel.getKernel(), (int)1, null, (long[])lArray, (long[])lArray2, (int)0, null, null);
    }

    public cl_command_queue getCommands() {
        return this.commands;
    }

    public void waitFinish() {
        CL.clFinish((cl_command_queue)this.commands);
    }

    public EncogCLDevice getDevice() {
        return this.device;
    }
}

