/*
 * Decompiled with CFR 0.152.
 */
package org.encog.engine.network.train.prop;

import org.encog.engine.data.EngineDataSet;
import org.encog.engine.network.flat.FlatNetwork;
import org.encog.engine.network.train.prop.TrainFlatNetworkProp;

public class TrainFlatNetworkResilient
extends TrainFlatNetworkProp {
    private final double[] updateValues;
    private final double zeroTolerance;
    private final double maxStep;

    public TrainFlatNetworkResilient(FlatNetwork flatNetwork, EngineDataSet engineDataSet, double d, double d2, double d3) {
        super(flatNetwork, engineDataSet);
        this.updateValues = new double[flatNetwork.getWeights().length];
        this.zeroTolerance = d;
        this.maxStep = d3;
        for (int i = 0; i < this.updateValues.length; ++i) {
            this.updateValues[i] = d2;
        }
    }

    public TrainFlatNetworkResilient(FlatNetwork flatNetwork, EngineDataSet engineDataSet) {
        this(flatNetwork, engineDataSet, 1.0E-17, 0.1, 50.0);
    }

    private int sign(double d) {
        if (Math.abs(d) < this.zeroTolerance) {
            return 0;
        }
        if (d > 0.0) {
            return 1;
        }
        return -1;
    }

    public double updateWeight(double[] dArray, double[] dArray2, int n) {
        int n2 = this.sign(dArray[n] * dArray2[n]);
        double d = 0.0;
        if (n2 > 0) {
            double d2 = this.updateValues[n] * 1.2;
            d2 = Math.min(d2, this.maxStep);
            d = (double)this.sign(dArray[n]) * d2;
            this.updateValues[n] = d2;
            dArray2[n] = dArray[n];
        } else if (n2 < 0) {
            double d3 = this.updateValues[n] * 0.5;
            this.updateValues[n] = d3 = Math.max(d3, 1.0E-6);
            dArray2[n] = 0.0;
        } else if (n2 == 0) {
            double d4 = this.updateValues[n];
            d = (double)this.sign(dArray[n]) * d4;
            dArray2[n] = dArray[n];
        }
        return d;
    }

    public double[] getUpdateValues() {
        return this.updateValues;
    }
}

