/*
 * Decompiled with CFR 0.152.
 */
package org.encog.engine.network.flat;

import org.encog.engine.EngineMachineLearning;
import org.encog.engine.network.activation.ActivationFunction;
import org.encog.engine.network.flat.FlatNetwork;
import org.encog.engine.validate.BasicMachineLearningValidate;

public class ValidateForOpenCL
extends BasicMachineLearningValidate {
    public String isValid(EngineMachineLearning engineMachineLearning) {
        if (!(engineMachineLearning instanceof FlatNetwork)) {
            return "Only flat networks are valid to be used for OpenCL";
        }
        FlatNetwork flatNetwork = (FlatNetwork)engineMachineLearning;
        ActivationFunction[] activationFunctionArray = flatNetwork.getActivationFunctions();
        int n = activationFunctionArray.length;
        for (int i = 0; i < n; ++i) {
            ActivationFunction activationFunction = activationFunctionArray[i];
            if (activationFunction.getOpenCLExpression(true) != null) continue;
            return "Can't use OpenCL if activation function does not have an OpenCL expression.";
        }
        if (flatNetwork.hasSameActivationFunction() == null) {
            return "Can't use OpenCL training on a neural network that uses multiple activation functions.";
        }
        boolean bl = false;
        for (n = 0; n < flatNetwork.getLayerCounts().length; ++n) {
            if (flatNetwork.getContextTargetOffset()[n] != 0) {
                bl = true;
            }
            if (flatNetwork.getContextTargetSize()[n] == 0) continue;
            bl = true;
        }
        if (bl) {
            return "Can't use OpenCL if context neurons are present.";
        }
        return null;
    }
}

