/*
 * Decompiled with CFR 0.152.
 */
package org.encog.engine.network.activation;

import org.encog.engine.EncogEngineError;
import org.encog.engine.network.activation.ActivationFunction;

public class ActivationCompetitive
implements ActivationFunction {
    public static final int PARAM_COMPETITIVE_MAX_WINNERS = 0;
    private static final long serialVersionUID = 5396927873082336888L;
    private final double[] params = new double[1];

    public ActivationCompetitive() {
        this(1);
    }

    public ActivationCompetitive(int n) {
        this.params[0] = n;
    }

    public void activationFunction(double[] dArray, int n, int n2) {
        boolean[] blArray = new boolean[dArray.length];
        double d = 0.0;
        int n3 = 0;
        while ((double)n3 < this.params[0]) {
            double d2 = Double.NEGATIVE_INFINITY;
            int n4 = -1;
            for (int i = n; i < n + n2; ++i) {
                if (blArray[i] || !(dArray[i] > d2)) continue;
                n4 = i;
                d2 = dArray[i];
            }
            d += d2;
            blArray[n4] = true;
            ++n3;
        }
        for (n3 = n; n3 < n + n2; ++n3) {
            dArray[n3] = blArray[n3] ? dArray[n3] / d : 0.0;
        }
    }

    public ActivationFunction clone() {
        return new ActivationCompetitive((int)this.params[0]);
    }

    public double derivativeFunction(double d) {
        throw new EncogEngineError("Can't use the competitive activation function where a derivative is required.");
    }

    public int getMaxWinners() {
        return (int)this.params[0];
    }

    public String[] getParamNames() {
        String[] stringArray = new String[]{"maxWinners"};
        return stringArray;
    }

    public double[] getParams() {
        return this.params;
    }

    public boolean hasDerivative() {
        return false;
    }

    public void setParam(int n, double d) {
        this.params[n] = d;
    }

    public String getOpenCLExpression(boolean bl) {
        return null;
    }
}

