/*
 * Decompiled with CFR 0.152.
 */
package org.encog.cloud;

import java.util.HashMap;
import org.encog.cloud.CloudRequest;
import org.encog.cloud.EncogCloud;
import org.encog.cloud.EncogCloudError;

public class CloudTask {
    private final EncogCloud cloud;
    private String taskURL;

    public CloudTask(EncogCloud encogCloud) {
        this.cloud = encogCloud;
    }

    public EncogCloud getCloud() {
        return this.cloud;
    }

    public void init(String string) {
        if (this.cloud.getSession() == null) {
            throw new EncogCloudError("Session must be established before a task is created.");
        }
        CloudRequest cloudRequest = new CloudRequest();
        String string2 = this.cloud.getSession();
        string2 = string2 + "task/create";
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("name", string);
        hashMap.put("status", "Starting...");
        cloudRequest.performURLPOST(false, string2, hashMap);
        this.taskURL = this.cloud.getSession() + "task/" + cloudRequest.getResponseProperty("id") + "/";
    }

    public void setStatus(String string) {
        if (this.taskURL == null) {
            throw new EncogCloudError("Can't set status for inactive task.");
        }
        CloudRequest cloudRequest = new CloudRequest();
        String string2 = this.taskURL + "update";
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("status", string);
        cloudRequest.performURLPOST(true, string2, hashMap);
    }

    public void stop(String string) {
        if (this.taskURL == null) {
            throw new EncogCloudError("Can't stop inactive task.");
        }
        CloudRequest cloudRequest = new CloudRequest();
        String string2 = this.taskURL + "update";
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("status", string);
        cloudRequest.performURLPOST(false, string2, hashMap);
        string2 = this.taskURL + "stop";
        cloudRequest = new CloudRequest();
        cloudRequest.performURLGET(false, string2);
    }
}

