/*
 * Decompiled with CFR 0.152.
 */
package org.encog.cloud;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import org.encog.bot.BotUtil;
import org.encog.cloud.AsynchronousCloudRequest;
import org.encog.cloud.EncogCloudError;
import org.encog.parse.tags.read.ReadXML;
import org.encog.util.http.FormUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloudRequest {
    private Map<String, String> headerProperties = new HashMap<String, String>();
    private Map<String, String> sessionProperties = new HashMap<String, String>();
    private Map<String, String> responseProperties = new HashMap<String, String>();

    public String getMessage() {
        return this.headerProperties.get("message");
    }

    public String getResponseProperty(String string) {
        return this.responseProperties.get(string);
    }

    public String getService() {
        return this.headerProperties.get("service");
    }

    public String getSession() {
        return this.sessionProperties.get("url");
    }

    public String getStatus() {
        return this.headerProperties.get("status");
    }

    private void handleResponse(String string) {
        int n;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        ReadXML readXML = new ReadXML(byteArrayInputStream);
        while ((n = readXML.read()) != -1) {
            if (n != 0 || !readXML.getTag().getName().equalsIgnoreCase("EncogCloud")) continue;
            this.processCloud(readXML);
        }
        if (this.getStatus() == null || this.getStatus().equals("failed")) {
            throw new EncogCloudError(this.getMessage());
        }
    }

    public void performURLGET(boolean bl, String string) {
        try {
            if (bl) {
                AsynchronousCloudRequest asynchronousCloudRequest = new AsynchronousCloudRequest(new URL(string));
                Thread thread = new Thread(asynchronousCloudRequest);
                thread.setDaemon(true);
                thread.start();
            } else {
                URL uRL = new URL(string);
                URLConnection uRLConnection = uRL.openConnection();
                String string2 = BotUtil.loadPage(uRLConnection.getInputStream());
                this.handleResponse(string2);
            }
        }
        catch (IOException iOException) {
            throw new EncogCloudError(iOException);
        }
    }

    public void performURLPOST(boolean bl, String string, Map<String, String> map) {
        try {
            if (bl) {
                AsynchronousCloudRequest asynchronousCloudRequest = new AsynchronousCloudRequest(new URL(string), map);
                Thread thread = new Thread(asynchronousCloudRequest);
                thread.setDaemon(true);
                thread.start();
            } else {
                URL uRL = new URL(string);
                URLConnection uRLConnection = uRL.openConnection();
                uRLConnection.setDoOutput(true);
                OutputStream outputStream = uRLConnection.getOutputStream();
                FormUtility formUtility = new FormUtility(outputStream, null);
                for (String string2 : map.keySet()) {
                    formUtility.add(string2, map.get(string2));
                }
                formUtility.complete();
                String string3 = BotUtil.loadPage(uRLConnection.getInputStream());
                this.handleResponse(string3);
            }
        }
        catch (IOException iOException) {
            throw new EncogCloudError(iOException);
        }
    }

    private void processCloud(ReadXML readXML) {
        int n;
        while ((n = readXML.read()) != -1) {
            if (n != 0) continue;
            if (readXML.getTag().getName().equalsIgnoreCase("Header")) {
                this.headerProperties = readXML.readPropertyBlock();
                continue;
            }
            if (readXML.getTag().getName().equalsIgnoreCase("Session")) {
                this.sessionProperties = readXML.readPropertyBlock();
                continue;
            }
            if (!readXML.getTag().getName().equalsIgnoreCase("Response")) continue;
            this.responseProperties = readXML.readPropertyBlock();
        }
    }
}

