/*
 * Decompiled with CFR 0.152.
 */
package jams.math.statistics;

import jams.data.DataSupplier;
import jams.math.distributions.CDF_Normal;
import jams.model.JAMSComponent;
import java.util.Arrays;

public class MannKendall
extends JAMSComponent {
    public static double[] LinearRegression(DataSupplier<Double> y) {
        int n = y.size();
        double sx = 0.0;
        double sy = 0.0;
        for (int i = 0; i < n; ++i) {
            sx += (double)i;
            sy += y.get(i).doubleValue();
        }
        double xm = sx / (double)n;
        double ym = sy / (double)n;
        double numerator = 0.0;
        double denominator = 0.0;
        double sum_for_V = 0.0;
        for (int i = 0; i < n; ++i) {
            numerator += ((double)i - xm) * (y.get(i) - ym);
            denominator += ((double)i - xm) * ((double)i - xm);
            sum_for_V += (y.get(i) - ym) * (y.get(i) - ym);
        }
        double a = numerator / denominator;
        double V = 0.0;
        V = ym != 0.0 ? Math.sqrt(sum_for_V / (double)n) / ym : Double.NaN;
        double r2 = numerator * numerator / (denominator * sum_for_V);
        double b = ym - a * xm;
        return new double[]{a, b, r2, V};
    }

    public static double[] Kendall(DataSupplier<Double> y) throws ArithmeticException, IllegalArgumentException {
        int n = y.size();
        boolean ties = false;
        double[] iw = new double[n];
        Arrays.fill(iw, 0.0);
        double prob = 1.0;
        double sltau = 1.0;
        double tau = 1.0;
        double denom = 0.0;
        double vars = 0.0;
        double s = 0.0;
        if (n < 2) {
            throw new IllegalArgumentException("n smaller than 2");
        }
        boolean swy = true;
        for (int i = 1; i < n; ++i) {
            if (y.get(i) == y.get(i - 1)) continue;
            swy = false;
        }
        boolean sw = false | swy;
        double cn = n * (n - 1);
        double dn = 0.5 * cn;
        double sumt = 0.0;
        double suma1 = 0.0;
        double suma2 = 0.0;
        for (int i = 0; i < n - 1; ++i) {
            for (int j = i + 1; j < n; ++j) {
                s += (double)MannKendall.scoreK(i, y.get(i), j, y.get(j));
            }
        }
        double d1 = Math.sqrt(dn);
        Arrays.fill(iw, 0.0);
        double sumu = 0.0;
        double sumb1 = 0.0;
        double sumb2 = 0.0;
        for (int i = 0; i < n - 1; ++i) {
            double tmp = 1.0;
            for (int j = i + 1; j < n; ++j) {
                if (y.get(i) != y.get(j) || iw[j] == 1.0) continue;
                iw[j] = 1.0;
                tmp += 1.0;
                ties = true;
            }
            sumu += tmp * (tmp - 1.0);
            sumb1 += tmp * (tmp - 1.0) * (2.0 * tmp + 5.0);
            sumb2 += tmp * (tmp - 1.0) * (tmp - 2.0);
        }
        double d2 = Math.sqrt(dn - 0.5 * sumu);
        if (d1 <= 0.0 || d2 <= 0.0) {
            throw new ArithmeticException("d1 or d2 is smaller than zero");
        }
        denom = d1 * d2;
        tau = s / denom;
        double vars1 = (cn * (double)(2 * n + 5) - suma1 - sumb1) / 18.0;
        double vars2 = suma2 * sumb2 / (9.0 * cn * (double)(n - 2));
        double vars3 = sumt * sumu / (cn + cn);
        vars = vars1 + vars2 + vars3;
        double sds = Math.sqrt(vars);
        if (sw) {
            int is = (int)s;
            prob = 1.0 - MannKendall.prtaus(is, n);
        } else if (n > 3) {
            double scor = 0.0;
            if (s > 0.0) {
                scor = s - 1.0;
            }
            if (s < 0.0) {
                scor = s + 1.0;
            }
            double zscore = scor / sds;
            prob = MannKendall.alnorm(zscore, false);
        } else {
            throw new IllegalArgumentException("n smaller than 4");
        }
        sltau = prob > 0.5 ? 2.0 * (1.0 - prob) : 2.0 * prob;
        return new double[]{tau, sltau, s, denom, vars};
    }

    public static double[] MannKendall(double[] x, double[] y) throws ArithmeticException, IllegalArgumentException {
        int n = x.length;
        if (n != y.length) {
            System.out.println("Error x and y does not have the same length");
        }
        boolean ties = false;
        double[] iw = new double[n];
        Arrays.fill(iw, 0.0);
        double prob = 1.0;
        double sltau = 1.0;
        double tau = 1.0;
        double denom = 0.0;
        double vars = 0.0;
        double s = 0.0;
        if (n < 2) {
            throw new IllegalArgumentException("n smaller than 2");
        }
        boolean swx = true;
        boolean swy = true;
        for (int i = 1; i < n; ++i) {
            if (x[i] != x[i - 1]) {
                swx = false;
            }
            if (y[i] == y[i - 1]) continue;
            swy = false;
        }
        boolean sw = swx | swy;
        if (!sw) {
            int i;
            double cn = n * (n - 1);
            double dn = 0.5 * cn;
            double sumt = 0.0;
            double suma1 = 0.0;
            double suma2 = 0.0;
            for (i = 0; i < n - 1; ++i) {
                for (int j = i + 1; j < n; ++j) {
                    s += (double)MannKendall.scoreK(x[i], y[i], x[j], y[j]);
                }
            }
            for (i = 0; i < n - 1; ++i) {
                double tmp = 1.0;
                for (int j = i + 1; j < n; ++j) {
                    if (x[i] != x[j] || iw[j] == 1.0) continue;
                    iw[j] = 1.0;
                    tmp += 1.0;
                    ties = true;
                }
                sumt += tmp * (tmp - 1.0);
                suma1 += tmp * (tmp - 1.0) * (2.0 * tmp + 5.0);
                suma2 += tmp * (tmp - 1.0) * (tmp - 2.0);
            }
            double d1 = Math.sqrt(dn - 0.5 * sumt);
            Arrays.fill(iw, 0.0);
            double sumu = 0.0;
            double sumb1 = 0.0;
            double sumb2 = 0.0;
            for (int i2 = 0; i2 < n - 1; ++i2) {
                double tmp = 1.0;
                for (int j = i2 + 1; j < n; ++j) {
                    if (y[i2] != y[j] || iw[j] == 1.0) continue;
                    iw[j] = 1.0;
                    tmp += 1.0;
                    ties = true;
                }
                sumu += tmp * (tmp - 1.0);
                sumb1 += tmp * (tmp - 1.0) * (2.0 * tmp + 5.0);
                sumb2 += tmp * (tmp - 1.0) * (tmp - 2.0);
            }
            double d2 = Math.sqrt(dn - 0.5 * sumu);
            if (d1 <= 0.0 || d2 <= 0.0) {
                throw new ArithmeticException("d1 or d2 is smaller than zero");
            }
            denom = d1 * d2;
            tau = s / denom;
            double vars1 = (cn * (double)(2 * n + 5) - suma1 - sumb1) / 18.0;
            double vars2 = suma2 * sumb2 / (9.0 * cn * (double)(n - 2));
            double vars3 = sumt * sumu / (cn + cn);
            vars = vars1 + vars2 + vars3;
            double sds = Math.sqrt(vars);
            if (sw) {
                int is = (int)s;
                prob = 1.0 - MannKendall.prtaus(is, n);
            } else if (n > 3) {
                double scor = 0.0;
                if (s > 0.0) {
                    scor = s - 1.0;
                }
                if (s < 0.0) {
                    scor = s + 1.0;
                }
                double zscore = scor / sds;
                prob = MannKendall.alnorm(zscore, false);
            } else {
                throw new IllegalArgumentException("n smaller than 4");
            }
            sltau = prob > 0.5 ? 2.0 * (1.0 - prob) : 2.0 * prob;
        }
        return new double[]{tau, sltau, s, denom, vars};
    }

    private static int scoreK(double x1, double y1, double x2, double y2) {
        if (x1 > x2 && y1 < y2 || x1 < x2 && y1 > y2) {
            return -1;
        }
        if (x1 == x2 || y1 == y2) {
            return 0;
        }
        return 1;
    }

    private static double alnorm(double z, boolean upper) {
        if (upper) {
            return 1.0 - CDF_Normal.normp(z);
        }
        return CDF_Normal.normp(z);
    }

    private static double prtaus(int is, int n) throws ArithmeticException {
        double[] H = new double[15];
        double[][] L = new double[2][15];
        double prtaus = 1.0;
        if (n < 1) {
            throw new ArithmeticException("n smaller than 1");
        }
        int m = n * (n - 1) / 2 - Math.abs(is);
        if (m < 0 || m % 2 == 1) {
            throw new ArithmeticException("m smaller 0 or m % 2 != 1");
        }
        if (m == 0 && is <= 0) {
            return prtaus;
        }
        if (n > 8) {
            double x;
            H[1] = x = (double)(is - 1) / Math.sqrt((6.0 + (double)(n * (5 - n * (3 + 2 * n)))) / 18.0);
            H[2] = x * x - 1.0;
            for (int i = 2; i < 15; ++i) {
                H[i] = x * H[i - 1] - (double)i * H[i - 2];
            }
            double R = 1.0 / (double)n;
            double sc = R * (H[2] * (-0.09 + R * (0.045 + R * (-0.5325 + R * 0.506))) + R * (H[4] * (0.036735 + R * (-0.036735 + R * 0.3214)) + H[6] * (0.00405 + R * (-0.023336 + R * 0.07787)) + R * (H[8] * (-0.0033061 - R * 0.0065166) + H[10] * (-1.215E-4 + R * 0.0025927) + R * (H[12] * 1.4878E-4 + H[14] * 2.7338E-6))));
            prtaus = MannKendall.alnorm(x, true) + sc * 0.398942 * Math.exp(-0.5 * x * x);
            if (prtaus < 0.0) {
                prtaus = 0.0;
            }
            if (prtaus > 1.0) {
                prtaus = 1.0;
            }
        } else {
            if (is < 0) {
                m -= 2;
            }
            int im = m / 2 + 1;
            L[0][0] = 1.0;
            L[1][0] = 1.0;
            if (im > 2) {
                for (int i = 1; i < im; ++i) {
                    L[0][i] = 0.0;
                    L[1][i] = 0.0;
                }
            }
            int il = 1;
            int i = 1;
            m = 1;
            int j = 1;
            int jj = 2;
            int k = 0;
            while (i != n) {
                il += i;
                m *= ++i;
                j = 3 - j;
                jj = 3 - jj;
                int in = 1;
                int io = 0;
                k = Math.min(im, il);
                while (++in <= k) {
                    L[jj - 1][in - 1] = L[jj - 1][in - 2] + L[j - 1][in - 1];
                    if (in <= i) continue;
                    L[jj - 1][in - 1] = L[jj - 1][in - 1] - L[j - 1][++io - 1];
                }
            }
            k = 0;
            for (i = 0; i < im; ++i) {
                k = (int)((double)k + L[jj - 1][i - 1]);
            }
            prtaus = (double)k / (double)m;
            if (is < 0) {
                prtaus = 1.0 - prtaus;
            }
        }
        return prtaus;
    }

    public static void main(String[] args) {
        double[] x = new double[]{3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 21.0, 22.0, 23.0, 24.0, 25.0, 26.0, 27.0, 28.0, 29.0, 30.0, 31.0, 32.0, 33.0, 34.0, 35.0, 36.0, 37.0, 38.0, 39.0, 40.0, 41.0, 42.0, 43.0, 44.0};
        double[] y = new double[]{-20.3842, -17.8077, -19.7061, -20.1293, -16.7293, -18.6905, -19.7784, -19.7762, -19.6263, -21.9088, -17.5987, -19.9948, -15.9491, -16.1833, -23.191110000000002, -16.3191, -14.739, -16.3836, -24.1302, -16.2833, -17.6094, -17.2104, -15.3389, -14.4962, -21.5657, -21.7806, -22.9638, -12.8531, -12.9116, -11.0472, -20.5962, -12.8523, -17.6314, -16.4436, -15.0671, -20.6585, -18.061, -17.0422, -14.0356, -16.0468, -15.9699};
        for (int i = 0; i < 30; ++i) {
            MannKendall mk = new MannKendall();
            double[] x1 = new double[10];
            double[] y1 = new double[10];
            for (int j = 0; j < 10; ++j) {
                x1[j] = x[i + j];
                y1[j] = y[i + j];
            }
            double[] r = MannKendall.MannKendall(x1, y1);
            System.out.println("tau:" + r[0]);
            System.out.println("sltau:" + r[1]);
            System.out.println("s:" + r[2]);
            System.out.println("denom:" + r[3]);
            System.out.println("vars:" + r[4]);
        }
    }
}

