/*
 * Decompiled with CFR 0.152.
 */
package jams.math.distributions;

import jams.math.distributions.CDF_Normal;
import jams.math.distributions.CDF_Normal_Amos;
import jams.math.distributions.Derf;
import jams.math.distributions.Fzero;
import jams.math.distributions.Fzero_methods;
import jams.math.distributions.Gaus8;
import jams.math.distributions.Gaus8_fcn;

public class CDF_nct_Amos
implements Gaus8_fcn,
Fzero_methods {
    double h2o2;
    double p_inv;
    double delta_inv;
    double dof_inv;

    public static double fnct(double x, double delta, double dof) {
        double srtp = 2.506628274631;
        double osrtp = 0.398942280401432;
        double[] rel = new double[1];
        double[] t2 = new double[1];
        int[] nz = new int[1];
        if (dof < 1.0) {
            double p = -1.0;
            System.out.print("\nError in call to fnct: The degrees of freedom was less than 1.\n\n");
            return p;
        }
        double tol = 1.0E-15;
        rel[0] = tol * 10.0;
        double a = x / Math.sqrt(dof);
        double b = dof / (dof + x * x);
        double srb = Math.sqrt(b);
        int ndof = (int)dof;
        if (ndof % 2 == 1) {
            double x1 = delta * srb;
            double xn = -x1;
            int kode = 1;
            double t1 = CDF_Normal_Amos.fnorm(xn, kode, nz);
            CDF_nct_Amos.tha(x1, a, rel, t2);
            if (ndof == 1) {
                double p = t1 + t2[0] + t2[0];
                return p;
            }
            double asrb = a * srb;
            double x2 = x1 * a;
            double x3 = delta * a;
            kode = 1;
            double g2 = CDF_Normal_Amos.fnorm(x2, kode, nz);
            double gprime = 0.398942280401432 * Math.exp(-x1 * x1 / 2.0);
            double cm0 = asrb * gprime * g2;
            gprime = 0.398942280401432 * Math.exp(-delta * delta / 2.0);
            double cm1 = b * (x3 * cm0 + a / 2.506628274631 * gprime);
            double cm2 = 0.5 * b * (x3 * cm1 + cm0);
            double fk = 3.0;
            double ak = 1.0;
            int n = (ndof - 3) / 2;
            if (n - 1 < 0) {
                double p = t1 + t2[0] + t2[0] + cm1 + cm1;
                return p;
            }
            if (n - 1 == 0) {
                x1 = b / 3.0;
                x2 = cm1 + (x1 + x1) * (x3 * cm2 + cm1);
                double p = t1 + t2[0] + t2[0] + x2 + x2;
                return p;
            }
            double ss = cm1;
            for (int j = 1; j <= n; ++j) {
                double cmk = (fk - 1.0) / fk * b * (ak * x3 * cm2 + cm1);
                ss += cmk;
                ak = 1.0 / (((fk += 1.0) - 2.0) * ak);
                cm1 = cm2;
                cm2 = cmk;
                cmk = (fk - 1.0) / fk * b * (ak * x3 * cm2 + cm1);
                ak = 1.0 / (((fk += 1.0) - 2.0) * ak);
                cm1 = cm2;
                cm2 = cmk;
            }
            double p = t1 + t2[0] + t2[0] + ss + ss;
            return p;
        }
        double y1 = -delta;
        int kode = 1;
        double t1 = CDF_Normal_Amos.fnorm(y1, kode, nz);
        double x1 = a * srb;
        double x2 = delta * x1;
        double x3 = delta * a;
        kode = 1;
        double g2 = CDF_Normal_Amos.fnorm(x2, kode, nz);
        double arg = -delta * delta * srb * srb / 2.0;
        double gprime = 0.398942280401432 * Math.exp(arg);
        double cm0 = x1 * gprime * g2;
        ndof = (int)dof;
        int n = ndof / 2;
        if (n == 1) {
            double p = t1 + 2.506628274631 * cm0;
            return p;
        }
        gprime = 0.398942280401432 * Math.exp(-delta * delta / 2.0);
        double cm1 = b * (x3 * cm0 + a / 2.506628274631 * gprime);
        double cm2 = b / 2.0 * (x3 * cm1 + cm0);
        if (n == 2) {
            double p = t1 + 2.506628274631 * (cm0 + cm2);
            return p;
        }
        double fk = 3.0;
        double ak = 1.0;
        double ss = cm0 + cm2;
        int nt = n - 2;
        for (int j = 1; j <= nt; ++j) {
            double cmk = (fk - 1.0) / fk * b * (ak * x3 * cm2 + cm1);
            ak = 1.0 / (((fk += 1.0) - 2.0) * ak);
            cm1 = cm2;
            cm2 = cmk;
            cmk = (fk - 1.0) / fk * b * (ak * x3 * cm2 + cm1);
            ss += cmk;
            ak = 1.0 / (((fk += 1.0) - 2.0) * ak);
            cm1 = cm2;
            cm2 = cmk;
        }
        double p = t1 + 2.506628274631 * ss;
        return p;
    }

    public static double fnct_inv(double p, double delta, double dof) {
        double phigh;
        double plow;
        double add;
        double[] b = new double[2];
        double[] c = new double[2];
        int[] iflag = new int[2];
        CDF_nct_Amos cdf_nct_amos = new CDF_nct_Amos();
        cdf_nct_amos.p_inv = p;
        cdf_nct_amos.delta_inv = delta;
        cdf_nct_amos.dof_inv = dof;
        double norminv = CDF_Normal.xnormi(p);
        double add0 = norminv * (add = Math.sqrt(delta * delta / (2.0 * dof) + 1.0));
        double xx = delta + add0;
        double pp = CDF_nct_Amos.fnct(xx, delta, dof);
        if (pp < p) {
            plow = pp;
            b[1] = xx;
            while (!((phigh = CDF_nct_Amos.fnct(xx += add, delta, dof)) >= p)) {
            }
            c[1] = xx;
        } else {
            phigh = pp;
            c[1] = xx;
            while (!((plow = CDF_nct_Amos.fnct(xx -= add, delta, dof)) <= p)) {
            }
            b[1] = xx;
        }
        double r = b[1] + (p - plow) / (phigh - plow) * (c[1] - b[1]);
        double re = 1.0E-6;
        double ae = 1.0E-5;
        Fzero.fzero(cdf_nct_amos, b, c, r, re, ae, iflag);
        return b[1];
    }

    public static void tha(double h, double a, double[] rel, double[] ans) {
        double t3;
        double otpi = 0.159154943091895;
        double srt2 = 1.4142135623731;
        int[] ierr = new int[1];
        int[] nr = new int[1];
        CDF_nct_Amos cdf_nct_amos = new CDF_nct_Amos();
        double aa = a;
        double hh = h;
        if (aa == 0.0) {
            ans[0] = 0.0;
            return;
        }
        double ab = Math.abs(aa);
        if (hh == 0.0) {
            ans[0] = 0.159154943091895 * Math.atan(ab);
            if (aa < 0.0) {
                ans[0] = -ans[0];
            }
            return;
        }
        if (hh < 0.0) {
            hh = Math.abs(hh);
        }
        double elim = 701.6150658592362;
        if (ab <= 1.0) {
            double h2 = hh * hh;
            cdf_nct_amos.h2o2 = 0.5 * h2;
            if (cdf_nct_amos.h2o2 >= elim) {
                ans[0] = 0.0;
                return;
            }
            ans[0] = Gaus8.gaus8(cdf_nct_amos, 0.0, ab, rel, ierr);
            if (ierr[0] == 2) {
                System.out.print("\n\nERROR: In tha, gaus8 returned ierr[0] equal to 2.\n\n");
                return;
            }
            ans[0] = ans[0] * 0.159154943091895;
            if (aa < 0.0) {
                ans[0] = -ans[0];
            }
            return;
        }
        double c1 = hh / 1.4142135623731;
        double c2 = (hh *= ab) / 1.4142135623731;
        double h2 = hh * hh;
        cdf_nct_amos.h2o2 = 0.5 * h2;
        ab = 1.0 / ab;
        if (cdf_nct_amos.h2o2 < elim) {
            t3 = Gaus8.gaus8(cdf_nct_amos, 0.0, ab, rel, ierr);
            if (ierr[0] == 2) {
                System.out.print("\n\nERROR: In tha, gaus8 returned ierr[0] equal to 2.\n\n");
                return;
            }
        } else {
            t3 = 0.0;
        }
        if (c1 < 2.0 || c2 < 2.0) {
            double t1 = Derf.derf(c1);
            double t2 = Derf.derf(c2);
            ans[0] = 0.25 * (2.0 + t1 + t2 - (1.0 + t1) * (1.0 + t2)) - t3 * 0.159154943091895;
            if (aa < 0.0) {
                ans[0] = -ans[0];
            }
            return;
        }
        double t4 = Derf.derfc(c1);
        double t5 = Derf.derfc(c2);
        ans[0] = 0.25 * (t4 + t5 - t4 * t5) - t3 * 0.159154943091895;
        if (aa < 0.0) {
            ans[0] = -ans[0];
        }
    }

    @Override
    public double f_to_integrate(double x) {
        double opx2 = 1.0 + x * x;
        double ftha = Math.exp(-this.h2o2 * opx2) / opx2;
        return ftha;
    }

    @Override
    public double f_to_zero(double x) {
        double diff = this.p_inv - CDF_nct_Amos.fnct(x, this.delta_inv, this.dof_inv);
        return diff;
    }
}

