/*
 * Decompiled with CFR 0.152.
 */
package jams.gui.input;

import jams.gui.input.InputComponent;
import jams.gui.input.ValueChangeListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class TextInput
extends JPanel
implements InputComponent {
    private JTextField text = new JTextField();
    private ValueChangeListener l;
    private Color oldColor;

    public TextInput() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.text, "West");
    }

    @Override
    public String getValue() {
        return this.text.getText();
    }

    @Override
    public void setValue(String value) {
        this.text.setText(value);
    }

    @Override
    public JComponent getComponent() {
        return this.text;
    }

    @Override
    public void setRange(double lower, double upper) {
    }

    @Override
    public boolean verify() {
        return true;
    }

    @Override
    public int getErrorCode() {
        return 0;
    }

    @Override
    public void setLength(int length) {
        this.text.setColumns(length);
    }

    @Override
    public void addValueChangeListener(ValueChangeListener l) {
        this.l = l;
        this.text.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                TextInput.this.l.valueChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                TextInput.this.l.valueChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                TextInput.this.l.valueChanged();
            }
        });
    }

    @Override
    public void setMarked(boolean marked) {
        if (marked) {
            this.oldColor = this.text.getBackground();
            this.text.setBackground(new Color(255, 0, 0));
        } else {
            this.text.setBackground(this.oldColor);
        }
    }

    @Override
    public void setHelpText(String text) {
        text = "<html>" + text + "</html>";
        this.getComponent().setToolTipText(text);
    }
}

