/*
 * Decompiled with CFR 0.152.
 */
package jams.gui.input;

import jams.gui.input.InputComponent;
import jams.gui.input.ValueChangeListener;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;

public class BooleanInput
extends JCheckBox
implements InputComponent {
    private ValueChangeListener l;
    private Color oldColor;

    @Override
    public String getValue() {
        if (this.isSelected()) {
            return "true";
        }
        return "false";
    }

    @Override
    public void setValue(String value) {
        if ("1".equals(value) || "true".equals(value)) {
            this.setSelected(true);
        } else {
            this.setSelected(false);
        }
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public void setRange(double lower, double upper) {
    }

    @Override
    public boolean verify() {
        return true;
    }

    @Override
    public int getErrorCode() {
        return 0;
    }

    @Override
    public void setLength(int length) {
    }

    @Override
    public void addValueChangeListener(ValueChangeListener l) {
        this.l = l;
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BooleanInput.this.l.valueChanged();
            }
        });
    }

    @Override
    public void setMarked(boolean marked) {
        if (marked) {
            this.oldColor = this.getBackground();
            this.setBackground(new Color(255, 0, 0));
        } else {
            this.setBackground(this.oldColor);
        }
    }

    @Override
    public void setHelpText(String text) {
        text = "<html>" + text + "</html>";
        this.getComponent().setToolTipText(text);
    }
}

