/*
 * Decompiled with CFR 0.152.
 */
package jams.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingWorker;

public class WorkerDlg
extends JDialog {
    protected Runnable task;
    protected SwingWorker worker;
    protected Window owner;
    protected JProgressBar progressBar;
    protected JLabel label = null;
    protected JPanel mainPanel = null;

    public WorkerDlg(Window owner, String title) {
        this(owner, title, "");
    }

    public WorkerDlg(Window owner, String title, String message) {
        super(owner);
        this.owner = owner;
        this.setModal(true);
        this.setDefaultCloseOperation(0);
        this.setTitle(title);
        this.setLocationRelativeTo(owner);
        this.mainPanel = new JPanel(new BorderLayout());
        this.setResizable(false);
        if (!message.equals("")) {
            this.label = new JLabel(message);
            this.mainPanel.add((Component)this.label, "North");
        }
        this.progressBar = new JProgressBar();
        this.progressBar.setIndeterminate(true);
        this.progressBar.setPreferredSize(new Dimension(300, 20));
        this.mainPanel.add((Component)this.progressBar, "Center");
        this.add(this.mainPanel);
        this.pack();
    }

    public JPanel getMainPanel() {
        return this.mainPanel;
    }

    public void setMainPanel(JPanel mainPanel) {
        this.remove(this.mainPanel);
        this.mainPanel = mainPanel;
        this.add(mainPanel);
    }

    public void setInderminate(boolean value) {
        if (value) {
            this.progressBar.setStringPainted(false);
        } else {
            this.progressBar.setStringPainted(true);
        }
        this.progressBar.setIndeterminate(value);
    }

    public void setProgress(int value) {
        this.progressBar.setValue(value);
    }

    public void setProgressMax(int value) {
        this.progressBar.setMaximum(value);
    }

    public void execute() {
        if (this.owner != null) {
            Dimension ownerDim = this.owner.getSize();
            Dimension thisDim = this.getSize();
            int x = this.owner.getX() + (ownerDim.width - thisDim.width) / 2;
            int y = this.owner.getY() + (ownerDim.height - thisDim.height) / 2;
            this.setLocation(x, y);
        }
        this.worker.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("state") && evt.getNewValue() == SwingWorker.StateValue.DONE) {
                    WorkerDlg.this.setVisible(false);
                    WorkerDlg.this.dispose();
                }
            }
        });
        this.worker.execute();
        this.setVisible(true);
    }

    public void setTask(Runnable task) {
        this.task = task;
        this.worker = new SwingWorker<Object, Void>(){

            @Override
            public Object doInBackground() {
                WorkerDlg.this.task.run();
                return WorkerDlg.this.task;
            }
        };
    }

    public synchronized void setTask(SwingWorker worker) {
        this.worker = worker;
    }

    public void setMessage(String text) {
        this.label.setText(text);
        this.invalidate();
        this.pack();
    }
}

