/*
 * Decompiled with CFR 0.152.
 */
package jams.gui;

import jams.JAMS;
import jams.SystemProperties;
import jams.gui.input.BooleanInput;
import jams.gui.input.FileInput;
import jams.gui.input.FileListInput;
import jams.gui.input.TextInput;
import jams.gui.tools.GUIHelper;
import jams.tools.StringTools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.KeyStroke;
import javax.swing.SpinnerListModel;

public class PropertyDlg
extends JDialog {
    private static final int JCOMP_HEIGHT = 20;
    private FileListInput list;
    private BooleanInput verboseCheck;
    private BooleanInput debugMode;
    private BooleanInput windowEnable;
    private BooleanInput windowOnTop;
    private BooleanInput errorDlg;
    private BooleanInput profiling;
    private BooleanInput defaultWSPath;
    private BooleanInput preprocessing;
    private BooleanInput autoSaveLogs;
    private BooleanInput autoSaveParams;
    private JSpinner debugSpinner;
    private JComboBox<String> locale;
    private FileInput infoFile;
    private FileInput errorFile;
    private FileInput docbookDir;
    private TextInput windowHeight;
    private TextInput windowWidth;
    private TextInput helpBaseURL;
    private TextInput userName;
    private TextInput charset;
    private TextInput explorerDigits;
    private TextInput jamsDecFormat;
    private SystemProperties properties;
    public static final int APPROVE_OPTION = 1;
    public static final int CANCEL_OPTION = 0;
    private int result = 0;

    public PropertyDlg(Frame owner, SystemProperties properties) {
        super(owner);
        this.setLayout(new BorderLayout());
        this.setLocationByPlatform(true);
        this.setDefaultCloseOperation(1);
        this.properties = properties;
        this.setTitle(JAMS.i18n("JAMS_Preferences"));
        this.setModal(true);
        JPanel contentPanel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        contentPanel.setLayout(gbl);
        int y = 0;
        GUIHelper.addGBComponent(contentPanel, gbl, new JLabel(JAMS.i18n("Libraries:")), 0, y, 1, 1, 0.0, 0.0);
        this.list = new FileListInput();
        this.list.setPreferredSize(new Dimension(295, 130));
        GUIHelper.addGBComponent(contentPanel, gbl, this.list, 1, y, 1, 1, 1.0, 1.0);
        GUIHelper.addGBComponent(contentPanel, gbl, new JLabel(JAMS.i18n("Command_line_output:")), 0, ++y, 1, 1, 0.0, 0.0);
        this.verboseCheck = new BooleanInput();
        this.verboseCheck.setPreferredSize(new Dimension(295, 20));
        GUIHelper.addGBComponent(contentPanel, gbl, this.verboseCheck, 1, y, 1, 1, 1.0, 1.0);
        GUIHelper.addGBComponent(contentPanel, gbl, new JLabel(JAMS.i18n("Debug_mode:")), 0, ++y, 1, 1, 0.0, 0.0);
        this.debugMode = new BooleanInput();
        this.debugMode.setPreferredSize(new Dimension(295, 20));
        GUIHelper.addGBComponent(contentPanel, gbl, this.debugMode, 1, y, 1, 1, 1.0, 1.0);
        GUIHelper.addGBComponent(contentPanel, gbl, new JLabel(JAMS.i18n("Create_profile_info:")), 0, ++y, 1, 1, 0.0, 0.0);
        this.profiling = new BooleanInput();
        this.profiling.setPreferredSize(new Dimension(295, 20));
        GUIHelper.addGBComponent(contentPanel, gbl, this.profiling, 1, y, 1, 1, 1.0, 1.0);
        GUIHelper.addGBComponent(contentPanel, gbl, new JLabel(JAMS.i18n("Preprocessing:")), 0, ++y, 1, 1, 0.0, 0.0);
        this.preprocessing = new BooleanInput();
        this.preprocessing.setPreferredSize(new Dimension(295, 20));
        GUIHelper.addGBComponent(contentPanel, gbl, this.preprocessing, 1, y, 1, 1, 1.0, 1.0);
        GUIHelper.addGBComponent(contentPanel, gbl, new JLabel(JAMS.i18n("Verbosity_level:")), 0, ++y, 1, 1, 0.0, 0.0);
        this.debugSpinner = new JSpinner();
        JPanel spinnerPanel = new JPanel();
        spinnerPanel.setLayout(new BorderLayout());
        spinnerPanel.add((Component)this.debugSpinner, "West");
        ArrayList<Integer> vals = new ArrayList<Integer>();
        vals.add(0);
        vals.add(1);
        vals.add(2);
        vals.add(3);
        SpinnerListModel sModel = new SpinnerListModel(vals);
        this.debugSpinner.setModel(sModel);
        this.debugSpinner.setPreferredSize(new Dimension(35, 26));
        GUIHelper.addGBComponent(contentPanel, gbl, spinnerPanel, 1, y, 1, 1, 0.0, 0.0);
        GUIHelper.addGBComponent(contentPanel, gbl, new JLabel(JAMS.i18n("Auto_save_logs:")), 0, ++y, 1, 1, 0.0, 0.0);
        this.autoSaveLogs = new BooleanInput();
        this.autoSaveLogs.setPreferredSize(new Dimension(295, 20));
        GUIHelper.addGBComponent(contentPanel, gbl, this.autoSaveLogs, 1, y, 1, 1, 1.0, 1.0);
        GUIHelper.addGBComponent(contentPanel, gbl, new JLabel(JAMS.i18n("Auto_save_params:")), 0, ++y, 1, 1, 0.0, 0.0);
        this.autoSaveParams = new BooleanInput();
        this.autoSaveParams.setPreferredSize(new Dimension(295, 20));
        GUIHelper.addGBComponent(contentPanel, gbl, this.autoSaveParams, 1, y, 1, 1, 1.0, 1.0);
        GUIHelper.addGBComponent(contentPanel, gbl, new JLabel(JAMS.i18n("Info_log_file:")), 0, ++y, 1, 1, 0.0, 0.0);
        this.infoFile = new FileInput();
        this.infoFile.setPreferredSize(new Dimension(286, 20));
        GUIHelper.addGBComponent(contentPanel, gbl, this.infoFile, 1, y, 1, 1, 1.0, 1.0);
        GUIHelper.addGBComponent(contentPanel, gbl, new JLabel(JAMS.i18n("Error_log_file:")), 0, ++y, 1, 1, 0.0, 0.0);
        this.errorFile = new FileInput();
        this.errorFile.setPreferredSize(new Dimension(286, 20));
        GUIHelper.addGBComponent(contentPanel, gbl, this.errorFile, 1, y, 1, 1, 1.0, 1.0);
        GUIHelper.addGBComponent(contentPanel, gbl, new JLabel(JAMS.i18n("Model_window_visible:")), 0, ++y, 1, 1, 0.0, 0.0);
        this.windowEnable = new BooleanInput();
        this.windowEnable.setPreferredSize(new Dimension(295, 20));
        GUIHelper.addGBComponent(contentPanel, gbl, this.windowEnable, 1, y, 1, 1, 1.0, 1.0);
        GUIHelper.addGBComponent(contentPanel, gbl, new JLabel(JAMS.i18n("Show_dialog_on_errors:")), 0, ++y, 1, 1, 0.0, 0.0);
        this.errorDlg = new BooleanInput();
        this.errorDlg.setPreferredSize(new Dimension(295, 20));
        GUIHelper.addGBComponent(contentPanel, gbl, this.errorDlg, 1, y, 1, 1, 1.0, 1.0);
        GUIHelper.addGBComponent(contentPanel, gbl, new JLabel(JAMS.i18n("Model_window_on_top:")), 0, ++y, 1, 1, 0.0, 0.0);
        this.windowOnTop = new BooleanInput();
        this.windowOnTop.setPreferredSize(new Dimension(295, 20));
        GUIHelper.addGBComponent(contentPanel, gbl, this.windowOnTop, 1, y, 1, 1, 1.0, 1.0);
        GUIHelper.addGBComponent(contentPanel, gbl, new JLabel(JAMS.i18n("Default_WS_path:")), 0, ++y, 1, 1, 0.0, 0.0);
        this.defaultWSPath = new BooleanInput();
        this.defaultWSPath.setPreferredSize(new Dimension(295, 20));
        GUIHelper.addGBComponent(contentPanel, gbl, this.defaultWSPath, 1, y, 1, 1, 1.0, 1.0);
        GUIHelper.addGBComponent(contentPanel, gbl, new JLabel(JAMS.i18n("Force_Localization:")), 0, ++y, 1, 1, 0.0, 0.0);
        this.locale = new JComboBox();
        JPanel localePanel = new JPanel(new BorderLayout());
        localePanel.setPreferredSize(new Dimension(100, 20));
        localePanel.add(this.locale, "West");
        this.locale.setModel(new DefaultComboBoxModel<String>(new String[]{"", "en", "de", "pt", "vn"}));
        GUIHelper.addGBComponent(contentPanel, gbl, localePanel, 1, y, 1, 1, 1.0, 1.0);
        GUIHelper.addGBComponent(contentPanel, gbl, new JLabel(JAMS.i18n("Character_Set:")), 0, ++y, 1, 1, 0.0, 0.0);
        this.charset = new TextInput();
        this.charset.getComponent().setPreferredSize(new Dimension(100, 20));
        GUIHelper.addGBComponent(contentPanel, gbl, this.charset, 1, y, 1, 1, 1.0, 1.0);
        GUIHelper.addGBComponent(contentPanel, gbl, new JLabel(JAMS.i18n("Model_window_width:")), 0, ++y, 1, 1, 0.0, 0.0);
        this.windowWidth = new TextInput();
        this.windowWidth.getComponent().setPreferredSize(new Dimension(100, 20));
        GUIHelper.addGBComponent(contentPanel, gbl, this.windowWidth, 1, y, 1, 1, 1.0, 1.0);
        JPanel buttonPanel = new JPanel();
        GUIHelper.addGBComponent(contentPanel, gbl, new JLabel(JAMS.i18n("Model_window_height:")), 0, ++y, 1, 1, 0.0, 0.0);
        this.windowHeight = new TextInput();
        this.windowHeight.getComponent().setPreferredSize(new Dimension(100, 20));
        GUIHelper.addGBComponent(contentPanel, gbl, this.windowHeight, 1, y, 1, 1, 1.0, 1.0);
        GUIHelper.addGBComponent(contentPanel, gbl, new JLabel(JAMS.i18n("User_name:")), 0, ++y, 1, 1, 0.0, 0.0);
        this.userName = new TextInput();
        this.userName.getComponent().setPreferredSize(new Dimension(300, 20));
        GUIHelper.addGBComponent(contentPanel, gbl, this.userName, 1, y, 1, 1, 1.0, 1.0);
        GUIHelper.addGBComponent(contentPanel, gbl, new JLabel(JAMS.i18n("Help_Base_URL:")), 0, ++y, 1, 1, 0.0, 0.0);
        this.helpBaseURL = new TextInput();
        this.helpBaseURL.getComponent().setPreferredSize(new Dimension(300, 20));
        GUIHelper.addGBComponent(contentPanel, gbl, this.helpBaseURL, 1, y, 1, 1, 1.0, 1.0);
        GUIHelper.addGBComponent(contentPanel, gbl, new JLabel(JAMS.i18n("Doc_Book_Home")), 0, ++y, 1, 1, 0.0, 0.0);
        this.docbookDir = new FileInput(true);
        this.docbookDir.setPreferredSize(new Dimension(286, 20));
        GUIHelper.addGBComponent(contentPanel, gbl, this.docbookDir, 1, y, 1, 1, 1.0, 1.0);
        GUIHelper.addGBComponent(contentPanel, gbl, new JLabel(JAMS.i18n("Explorer_Dec_Digits")), 0, ++y, 1, 1, 0.0, 0.0);
        this.explorerDigits = new TextInput();
        this.explorerDigits.getComponent().setPreferredSize(new Dimension(300, 20));
        GUIHelper.addGBComponent(contentPanel, gbl, this.explorerDigits, 1, y, 1, 1, 1.0, 1.0);
        GUIHelper.addGBComponent(contentPanel, gbl, new JLabel(JAMS.i18n("JAMS_Dec_Format")), 0, ++y, 1, 1, 0.0, 0.0);
        this.jamsDecFormat = new TextInput();
        this.jamsDecFormat.getComponent().setPreferredSize(new Dimension(300, 20));
        GUIHelper.addGBComponent(contentPanel, gbl, this.jamsDecFormat, 1, y, 1, 1, 1.0, 1.0);
        JButton okButton = new JButton(JAMS.i18n("OK"));
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PropertyDlg.this.ok();
            }
        });
        buttonPanel.add(okButton);
        this.getRootPane().setDefaultButton(okButton);
        JButton cancelButton = new JButton(JAMS.i18n("Cancel"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PropertyDlg.this.cancel();
            }
        });
        buttonPanel.add(cancelButton);
        this.getContentPane().add((Component)new JScrollPane(contentPanel), "Center");
        this.getContentPane().add((Component)buttonPanel, "South");
        this.pack();
        this.setResizable(false);
    }

    private void cancel() {
        this.setVisible(false);
        this.result = 0;
    }

    private void ok() {
        this.setVisible(false);
        this.result = 1;
    }

    @Override
    protected JRootPane createRootPane() {
        JRootPane pane = super.createRootPane();
        AbstractAction cancelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PropertyDlg.this.cancel();
            }
        };
        AbstractAction okAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PropertyDlg.this.ok();
            }
        };
        InputMap inputMap = pane.getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke("ESCAPE"), "ESCAPE");
        inputMap.put(KeyStroke.getKeyStroke("ENTER"), "ENTER");
        pane.getActionMap().put("ESCAPE", cancelAction);
        pane.getActionMap().put("ENTER", okAction);
        return pane;
    }

    public void setProperties(SystemProperties properties) {
        this.properties = properties;
        String[] libs = StringTools.toArray(properties.getProperty("libs"), ";");
        Vector<Object> v = new Vector<Object>();
        for (int i = 0; i < libs.length; ++i) {
            v.add(libs[i]);
        }
        this.list.setListData(v);
        this.verboseCheck.setValue(properties.getProperty("verbose"));
        Integer debugLevel = 1;
        try {
            debugLevel = Integer.parseInt(properties.getProperty("debug"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.debugSpinner.setValue(debugLevel);
        this.debugMode.setValue(properties.getProperty("debugmode"));
        this.errorFile.setFile(properties.getProperty("errorlog"));
        this.infoFile.setFile(properties.getProperty("infolog"));
        this.windowEnable.setValue(properties.getProperty("windowenable"));
        this.errorDlg.setValue(properties.getProperty("errordlg"));
        this.windowOnTop.setValue(properties.getProperty("windowontop"));
        this.profiling.setValue(properties.getProperty("profiling"));
        this.preprocessing.setValue(properties.getProperty("preprocessing"));
        this.defaultWSPath.setValue(properties.getProperty("defaultworkspace"));
        this.locale.getModel().setSelectedItem(properties.getProperty("forcelocale"));
        this.charset.setValue(properties.getProperty("charset"));
        this.windowHeight.setValue(properties.getProperty("windowheight"));
        this.windowWidth.setValue(properties.getProperty("windowwidth"));
        this.userName.setValue(properties.getProperty("username"));
        this.helpBaseURL.setValue(properties.getProperty("helpbaseurl"));
        this.docbookDir.setValue(properties.getProperty("docbook-home"));
        this.explorerDigits.setValue(properties.getProperty("explorerdigits"));
        this.jamsDecFormat.setValue(properties.getProperty("floatformat"));
        this.autoSaveLogs.setValue(properties.getProperty("autosavelogs"));
        this.autoSaveParams.setValue(properties.getProperty("autosaveparams"));
    }

    public void validateProperties() {
        Vector<Object> v = this.list.getListData();
        String libs = "";
        if (v.size() > 0) {
            libs = v.get(0).toString();
        }
        for (int i = 1; i < v.size(); ++i) {
            libs = libs + ";" + v.get(i);
        }
        this.properties.setProperty("libs", libs);
        this.properties.setProperty("debug", this.debugSpinner.getValue().toString());
        this.properties.setProperty("verbose", this.verboseCheck.getValue());
        this.properties.setProperty("debugmode", this.debugMode.getValue());
        this.properties.setProperty("errorlog", this.errorFile.getFileName());
        this.properties.setProperty("infolog", this.infoFile.getFileName());
        this.properties.setProperty("windowenable", this.windowEnable.getValue());
        this.properties.setProperty("errordlg", this.errorDlg.getValue());
        this.properties.setProperty("windowontop", this.windowOnTop.getValue());
        this.properties.setProperty("profiling", this.profiling.getValue());
        this.properties.setProperty("preprocessing", this.preprocessing.getValue());
        this.properties.setProperty("defaultworkspace", this.defaultWSPath.getValue());
        this.properties.setProperty("forcelocale", (String)this.locale.getModel().getSelectedItem());
        this.properties.setProperty("charset", this.charset.getValue());
        this.properties.setProperty("windowheight", this.windowHeight.getValue());
        this.properties.setProperty("windowwidth", this.windowWidth.getValue());
        this.properties.setProperty("username", this.userName.getValue());
        this.properties.setProperty("helpbaseurl", this.helpBaseURL.getValue());
        this.properties.setProperty("docbook-home", this.docbookDir.getValue());
        this.properties.setProperty("explorerdigits", this.explorerDigits.getValue());
        this.properties.setProperty("floatformat", this.jamsDecFormat.getValue());
        this.properties.setProperty("autosavelogs", this.autoSaveLogs.getValue());
        this.properties.setProperty("autosaveparams", this.autoSaveParams.getValue());
    }

    public SystemProperties getProperties() {
        this.validateProperties();
        return this.properties;
    }

    public int getResult() {
        return this.result;
    }
}

