/*
 * Decompiled with CFR 0.152.
 */
package jams.gui;

import jams.JAMS;
import jams.gui.tools.GUIHelper;
import jams.meta.HelpComponent;
import jams.tools.StringTools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;

public class HelpDlg
extends JDialog {
    public static final int OK_RESULT = 0;
    public static final int CANCEL_RESULT = -1;
    private HelpComponent helpComponent;
    private String baseUrl = "";
    private JTextPane webPagePane;

    public HelpDlg(Frame owner) {
        super(owner);
        this.setLocationRelativeTo(owner);
        this.init();
    }

    public HelpComponent getHelpComponent() {
        return this.helpComponent;
    }

    public void setHelpComponent(HelpComponent helpComponent) {
        this.helpComponent = helpComponent;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public void init() {
        this.setModal(false);
        this.setTitle(JAMS.i18n("Help"));
        this.setLayout(new BorderLayout());
        GridBagLayout gbl = new GridBagLayout();
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(gbl);
        GUIHelper.addGBComponent(contentPanel, gbl, new JPanel(), 0, 0, 1, 1, 0.0, 0.0);
        JButton okButton = new JButton(JAMS.i18n("OK"));
        ActionListener okListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HelpDlg.this.setVisible(false);
            }
        };
        okButton.addActionListener(okListener);
        this.getRootPane().setDefaultButton(okButton);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(okButton);
        this.webPagePane = new JTextPane();
        this.webPagePane.setEditable(false);
        JScrollPane scrollPane = new JScrollPane(this.webPagePane);
        scrollPane.setPreferredSize(new Dimension(600, 400));
        this.getContentPane().add((Component)scrollPane, "Center");
        this.getContentPane().add((Component)buttonPanel, "South");
    }

    public void load(HelpComponent helpComponent) {
        this.setHelpComponent(helpComponent);
        if (this.helpComponent.hasHelpText()) {
            this.webPagePane.setContentType("text/html");
            this.webPagePane.setText(this.helpComponent.getHelpText());
            this.setVisible(true);
        }
        if (this.helpComponent.hasHelpURL()) {
            String url = this.baseUrl;
            if (!StringTools.isEmptyString(url)) {
                url = url + "/";
            }
            url = url + this.helpComponent.getHelpURL();
            try {
                GUIHelper.openURL(url);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this.webPagePane, new String[]{JAMS.i18n("Unable_to_open_file"), url}, JAMS.i18n("File_Open_Error"), 0);
                this.setCursor(Cursor.getDefaultCursor());
            }
        }
        this.pack();
    }
}

