/*
 * Decompiled with CFR 0.152.
 */
package jams.aggregators;

import jams.data.Attribute;
import jams.data.DefaultDataFactory;
import java.util.ArrayList;
import java.util.Collection;

public abstract class TemporalAggregator<T> {
    private Attribute.Calendar time;
    AggregationTimePeriod timePeriod;
    ArrayList<Consumer> consumers = new ArrayList();
    Collection<Attribute.TimeInterval> customTimePeriods;

    protected TemporalAggregator(TemporalAggregator<T> copy) {
        this.time = copy.time;
        this.timePeriod = copy.timePeriod;
        this.consumers = (ArrayList)copy.consumers.clone();
        if (copy.customTimePeriods != null) {
            this.customTimePeriods = new ArrayList<Attribute.TimeInterval>();
            this.customTimePeriods.addAll(copy.customTimePeriods);
        } else {
            this.customTimePeriods = null;
        }
    }

    public TemporalAggregator(AggregationTimePeriod timePeriod) {
        this(timePeriod, null);
    }

    public TemporalAggregator(AggregationTimePeriod timePeriod, Collection<Attribute.TimeInterval> customTimePeriods) {
        this.timePeriod = timePeriod;
        this.customTimePeriods = customTimePeriods;
        if (timePeriod == AggregationTimePeriod.CUSTOM) {
            for (Attribute.TimeInterval ti : customTimePeriods) {
                ti.getStart().removeUnsignificantComponents(ti.getTimeUnit());
                ti.getEnd().removeUnsignificantComponents(ti.getTimeUnit());
            }
            for (Attribute.TimeInterval ti1 : customTimePeriods) {
                for (Attribute.TimeInterval ti2 : customTimePeriods) {
                    if (ti1 == ti2 || (ti1.getStart().getTimeInMillis() >= ti2.getEnd().getTimeInMillis() || ti1.getStart().getTimeInMillis() <= ti2.getStart().getTimeInMillis()) && (ti1.getEnd().getTimeInMillis() >= ti2.getEnd().getTimeInMillis() || ti1.getEnd().getTimeInMillis() <= ti2.getStart().getTimeInMillis())) continue;
                    throw new IllegalArgumentException("Time-Intervals " + ti1 + " and " + ti2 + " do overlap");
                }
            }
        }
    }

    public void addConsumer(Consumer<T> consumer) {
        this.consumers.add(consumer);
    }

    public void removeConsumer(Consumer<T> consumer) {
        this.consumers.remove(consumer);
    }

    public void removeConsumers() {
        this.consumers.clear();
    }

    protected void consume(Attribute.Calendar time, T v) {
        if (time == null) {
            return;
        }
        Attribute.Calendar roundedTime = this.roundToTimePeriod(time, this.timePeriod);
        if (roundedTime == null) {
            return;
        }
        for (Consumer c : this.consumers) {
            c.consume(roundedTime, v);
        }
    }

    public abstract TemporalAggregator<T> copy();

    public abstract void init();

    public abstract void aggregate(Attribute.Calendar var1, T var2);

    public boolean isNextTimeStep(Attribute.Calendar timeStep) {
        Attribute.Calendar newTime = this.roundToTimePeriod(timeStep, this.timePeriod);
        if (newTime == null) {
            return true;
        }
        if (this.time == null) {
            this.time = newTime;
            return false;
        }
        return newTime.getTimeInMillis() > this.time.getTimeInMillis();
    }

    public void setTimeStep(Attribute.Calendar timeStep) {
        this.time = this.roundToTimePeriod(timeStep, this.timePeriod);
        if (this.time == null) {
            this.time = timeStep.clone();
        }
    }

    public void finish() {
        this.time = null;
    }

    public AggregationTimePeriod getTimePeriod() {
        return this.timePeriod;
    }

    protected Attribute.Calendar currentTimeStep() {
        return this.time;
    }

    protected Attribute.TimeInterval getTotalTimePeriod() {
        if (this.customTimePeriods == null || this.customTimePeriods.isEmpty()) {
            return null;
        }
        Attribute.TimeInterval totalTimePeriod = DefaultDataFactory.getDataFactory().createTimeInterval();
        totalTimePeriod.getStart().set(5000, 1, 1, 0, 0, 0);
        totalTimePeriod.getEnd().set(1, 1, 1, 0, 0, 0);
        for (Attribute.TimeInterval ti : this.customTimePeriods) {
            if (totalTimePeriod.getStart().after(ti.getStart())) {
                totalTimePeriod.setStart(ti.getStart().clone());
            }
            if (!totalTimePeriod.getEnd().before(ti.getEnd())) continue;
            totalTimePeriod.setEnd(ti.getEnd().clone());
        }
        return totalTimePeriod;
    }

    protected Attribute.Calendar roundToTimePeriod(Attribute.Calendar in, AggregationTimePeriod timeUnitID) {
        Attribute.Calendar out = in.clone();
        switch (timeUnitID) {
            case HOURLY: {
                out.removeUnsignificantComponents(11);
                break;
            }
            case DAILY: {
                out.removeUnsignificantComponents(5);
                break;
            }
            case MONTHLY: {
                out.removeUnsignificantComponents(2);
                break;
            }
            case YEARLY: {
                out.removeUnsignificantComponents(1);
                break;
            }
            case DECADLY: {
                out.removeUnsignificantComponents(1);
                int yearInDekade = (out.get(1) - 1) % 10;
                out.set(out.get(1) - yearInDekade, 0, 1, 12, 0, 0);
                break;
            }
            case SEASONAL: {
                out.removeUnsignificantComponents(2);
                int month = out.get(2);
                int year = out.get(1);
                if (month < 2) {
                    month = 11;
                    --year;
                } else {
                    month = month < 5 ? 2 : (month < 8 ? 5 : (month < 11 ? 8 : 12));
                }
                out.set(year, month, 1, 12, 0, 0);
                break;
            }
            case HALFYEAR: {
                out.removeUnsignificantComponents(2);
                int month = out.get(2);
                month = month < 6 ? 0 : 6;
                out.set(out.get(1), month, 1, 12, 0, 0);
                break;
            }
            case HYDHALFYEAR: {
                out.removeUnsignificantComponents(2);
                int month = out.get(2);
                if (month >= 4 && month <= 9) {
                    month = 4;
                    out.set(out.get(1), month, 1, 12, 0, 0);
                    break;
                }
                if (month < 4) {
                    month = 10;
                    out.set(out.get(1) - 1, month, 1, 12, 0, 0);
                    break;
                }
                month = 10;
                out.set(out.get(1), month, 1, 12, 0, 0);
                break;
            }
            case CUSTOM: {
                boolean isConsidered = false;
                for (Attribute.TimeInterval ti : this.customTimePeriods) {
                    out.removeUnsignificantComponents(ti.getTimeUnit());
                    if (ti.getStart().getTimeInMillis() > out.getTimeInMillis() || ti.getEnd().getTimeInMillis() < out.getTimeInMillis()) continue;
                    out.setValue(ti.getStart().toString());
                    isConsidered = true;
                    break;
                }
                if (isConsidered) break;
                return null;
            }
        }
        return out;
    }

    public static interface Consumer<T> {
        public void consume(Attribute.Calendar var1, T var2);
    }

    public static enum AggregationTimePeriod {
        HOURLY,
        DAILY,
        YEARLY,
        SEASONAL,
        MONTHLY,
        DECADLY,
        HALFYEAR,
        HYDHALFYEAR,
        CUSTOM;


        public static AggregationTimePeriod fromString(String s) {
            for (AggregationTimePeriod iter : AggregationTimePeriod.values()) {
                if (s.compareToIgnoreCase(iter.name()) != 0) continue;
                return iter;
            }
            return null;
        }
    }
}

