/*
 * Decompiled with CFR 0.152.
 */
package jams.aggregators;

import jams.aggregators.Aggregator;
import jams.aggregators.BasicTemporalAggregator;
import jams.aggregators.DoubleArrayAggregator;
import jams.aggregators.TemporalAggregator;
import jams.data.Attribute;
import jams.data.DefaultDataFactory;
import java.util.Arrays;
import java.util.Collection;

public class MultiTemporalAggregator<T>
extends TemporalAggregator<T> {
    TemporalAggregator[] innerAggregator;
    int K = 0;

    public MultiTemporalAggregator(TemporalAggregator innerAggregator, TemporalAggregator.AggregationTimePeriod timePeriod) {
        this(innerAggregator, timePeriod, null);
    }

    public MultiTemporalAggregator(TemporalAggregator innerAggregator, TemporalAggregator.AggregationTimePeriod timePeriod, Collection<Attribute.TimeInterval> timePeriods) {
        super(timePeriod, timePeriods);
        this.K = -1;
        switch (timePeriod) {
            case DAILY: {
                switch (innerAggregator.getTimePeriod()) {
                    case MONTHLY: {
                        this.K = 31;
                        break;
                    }
                    case YEARLY: {
                        this.K = 366;
                    }
                }
            }
            case SEASONAL: {
                this.K = 4;
                break;
            }
            case MONTHLY: {
                this.K = 12;
            }
            case YEARLY: {
                Attribute.TimeInterval interval = this.getTotalTimePeriod();
                if (interval == null) break;
                this.K = interval.getEnd().get(1) - interval.getStart().get(1);
                break;
            }
        }
        if (this.K == -1) {
            System.out.println("Error unsupported combination of aggregation options!");
        }
        this.innerAggregator = new TemporalAggregator[this.K];
        for (int k = 0; k < this.K; ++k) {
            this.innerAggregator[k] = innerAggregator.copy();
            this.innerAggregator[k].addConsumer(new MultiTemporalConsumer(k));
        }
        this.timePeriod = timePeriod;
    }

    protected MultiTemporalAggregator(MultiTemporalAggregator copy) {
        super(copy);
        this.K = copy.K;
        this.innerAggregator = new TemporalAggregator[this.K];
        for (int k = 0; k < this.K; ++k) {
            this.innerAggregator[k] = copy.innerAggregator[k].copy();
        }
    }

    @Override
    public void init() {
        for (int k = 0; k < this.K; ++k) {
            this.innerAggregator[k].init();
        }
    }

    @Override
    public TemporalAggregator<T> copy() {
        return new MultiTemporalAggregator<T>(this);
    }

    private int getIndex(Attribute.Calendar timeStep) {
        switch (this.timePeriod) {
            case DAILY: {
                switch (this.innerAggregator[0].getTimePeriod()) {
                    case MONTHLY: {
                        return timeStep.get(5) - 1;
                    }
                    case YEARLY: {
                        return timeStep.get(6) - 1;
                    }
                }
            }
            case SEASONAL: {
                int month = timeStep.get(2);
                if (month < 2) {
                    return 0;
                }
                if (month < 5) {
                    return 1;
                }
                if (month < 8) {
                    return 2;
                }
                if (month < 11) {
                    return 3;
                }
                if (month < 12) {
                    return 0;
                }
            }
            case MONTHLY: {
                int month = timeStep.get(2);
                return month;
            }
            case YEARLY: {
                Attribute.TimeInterval interval = this.getTotalTimePeriod();
                if (interval == null) break;
                return this.currentTimeStep().get(1) - interval.getStart().get(1);
            }
        }
        return -1;
    }

    @Override
    public void aggregate(Attribute.Calendar timeStep, T next) {
        int index = this.getIndex(timeStep);
        this.innerAggregator[index].aggregate(timeStep, next);
    }

    @Override
    public void finish() {
        for (int k = 0; k < this.K; ++k) {
            this.innerAggregator[k].finish();
        }
        super.finish();
    }

    public static void main(String[] args) {
        DoubleArrayAggregator innerAggr = DoubleArrayAggregator.create(Aggregator.AggregationMode.SUM, 2);
        BasicTemporalAggregator<double[]> InnerTempAggr = new BasicTemporalAggregator<double[]>(innerAggr, TemporalAggregator.AggregationTimePeriod.DECADLY);
        MultiTemporalAggregator<double[]> OuterTempAggr = new MultiTemporalAggregator<double[]>(InnerTempAggr, TemporalAggregator.AggregationTimePeriod.SEASONAL);
        Attribute.Calendar c = DefaultDataFactory.getDataFactory().createCalendar();
        c.set(2001, 0, 1, 0, 1, 1);
        OuterTempAggr.addConsumer(new TemporalAggregator.Consumer<double[]>(){

            @Override
            public void consume(Attribute.Calendar c, double[] v) {
                System.out.println(c.toString() + " " + Arrays.toString(v));
            }
        });
        double[] v = new double[2];
        Attribute.Calendar cEnd = DefaultDataFactory.getDataFactory().createCalendar();
        cEnd.set(2091, 11, 31, 0, 1, 1);
        while (c.before(cEnd)) {
            v[0] = 1.0;
            v[1] = 1.0;
            OuterTempAggr.aggregate(c, v);
            c.add(6, 1);
        }
        OuterTempAggr.finish();
    }

    private class MultiTemporalConsumer
    implements TemporalAggregator.Consumer<T> {
        int k = 0;

        MultiTemporalConsumer(int k) {
            this.k = k;
        }

        @Override
        public void consume(Attribute.Calendar c, T v) {
            Attribute.Calendar c2 = c.clone();
            switch (MultiTemporalAggregator.this.timePeriod) {
                case DAILY: {
                    c2.add(6, this.k);
                    break;
                }
                case MONTHLY: {
                    c2.add(2, this.k);
                    break;
                }
                case SEASONAL: {
                    c2.add(2, 3 * this.k);
                    break;
                }
                case HALFYEAR: {
                    c2.add(2, 6 * this.k);
                    break;
                }
                case DECADLY: {
                    c2.add(1, 10 * this.k);
                    break;
                }
                case HOURLY: {
                    c2.add(11, this.k);
                    break;
                }
                case YEARLY: {
                    c2.add(1, this.k);
                }
            }
            MultiTemporalAggregator.this.consume(c2, v);
        }
    }
}

