/*
 * Decompiled with CFR 0.152.
 */
package jams.aggregators;

import jams.aggregators.Aggregator;
import java.util.Arrays;
import java.util.Iterator;

public abstract class DoubleIteratorAggregator
extends Aggregator<Iterable<Double>> {
    double[] v;

    DoubleIteratorAggregator(int n) {
        this.v = new double[n];
    }

    public DoubleIteratorAggregator(DoubleIteratorAggregator copy) {
        this.v = (double[])copy.v.clone();
    }

    public int n() {
        return this.v.length;
    }

    public abstract DoubleIteratorAggregator copy();

    @Override
    public void init() {
    }

    @Override
    public Iterable<Double> get() {
        return new Iterable<Double>(){

            @Override
            public Iterator<Double> iterator() {
                return new ArrayIterator();
            }
        };
    }

    @Override
    public void finish() {
    }

    public static DoubleIteratorAggregator create(Aggregator.AggregationMode mode, int n) {
        switch (mode) {
            case SUM: {
                return new SumAggregator(n);
            }
            case AVERAGE: {
                return new AverageAggregator(n);
            }
            case LAST: {
                return new LastAggregator(n);
            }
            case MINIMUM: {
                return new MinimumAggregator(n);
            }
            case MAXIMUM: {
                return new MaximumAggregator(n);
            }
            case VARIANCE: {
                return new VarianceAggregator(n);
            }
            case PROP: {
                return new ProportionAggregator(n);
            }
            case INDEPENDENT: {
                return null;
            }
        }
        return null;
    }

    public static void main(String[] args) {
        DoubleIteratorAggregator t = DoubleIteratorAggregator.create(Aggregator.AggregationMode.VARIANCE, 2);
        t.init();
        for (int i = 0; i < 20; ++i) {
        }
        t.finish();
    }

    static class LastAggregator
    extends DoubleIteratorAggregator {
        public LastAggregator(LastAggregator copy) {
            super(copy);
        }

        public LastAggregator(int n) {
            super(n);
        }

        @Override
        public DoubleIteratorAggregator copy() {
            return new LastAggregator(this);
        }

        @Override
        public void init() {
            Arrays.fill(this.v, 0.0);
        }

        @Override
        public void consider(Iterable<Double> in) {
            int i = 0;
            for (Double x : in) {
                if (!Double.isNaN(x)) {
                    this.v[i] = x;
                }
                ++i;
            }
        }
    }

    static class FirstAggregator
    extends DoubleIteratorAggregator {
        boolean isFirst = true;

        public FirstAggregator(FirstAggregator copy) {
            super(copy);
        }

        public FirstAggregator(int n) {
            super(n);
        }

        @Override
        public DoubleIteratorAggregator copy() {
            return new FirstAggregator(this);
        }

        @Override
        public void init() {
            super.init();
            Arrays.fill(this.v, Double.NaN);
        }

        @Override
        public void consider(Iterable<Double> in) {
            int i = 0;
            for (Double x : in) {
                if (!Double.isNaN(this.v[i]) || Double.isNaN(x)) continue;
                this.v[i++] = x;
            }
        }
    }

    static class VarianceAggregator
    extends DoubleIteratorAggregator {
        double[] mean;
        int[] counter;

        public VarianceAggregator(VarianceAggregator copy) {
            super(copy);
            this.mean = Arrays.copyOf(copy.mean, copy.mean.length);
            this.counter = copy.counter;
        }

        public VarianceAggregator(int n) {
            super(n);
            this.mean = new double[n];
            this.counter = new int[n];
        }

        @Override
        public DoubleIteratorAggregator copy() {
            return new VarianceAggregator(this);
        }

        @Override
        public void init() {
            super.init();
            Arrays.fill(this.v, 0.0);
            Arrays.fill(this.mean, 0.0);
            Arrays.fill(this.counter, 0);
        }

        @Override
        public void consider(Iterable<Double> in) {
            int i = 0;
            for (Double x : in) {
                if (!Double.isNaN(x)) {
                    int n = i;
                    this.counter[n] = this.counter[n] + 1;
                    double delta = x - this.mean[i];
                    this.mean[i] = this.mean[i] + delta / (double)this.counter[i];
                    this.v[i] = this.v[i] + delta * (x - this.mean[i]);
                }
                ++i;
            }
        }

        @Override
        public void finish() {
            super.finish();
            for (int i = 0; i < this.n(); ++i) {
                int n = i;
                this.v[n] = this.v[n] / ((double)this.counter[i] - 1.0);
                this.counter[i] = 2;
            }
        }
    }

    static class ProportionAggregator
    extends DoubleIteratorAggregator {
        int[] counter;

        public ProportionAggregator(ProportionAggregator copy) {
            super(copy);
            this.counter = new int[copy.v.length];
        }

        public ProportionAggregator(int n) {
            super(n);
            this.counter = new int[n];
        }

        @Override
        public DoubleIteratorAggregator copy() {
            return new ProportionAggregator(this);
        }

        @Override
        public void init() {
            super.init();
            Arrays.fill(this.v, 0.0);
            Arrays.fill(this.counter, 0);
        }

        @Override
        public void consider(Iterable<Double> in) {
            int i = 0;
            for (double x : in) {
                if (!Double.isNaN(x)) {
                    if (x != 0.0) {
                        x = 1.0;
                    }
                    int n = i;
                    this.v[n] = this.v[n] + x;
                    int n2 = i;
                    this.counter[n2] = this.counter[n2] + 1;
                }
                ++i;
            }
        }

        @Override
        public void finish() {
            super.finish();
            for (int i = 0; i < this.v.length; ++i) {
                if (this.counter[i] != 0) {
                    int n = i;
                    this.v[n] = this.v[n] / (double)this.counter[i];
                    continue;
                }
                this.v[i] = Double.NaN;
            }
            Arrays.fill(this.counter, 1);
        }
    }

    static class AverageAggregator
    extends DoubleIteratorAggregator {
        int[] counter;

        public AverageAggregator(AverageAggregator copy) {
            super(copy);
            this.counter = new int[copy.v.length];
        }

        public AverageAggregator(int n) {
            super(n);
            this.counter = new int[n];
        }

        @Override
        public DoubleIteratorAggregator copy() {
            return new AverageAggregator(this);
        }

        @Override
        public void init() {
            super.init();
            Arrays.fill(this.v, 0.0);
            Arrays.fill(this.counter, 0);
        }

        @Override
        public void consider(Iterable<Double> in) {
            int i = 0;
            for (double x : in) {
                if (!Double.isNaN(x)) {
                    int n = i;
                    this.v[n] = this.v[n] + x;
                    int n2 = i;
                    this.counter[n2] = this.counter[n2] + 1;
                }
                ++i;
            }
        }

        @Override
        public void finish() {
            super.finish();
            for (int i = 0; i < this.v.length; ++i) {
                if (this.counter[i] != 0) {
                    int n = i;
                    this.v[n] = this.v[n] / (double)this.counter[i];
                    continue;
                }
                this.v[i] = Double.NaN;
            }
            Arrays.fill(this.counter, 1);
        }
    }

    static class MaximumAggregator
    extends DoubleIteratorAggregator {
        public MaximumAggregator(MaximumAggregator copy) {
            super(copy);
        }

        public MaximumAggregator(int n) {
            super(n);
        }

        @Override
        public DoubleIteratorAggregator copy() {
            return new MaximumAggregator(this);
        }

        @Override
        public void init() {
            super.init();
            Arrays.fill(this.v, Double.NEGATIVE_INFINITY);
        }

        @Override
        public void consider(Iterable<Double> in) {
            int i = 0;
            for (Double x : in) {
                if (!Double.isNaN(x)) {
                    this.v[i] = Math.max(x, this.v[i]);
                }
                ++i;
            }
        }
    }

    static class MinimumAggregator
    extends DoubleIteratorAggregator {
        public MinimumAggregator(MinimumAggregator copy) {
            super(copy);
        }

        public MinimumAggregator(int n) {
            super(n);
        }

        @Override
        public DoubleIteratorAggregator copy() {
            return new MinimumAggregator(this);
        }

        @Override
        public void init() {
            super.init();
            Arrays.fill(this.v, Double.POSITIVE_INFINITY);
        }

        @Override
        public void consider(Iterable<Double> in) {
            int i = 0;
            for (Double x : in) {
                if (!Double.isNaN(x)) {
                    this.v[i] = Math.min(x, this.v[i]);
                }
                ++i;
            }
        }
    }

    static class SumAggregator
    extends DoubleIteratorAggregator {
        public SumAggregator(int n) {
            super(n);
        }

        public SumAggregator(SumAggregator copy) {
            super(copy);
        }

        @Override
        public DoubleIteratorAggregator copy() {
            return new SumAggregator(this);
        }

        @Override
        public void init() {
            super.init();
            Arrays.fill(this.v, 0.0);
        }

        @Override
        public void consider(Iterable<Double> in) {
            int i = 0;
            for (double x : in) {
                if (!Double.isNaN(x)) {
                    int n = i;
                    this.v[n] = this.v[n] + x;
                }
                ++i;
            }
        }
    }

    private class ArrayIterator
    implements Iterator<Double> {
        int pos = 0;

        private ArrayIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.pos < DoubleIteratorAggregator.this.v.length;
        }

        @Override
        public Double next() {
            return DoubleIteratorAggregator.this.v[this.pos++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

