/*
 * Decompiled with CFR 0.152.
 */
package jams.aggregators;

import jams.aggregators.Aggregator;
import java.util.ArrayList;
import java.util.Collections;

public abstract class DoubleAggregator
extends Aggregator<Double> {
    double v;

    DoubleAggregator() {
    }

    public DoubleAggregator(DoubleAggregator copy) {
        this.v = copy.v;
    }

    public abstract DoubleAggregator copy();

    @Override
    public void init() {
    }

    @Override
    public Double get() {
        return this.v;
    }

    @Override
    public void finish() {
    }

    public static DoubleAggregator create(Aggregator.AggregationMode mode) {
        switch (mode) {
            case SUM: {
                return new SumAggregator();
            }
            case AVERAGE: {
                return new AverageAggregator();
            }
            case LAST: {
                return new LastAggregator();
            }
            case MINIMUM: {
                return new MinimumAggregator();
            }
            case MAXIMUM: {
                return new MaximumAggregator();
            }
            case VARIANCE: {
                return new VarianceAggregator();
            }
            case MEDIAN: {
                return new MedianAggregator();
            }
            case INDEX: {
                return new IndexAggregator();
            }
        }
        throw new UnsupportedOperationException();
    }

    static class LastAggregator
    extends DoubleAggregator {
        public LastAggregator(LastAggregator copy) {
            super(copy);
        }

        public LastAggregator() {
        }

        @Override
        public DoubleAggregator copy() {
            return new LastAggregator(this);
        }

        @Override
        public void init() {
            this.v = 0.0;
        }

        @Override
        public void consider(Double x) {
            if (!Double.isNaN(x)) {
                this.v = x;
            }
        }
    }

    static class FirstAggregator
    extends DoubleAggregator {
        boolean isFirst = true;

        public FirstAggregator(FirstAggregator copy) {
            super(copy);
        }

        public FirstAggregator(int n) {
        }

        @Override
        public DoubleAggregator copy() {
            return new FirstAggregator(this);
        }

        @Override
        public void init() {
            super.init();
            this.v = 0.0;
            this.isFirst = true;
        }

        @Override
        public void consider(Double x) {
            if (!Double.isNaN(x) && this.isFirst) {
                this.v += x.doubleValue();
                this.isFirst = false;
            }
        }
    }

    static class VarianceAggregator
    extends DoubleAggregator {
        double mean;
        int counter = 0;

        public VarianceAggregator(VarianceAggregator copy) {
            super(copy);
            this.mean = copy.mean;
            this.counter = copy.counter;
        }

        public VarianceAggregator() {
            this.counter = 0;
        }

        @Override
        public DoubleAggregator copy() {
            return new VarianceAggregator(this);
        }

        @Override
        public void init() {
            super.init();
            this.v = 0.0;
            this.mean = 0.0;
            this.counter = 0;
        }

        @Override
        public void consider(Double x) {
            if (!Double.isNaN(x)) {
                ++this.counter;
                double delta = x - this.mean;
                this.mean += delta / (double)this.counter;
                this.v += delta * (x - this.mean);
            }
        }

        @Override
        public void finish() {
            super.finish();
            this.v = this.counter > 1 ? (this.v /= (double)this.counter - 1.0) : Double.NaN;
            this.counter = 2;
        }
    }

    static class AverageAggregator
    extends DoubleAggregator {
        int counter = 0;

        public AverageAggregator(AverageAggregator copy) {
            super(copy);
        }

        public AverageAggregator() {
        }

        @Override
        public DoubleAggregator copy() {
            return new AverageAggregator(this);
        }

        @Override
        public void init() {
            super.init();
            this.v = 0.0;
            this.counter = 0;
        }

        @Override
        public void consider(Double x) {
            if (!Double.isNaN(x)) {
                this.v += x.doubleValue();
                ++this.counter;
            }
        }

        @Override
        public void finish() {
            super.finish();
            this.v = this.counter != 0 ? (this.v /= (double)this.counter) : Double.NaN;
            this.counter = 1;
        }
    }

    static class MaximumAggregator
    extends DoubleAggregator {
        public MaximumAggregator(MaximumAggregator copy) {
            super(copy);
        }

        public MaximumAggregator() {
        }

        @Override
        public DoubleAggregator copy() {
            return new MaximumAggregator(this);
        }

        @Override
        public void init() {
            super.init();
            this.v = Double.NEGATIVE_INFINITY;
        }

        @Override
        public void consider(Double x) {
            if (!Double.isNaN(x)) {
                this.v = Math.max(x, this.v);
            }
        }
    }

    static class MinimumAggregator
    extends DoubleAggregator {
        public MinimumAggregator(MinimumAggregator copy) {
            super(copy);
        }

        public MinimumAggregator() {
        }

        @Override
        public DoubleAggregator copy() {
            return new MinimumAggregator(this);
        }

        @Override
        public void init() {
            super.init();
            this.v = Double.POSITIVE_INFINITY;
        }

        @Override
        public void consider(Double x) {
            if (!Double.isNaN(x)) {
                this.v = Math.min(x, this.v);
            }
        }
    }

    public static class IndexAggregator
    extends DoubleAggregator {
        int selectionIndex = 0;
        int currentIndex = 0;

        public IndexAggregator() {
        }

        public IndexAggregator(IndexAggregator copy) {
            super(copy);
            this.selectionIndex = copy.selectionIndex;
            this.currentIndex = copy.currentIndex;
        }

        @Override
        public DoubleAggregator copy() {
            return new IndexAggregator(this);
        }

        @Override
        public void init() {
            super.init();
            this.v = Double.NaN;
            this.currentIndex = 0;
        }

        public void setSelectionIndex(int selectionIndex) {
            this.selectionIndex = selectionIndex;
        }

        @Override
        public void consider(Double x) {
            if (this.currentIndex++ == this.selectionIndex && !Double.isNaN(x)) {
                this.v = x;
            }
        }
    }

    public static class MedianAggregator
    extends DoubleAggregator {
        ArrayList<Double> set = new ArrayList();

        public MedianAggregator() {
        }

        public MedianAggregator(MedianAggregator copy) {
            super(copy);
            this.set = (ArrayList)copy.set.clone();
        }

        @Override
        public DoubleAggregator copy() {
            return new MedianAggregator(this);
        }

        @Override
        public void init() {
            super.init();
            this.v = 0.0;
            this.set = new ArrayList();
        }

        @Override
        public void consider(Double x) {
            if (!Double.isNaN(x)) {
                this.set.add(x);
            }
        }

        public double getQuantile(Double p) {
            if (this.set.size() > 0) {
                double index1;
                double index = p * ((double)this.set.size() - 1.0);
                double index0 = Math.floor(index);
                if (index0 == (index1 = Math.ceil(index))) {
                    return this.set.get((int)index0);
                }
                double t1 = index - index0;
                double t2 = index1 - index;
                double v1 = this.set.get((int)index0);
                double v2 = this.set.get((int)index1);
                double interpolation = v1 * t2 + v2 * t1;
                return interpolation;
            }
            return Double.NaN;
        }

        @Override
        public void finish() {
            Collections.sort(this.set);
            if (this.set.size() > 0) {
                if (this.set.size() % 2 == 0) {
                    this.v = (this.set.get(this.set.size() / 2 - 1) + this.set.get(this.set.size() / 2)) / 2.0;
                }
                if (this.set.size() % 2 == 1) {
                    this.v = this.set.get((this.set.size() - 1) / 2);
                }
            } else {
                this.v = Double.NaN;
            }
        }
    }

    static class SumAggregator
    extends DoubleAggregator {
        public SumAggregator() {
        }

        public SumAggregator(SumAggregator copy) {
            super(copy);
        }

        @Override
        public DoubleAggregator copy() {
            return new SumAggregator(this);
        }

        @Override
        public void init() {
            super.init();
            this.v = 0.0;
        }

        @Override
        public void consider(Double x) {
            if (!Double.isNaN(x)) {
                this.v += x.doubleValue();
            }
        }
    }
}

