/*
 * Decompiled with CFR 0.152.
 */
package jams.aggregators;

public abstract class Aggregator<T> {
    public abstract void init();

    public abstract Aggregator<T> copy();

    public abstract void consider(T var1);

    public abstract void finish();

    public abstract T get();

    public static enum AggregationMode {
        MINIMUM,
        MAXIMUM,
        AVERAGE,
        SUM,
        VARIANCE,
        INDEPENDENT,
        MEDIAN,
        LAST,
        INDEX,
        PROP;


        public String toAbbreviation() {
            switch (this) {
                case MINIMUM: {
                    return "min";
                }
                case MAXIMUM: {
                    return "max";
                }
                case AVERAGE: {
                    return "avg";
                }
                case LAST: {
                    return "last";
                }
                case SUM: {
                    return "sum";
                }
                case INDEPENDENT: {
                    return "ind";
                }
                case VARIANCE: {
                    return "var";
                }
                case MEDIAN: {
                    return "med";
                }
                case INDEX: {
                    return "index";
                }
                case PROP: {
                    return "prop";
                }
            }
            return null;
        }

        public static AggregationMode fromAbbreviation(String value) {
            if (value == null) {
                return AVERAGE;
            }
            for (AggregationMode iter : AggregationMode.values()) {
                if (value.compareToIgnoreCase(iter.toAbbreviation()) != 0) continue;
                return iter;
            }
            return null;
        }
    }
}

