/*
 * Decompiled with CFR 0.152.
 */
package jams.worldwind.ui.view;

import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.SurfacePolygons;
import gov.nasa.worldwind.render.SurfacePolylines;
import jams.worldwind.handler.SurfacePolygonClassCellEditor;
import jams.worldwind.handler.SurfacePolylineClassCellEditor;
import jams.worldwind.ui.model.ShapefileAttributesModel;
import jams.worldwind.ui.renderer.SurfacePolygonClassCellRenderer;
import jams.worldwind.ui.renderer.SurfacePolylineClassCellRenderer;
import jams.worldwind.ui.view.GlobeView;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class ShapefileAttributesView
implements PropertyChangeListener,
MouseListener {
    private static ShapefileAttributesView instance = null;
    private final JFrame theFrame;
    private final JTable theTable;
    private ShapefileAttributesModel theTableModel;

    public ShapefileAttributesView(String title) {
        this.theFrame = new JFrame(title);
        this.theTable = new JTable();
        this.theTable.setIntercellSpacing(new Dimension(6, 6));
        this.theTable.setRowHeight(this.theTable.getRowHeight() + 6);
        this.theTable.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                GlobeView.getInstance().getWorldWindow().redrawNow();
            }
        });
        this.theTable.addMouseListener(this);
        JScrollPane scrollPane = new JScrollPane(this.theTable);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridLayout(1, 0));
        mainPanel.add(scrollPane);
        this.theFrame.getContentPane().add(mainPanel);
        this.theFrame.setSize(this.theFrame.getPreferredSize());
    }

    void dispose() {
        this.theFrame.setVisible(false);
        this.theFrame.dispose();
    }

    public boolean isVisible() {
        return this.theFrame.isVisible();
    }

    public void fillTableWithObjects(List<?> objects) {
        this.theTableModel = new ShapefileAttributesModel(objects);
        this.theTable.setModel(this.theTableModel);
        this.theTable.setAutoCreateRowSorter(true);
        this.theTable.setColumnSelectionAllowed(false);
        this.theTable.setRowSelectionAllowed(true);
        this.theTable.setDefaultEditor(SurfacePolygons.class, new SurfacePolygonClassCellEditor());
        this.theTable.setDefaultRenderer(SurfacePolygons.class, new SurfacePolygonClassCellRenderer());
        this.theTable.setDefaultEditor(SurfacePolylines.class, new SurfacePolylineClassCellEditor());
        this.theTable.setDefaultRenderer(SurfacePolylines.class, new SurfacePolylineClassCellRenderer());
        this.autoResizeColWidth(this.theTable, this.theTableModel);
        TableCellRenderer rendererFromHeader = this.theTable.getTableHeader().getDefaultRenderer();
        JLabel headerLabel = (JLabel)((Object)rendererFromHeader);
        headerLabel.setHorizontalAlignment(0);
    }

    public JTable autoResizeColWidth(JTable table, DefaultTableModel model) {
        table.setAutoResizeMode(0);
        int margin = 5;
        for (int i = 0; i < table.getColumnCount(); ++i) {
            int vColIndex = i;
            DefaultTableColumnModel colModel = (DefaultTableColumnModel)table.getColumnModel();
            TableColumn col = colModel.getColumn(vColIndex);
            int width = 0;
            TableCellRenderer renderer = col.getHeaderRenderer();
            if (renderer == null) {
                renderer = table.getTableHeader().getDefaultRenderer();
            }
            Component comp = renderer.getTableCellRendererComponent(table, col.getHeaderValue(), false, false, 0, 0);
            width = comp.getPreferredSize().width;
            for (int r = 0; r < table.getRowCount(); ++r) {
                renderer = table.getCellRenderer(r, vColIndex);
                comp = renderer.getTableCellRendererComponent(table, table.getValueAt(r, vColIndex), false, false, r, vColIndex);
                Object o = table.getValueAt(r, vColIndex);
                if (o instanceof Material) continue;
                width = Math.max(width, comp.getPreferredSize().width);
            }
            col.setPreferredWidth(width += 2 * margin);
        }
        ((DefaultTableCellRenderer)table.getTableHeader().getDefaultRenderer()).setHorizontalAlignment(2);
        table.getTableHeader().setReorderingAllowed(false);
        return table;
    }

    public void setTitle(String title) {
        this.theFrame.setTitle(title);
    }

    public void show(boolean b) {
        this.theFrame.pack();
        this.theFrame.setVisible(b);
    }

    public void scrollToObject(Object highlighted) {
        if (!(this.theTable.getParent() instanceof JViewport)) {
            return;
        }
        if (this.theFrame.isVisible()) {
            int rowIndex = 0;
            for (int i = 0; i < this.theTable.getRowCount(); ++i) {
                if (!this.theTable.getValueAt(i, 0).equals(highlighted)) continue;
                rowIndex = i;
                break;
            }
            this.theTable.scrollRectToVisible(this.theTable.getCellRect(rowIndex, 0, true));
            this.theTable.setRowSelectionInterval(rowIndex, rowIndex);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int row = this.theTable.getSelectedRow();
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("jams.worldwind.events.LayerRemoved")) {
            this.theFrame.setVisible(false);
        }
    }
}

