/*
 * Decompiled with CFR 0.152.
 */
package jams.worldwind.ui.view;

import jams.data.JAMSCalendar;
import jams.worldwind.data.DataTransfer3D;
import jams.worldwind.ui.view.ShapeAttributeView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.Second;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;

public class ShapeAttributePlot
extends JDialog {
    TimeSeriesCollection dataset;
    JFreeChart chart;
    XYPlot plot;
    XYItemRenderer leftRenderer;
    TimeSeries[] tsLeft;
    DataTransfer3D dataTransfer;
    Color[] colors = new Color[]{Color.blue, Color.red, Color.green, Color.magenta, Color.pink, Color.cyan, Color.orange, Color.gray, Color.black, Color.yellow};
    String title;
    String xTitle = "Time";
    String yTitle = "Values";
    String id;
    ShapeAttributeView owner;

    public ShapeAttributePlot(ShapeAttributeView owner, String title, String id, DataTransfer3D dataTransfer) {
        super((Dialog)owner, title);
        this.owner = owner;
        this.title = title;
        this.dataTransfer = dataTransfer;
        this.id = id;
        this.init();
    }

    private void init() {
        this.setLocationRelativeTo(this.owner);
        this.dataset = new TimeSeriesCollection();
        this.chart = ChartFactory.createTimeSeriesChart(null, (String)this.xTitle, (String)this.yTitle, (XYDataset)this.dataset, (boolean)true, (boolean)true, (boolean)false);
        ChartPanel chartPanel = new ChartPanel(this.chart, true);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)chartPanel, "Center");
        JButton closeButton = new JButton("Close");
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShapeAttributePlot.this.owner.shapePlot = null;
                ShapeAttributePlot.this.dispose();
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(closeButton);
        panel.add((Component)buttonPanel, "South");
        this.getContentPane().add(panel);
        this.plot = this.chart.getXYPlot();
        this.chart.getPlot().setBackgroundPaint((Paint)Color.white);
        this.plot.setDomainGridlinePaint((Paint)Color.gray);
        this.plot.setRangeGridlinePaint((Paint)Color.gray);
        this.plot.setDomainGridlinesVisible(true);
        this.plot.setRangeGridlinesVisible(true);
        this.chart.getLegend().setMargin(0.0, 10.0, 10.0, 10.0);
        DateAxis dateAxis = (DateAxis)this.plot.getDomainAxis();
        dateAxis.setDateFormatOverride((DateFormat)new SimpleDateFormat("dd-MM-yyyy"));
        XYLineAndShapeRenderer lsr = new XYLineAndShapeRenderer();
        lsr.setBaseShapesVisible(false);
        this.leftRenderer = lsr;
        this.plot.setRenderer(0, this.leftRenderer);
        String[] attributeNames = this.dataTransfer.getSortedAttributes();
        int graphCountLeft = attributeNames.length;
        this.tsLeft = new TimeSeries[graphCountLeft];
        for (int i = 0; i < graphCountLeft; ++i) {
            this.leftRenderer.setSeriesPaint(i, (Paint)this.colors[i]);
            this.tsLeft[i] = new TimeSeries((Comparable)((Object)attributeNames[i]));
            this.dataset.addSeries(this.tsLeft[i]);
        }
        for (JAMSCalendar date : this.dataTransfer.getSortedTimeSteps()) {
            Second second = new Second(date.getTime());
            int i = 0;
            for (String attribute : attributeNames) {
                double dataValue = this.dataTransfer.getValue(this.id, attribute, date);
                this.tsLeft[i].add((RegularTimePeriod)second, dataValue);
                ++i;
            }
        }
        this.pack();
    }
}

