/*
 * Decompiled with CFR 0.152.
 */
package jams.worldwind.ui.model;

import gov.nasa.worldwind.render.SurfacePolygons;
import gov.nasa.worldwind.render.SurfacePolylines;
import jams.worldwind.data.shapefile.JamsShapeAttributes;
import jams.worldwind.ui.view.ShapefileAttributesView;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.table.DefaultTableModel;

public class ShapefilePropertiesModel
extends DefaultTableModel {
    private Object thePoly;

    public ShapefilePropertiesModel(SurfacePolygons poly) {
        this.thePoly = poly;
        this.fillTablewithData();
    }

    public ShapefilePropertiesModel(SurfacePolylines poly) {
        this.thePoly = poly;
        this.fillTablewithData();
    }

    private void fillTablewithData() {
        this.fill();
    }

    private void fill() {
        JamsShapeAttributes sattr = null;
        if (this.thePoly instanceof SurfacePolygons) {
            sattr = (JamsShapeAttributes)((SurfacePolygons)this.thePoly).getAttributes();
        } else if (this.thePoly instanceof SurfacePolylines) {
            sattr = (JamsShapeAttributes)((SurfacePolylines)this.thePoly).getAttributes();
        }
        if (sattr != null) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            try {
                BeanInfo beanInfo = Introspector.getBeanInfo(((Object)((Object)sattr)).getClass().getSuperclass());
                for (PropertyDescriptor pd : beanInfo.getPropertyDescriptors()) {
                    if (pd.getReadMethod() == null || "class".equals(pd.getName())) continue;
                    data.put(pd.getDisplayName(), pd.getReadMethod().invoke((Object)sattr, new Object[0]));
                }
            }
            catch (IntrospectionException | IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                System.err.println(ex);
            }
            int columnCount = data.size();
            Vector v = new Vector(columnCount);
            for (Map.Entry e : data.entrySet()) {
                super.addColumn(e.getKey());
                v.add(e.getValue());
            }
            super.addRow(v);
        }
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
        try {
            PropertyDescriptor pd;
            SurfacePolygons obj;
            String propertyName = this.getColumnName(column);
            JamsShapeAttributes sattr = null;
            if (this.thePoly instanceof SurfacePolygons) {
                obj = (SurfacePolygons)this.thePoly;
                sattr = (JamsShapeAttributes)obj.getAttributes();
            } else if (this.thePoly instanceof SurfacePolylines) {
                obj = (SurfacePolylines)this.thePoly;
                sattr = (JamsShapeAttributes)obj.getAttributes();
            }
            if (sattr != null && (pd = new PropertyDescriptor(propertyName, ((Object)((Object)sattr)).getClass().getSuperclass())).getWriteMethod() != null) {
                pd.getWriteMethod().invoke((Object)sattr, aValue);
                super.setValueAt(aValue, row, column);
                this.fireTableCellUpdated(row, column);
            }
        }
        catch (IntrospectionException | IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            Logger.getLogger(ShapefileAttributesView.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return true;
    }

    public Class getColumnClass(int columnIndex) {
        Object o = this.getValueAt(0, columnIndex);
        if (o != null) {
            return o.getClass();
        }
        return Object.class;
    }
}

