/*
 * Decompiled with CFR 0.152.
 */
package jams.worldwind.test;

import jams.worldwind.data.IntervallCalculation;
import jams.worldwind.ui.ColorRamp;
import java.awt.BorderLayout;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JFrame;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;

public class IntervallTest {
    public static void main(String[] args) {
        new IntervallTest();
    }

    public IntervallTest() {
        int numbers = 171;
        double[] testquantil = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 6.0, 6.0, 6.0, 6.0, 6.0, 7.0, 8.0, 8.0, 9.0};
        ArrayList<Double> tlist = new ArrayList<Double>(testquantil.length);
        for (double d : testquantil) {
            tlist.add(d);
        }
        SummaryStatistics statistics = new SummaryStatistics();
        for (int i = 0; i < testquantil.length; ++i) {
            statistics.addValue(testquantil[i]);
        }
        IntervallCalculation ic = new IntervallCalculation(testquantil, statistics);
        System.out.println("Minimum : " + ic.getMinimumValue());
        System.out.println("Maximum : " + ic.getMaximumValue());
        System.out.println("Mean    : " + ic.getMean());
        System.out.println("Variance: " + ic.getVariance());
        System.out.println("Std.Dev.: " + ic.getStandardDeviation());
        SummaryStatistics stats = new SummaryStatistics();
        for (int i = 0; i < ic.getValues().length; ++i) {
            stats.addValue(ic.getValue(i));
        }
        System.out.println(stats.getMin());
        System.out.println(stats.getMax());
        System.out.println(stats.getMean());
        System.out.println(stats.getVariance());
        System.out.println(stats.getStandardDeviation());
        int classes = 5;
        double width = 2.0;
        double[] list = ic.getValues();
        Arrays.sort(list);
        System.out.println("Intervall  : " + ic.getEqualIntervall(classes));
        System.out.println("Intervall  : " + ic.getDefinedIntervall(width));
        System.out.println("Intervall  : " + ic.getQuantilIntervall(classes));
        System.out.println("List: " + list);
        System.out.println("################################################");
        System.out.println("EqualIntervall");
        System.out.println("################################################");
        ic.printHistogramm(ic.getEqualIntervall(classes));
        System.out.println("################################################");
        System.out.println("DefiniedIntervall");
        System.out.println("################################################");
        ic.printHistogramm(ic.getDefinedIntervall(width));
        System.out.println("################################################");
        System.out.println("QuantilIntervall");
        System.out.println("################################################");
        ic.printHistogramm(ic.getQuantilIntervall(classes));
        ColorRamp c = new ColorRamp(new Color(255, 0, 0), new Color(255, 255, 0), 5);
        JFrame f = new JFrame("COLORRAMP TEST");
        f.setDefaultCloseOperation(3);
        f.setLayout(new BorderLayout());
        f.setSize(800, 50);
        f.setVisible(true);
    }
}

