/*
 * Decompiled with CFR 0.152.
 */
package jams.worldwind.handler;

import gov.nasa.worldwind.render.Material;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;

public class MaterialClassCellEditor
extends AbstractCellEditor
implements TableCellEditor,
ActionListener {
    Material currentMaterial;
    Color currentColor;
    JButton button = new JButton();
    JColorChooser colorChooser;
    JDialog dialog;
    protected static final String EDIT = "edit";

    public MaterialClassCellEditor() {
        this.button.setActionCommand(EDIT);
        this.button.addActionListener(this);
        this.button.setBorderPainted(false);
        this.colorChooser = new JColorChooser();
        this.dialog = JColorChooser.createDialog(this.button, "Pick a Color", true, this.colorChooser, this, null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (EDIT.equals(e.getActionCommand())) {
            this.button.setBackground(this.currentColor);
            this.colorChooser.setColor(this.currentColor);
            this.dialog.setVisible(true);
            this.fireEditingStopped();
        } else {
            this.currentColor = this.colorChooser.getColor();
            this.currentMaterial = new Material(this.currentColor);
        }
    }

    @Override
    public Object getCellEditorValue() {
        return this.currentMaterial;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.currentMaterial = (Material)value;
        this.currentColor = this.currentMaterial.getDiffuse();
        return this.button;
    }

    @Override
    public boolean isCellEditable(EventObject e) {
        return true;
    }
}

