/*
 * Decompiled with CFR 0.152.
 */
package jams.worldwind.data;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class RandomNumbers {
    private final List<Double> valueList;

    public RandomNumbers(double from, double to, int count) {
        this.valueList = new ArrayList<Double>(count);
        this.fill(from, to, count);
    }

    private void fill(double from, double to, int count) {
        Random rnd = new Random();
        for (int i = 0; i < count; ++i) {
            this.valueList.add(from + rnd.nextDouble() * (to - from));
        }
    }

    public List<Double> getDoubleValues() {
        return this.valueList;
    }

    public double[] getPrimitivDoubleValues() {
        double[] result = new double[this.valueList.size()];
        for (int i = 0; i < this.valueList.size(); ++i) {
            result[i] = this.valueList.get(i);
        }
        return result;
    }

    public Object[] getIntegerValues() {
        Object[] intvalues = new Object[this.valueList.size()];
        for (int i = 0; i < intvalues.length; ++i) {
            intvalues[i] = Math.round(this.valueList.get(i));
        }
        return intvalues;
    }
}

