/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.util;

import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import cern.colt.matrix.linalg.CholeskyDecomposition;
import cern.colt.matrix.linalg.LUDecomposition;
import cern.colt.matrix.linalg.SingularValueDecomposition;
import cern.jet.math.Functions;
import umontreal.iro.lecuyer.util.Num;
import umontreal.iro.lecuyer.util.PrintfFormat;

public class DMatrix {
    private double[][] mat;
    private int r;
    private int c;
    private static double[] cPade = new double[]{1.76432256E10, 8.8216128E9, 2.0756736E9, 3.027024E8, 3.027024E7, 2162160.0, 110880.0, 3960.0, 90.0, 1.0};

    private static void innerMultBand(DoubleMatrix2D A, int sa, DoubleMatrix2D B, int sb, DoubleMatrix2D C) {
        int n = A.rows();
        for (int i = 0; i < n; ++i) {
            int jmax = Math.min(i + sa + sb, n - 1);
            for (int j = i; j <= jmax; ++j) {
                int kmin = Math.max(i, j - sb);
                int kmax = Math.min(i + sa, j);
                double z = 0.0;
                for (int k = kmin; k <= kmax; ++k) {
                    double x = A.getQuick(i, k);
                    double y = B.getQuick(k, j);
                    z += x * y;
                }
                C.setQuick(i, j, z);
            }
        }
    }

    private static double norm1(DoubleMatrix2D B) {
        int n = B.rows();
        double norm = Math.abs(B.getQuick(0, 0));
        for (int i = 1; i < n; ++i) {
            double x = Math.abs(B.getQuick(i, i - 1)) + Math.abs(B.getQuick(i, i));
            if (!(x > norm)) continue;
            norm = x;
        }
        return norm;
    }

    public DMatrix(int r, int c) {
        this.mat = new double[r][c];
        this.r = r;
        this.c = c;
    }

    public DMatrix(double[][] data, int r, int c) {
        this(r, c);
        for (int i = 0; i < r; ++i) {
            for (int j = 0; j < c; ++j) {
                this.mat[i][j] = data[i][j];
            }
        }
    }

    public DMatrix(DMatrix that) {
        this(that.mat, that.r, that.c);
    }

    public static void CholeskyDecompose(double[][] M, double[][] L) {
        int j;
        int i;
        int d = M.length;
        DenseDoubleMatrix2D MM = new DenseDoubleMatrix2D(M);
        DoubleMatrix2D LL = new DenseDoubleMatrix2D(d, d);
        CholeskyDecomposition decomp = new CholeskyDecomposition(MM);
        LL = decomp.getL();
        for (i = 0; i < L.length; ++i) {
            for (j = 0; j <= i; ++j) {
                L[i][j] = LL.get(i, j);
            }
        }
        for (i = 0; i < L.length; ++i) {
            for (j = i + 1; j < L.length; ++j) {
                L[i][j] = 0.0;
            }
        }
    }

    public static DoubleMatrix2D CholeskyDecompose(DoubleMatrix2D M) {
        CholeskyDecomposition decomp = new CholeskyDecomposition(M);
        return decomp.getL();
    }

    public static void PCADecompose(double[][] M, double[][] A, double[] lambda) {
        int d = M.length;
        DenseDoubleMatrix2D MM = new DenseDoubleMatrix2D(M);
        DoubleMatrix2D AA = new DenseDoubleMatrix2D(d, d);
        AA = DMatrix.PCADecompose(MM, lambda);
        for (int i = 0; i < d; ++i) {
            for (int j = 0; j < d; ++j) {
                A[i][j] = AA.get(i, j);
            }
        }
    }

    public static DoubleMatrix2D PCADecompose(DoubleMatrix2D M, double[] lambda) {
        int i;
        SingularValueDecomposition sv = new SingularValueDecomposition(M);
        DoubleMatrix2D D = sv.getS();
        for (i = 0; i < D.rows(); ++i) {
            lambda[i] = D.getQuick(i, i);
        }
        for (i = 0; i < D.rows(); ++i) {
            D.setQuick(i, i, Math.sqrt(lambda[i]));
        }
        DoubleMatrix2D P = sv.getV();
        return P.zMult(D, null);
    }

    public static void solveTriangular(DoubleMatrix2D U, DoubleMatrix2D B, DoubleMatrix2D X) {
        int n = U.rows();
        int m = B.columns();
        for (int j = 0; j < m; ++j) {
            for (int i = n - 1; i >= 0; --i) {
                double z = B.getQuick(i, j);
                for (int k = i + 1; k < n; ++k) {
                    z -= U.getQuick(i, k) * X.getQuick(k, j);
                }
                X.setQuick(i, j, z /= U.getQuick(i, i));
            }
        }
    }

    public static double[][] exp(double[][] A) {
        DenseDoubleMatrix2D V = new DenseDoubleMatrix2D(A);
        DoubleMatrix2D R = DMatrix.exp(V);
        return R.toArray();
    }

    public static DoubleMatrix2D exp(DoubleMatrix2D A) {
        DoubleMatrix2D B = A.copy();
        int n = B.rows();
        Algebra alge = new Algebra();
        double mu = alge.trace(B) / (double)n;
        for (int i = 0; i < n; ++i) {
            double x = B.getQuick(i, i);
            B.setQuick(i, i, x - mu);
        }
        double THETA9 = 2.097847961257068;
        double norm = alge.norm1(B) / 2.097847961257068;
        int s = norm > 1.0 ? (int)Math.ceil(Num.log2(norm)) : 0;
        Functions F = Functions.functions;
        double v = 1.0 / Math.pow(2.0, s);
        if (v <= 0.0) {
            throw new IllegalArgumentException("   v <= 0");
        }
        B.assign(Functions.mult(v));
        DoubleFactory2D fac = DoubleFactory2D.dense;
        DoubleMatrix2D B0 = fac.identity(n);
        DoubleMatrix2D B2 = alge.mult(B, B);
        DoubleMatrix2D B4 = alge.mult(B2, B2);
        DoubleMatrix2D T = B2.copy();
        DoubleMatrix2D W = B4.copy();
        W.assign(Functions.mult(cPade[9]));
        W.assign(T, Functions.plusMult(cPade[7]));
        DoubleMatrix2D U = alge.mult(B4, W);
        W = B4.copy();
        W.assign(Functions.mult(cPade[5]));
        W.assign(T, Functions.plusMult(cPade[3]));
        W.assign(B0, Functions.plusMult(cPade[1]));
        U.assign(W, Functions.plus);
        U = alge.mult(B, U);
        W = B4.copy();
        W.assign(Functions.mult(cPade[8]));
        W.assign(T, Functions.plusMult(cPade[6]));
        DoubleMatrix2D V = alge.mult(B4, W);
        W = B4.copy();
        W.assign(Functions.mult(cPade[4]));
        W.assign(T, Functions.plusMult(cPade[2]));
        W.assign(B0, Functions.plusMult(cPade[0]));
        V.assign(W, Functions.plus);
        W = V.copy();
        W.assign(U, Functions.plus);
        T = V.copy();
        T.assign(U, Functions.minus);
        LUDecomposition lu = new LUDecomposition(T);
        B = lu.solve(W);
        double r = mu * v;
        r = Math.exp(r);
        B.assign(Functions.mult(r));
        for (int i = 0; i < s; ++i) {
            B = alge.mult(B, B);
        }
        return B;
    }

    public static DoubleMatrix2D expBidiagonal(DoubleMatrix2D A) {
        double x;
        DoubleMatrix2D B = A.copy();
        int n = B.rows();
        Algebra alge = new Algebra();
        double mu = alge.trace(B) / (double)n;
        for (int i = 0; i < n; ++i) {
            x = B.getQuick(i, i);
            B.setQuick(i, i, x - mu);
        }
        double THETA9 = 2.097847961257068;
        double norm = DMatrix.norm1(B) / 2.097847961257068;
        int s = norm > 1.0 ? (int)Math.ceil(Num.log2(norm)) : 0;
        double v = 1.0 / Math.pow(2.0, s);
        if (v <= 0.0) {
            throw new IllegalArgumentException("   v <= 0");
        }
        DMatrix.multBand(B, 1, v);
        DoubleFactory2D fac = DoubleFactory2D.dense;
        DoubleMatrix2D T = fac.make(n, n);
        DoubleMatrix2D B4 = fac.make(n, n);
        DMatrix.multBand(B, 1, B, 1, T);
        DMatrix.multBand(T, 2, T, 2, B4);
        DoubleMatrix2D W = B4.copy();
        DMatrix.addMultBand(cPade[9], W, 4, cPade[7], T, 2);
        DoubleMatrix2D U = fac.make(n, n);
        DMatrix.multBand(W, 4, B4, 4, U);
        W = B4.copy();
        DMatrix.addMultBand(cPade[5], W, 4, cPade[3], T, 2);
        for (int i = 0; i < n; ++i) {
            x = W.getQuick(i, i);
            W.setQuick(i, i, x + cPade[1]);
        }
        DMatrix.addMultBand(1.0, U, 8, 1.0, W, 4);
        DMatrix.multBand(B, 1, U, 8, U);
        W = B4.copy();
        DMatrix.addMultBand(cPade[8], W, 4, cPade[6], T, 2);
        DoubleMatrix2D V = B;
        DMatrix.multBand(W, 4, B4, 4, V);
        W = B4.copy();
        DMatrix.addMultBand(cPade[4], W, 4, cPade[2], T, 2);
        for (int i = 0; i < n; ++i) {
            x = W.getQuick(i, i);
            W.setQuick(i, i, x + cPade[0]);
        }
        DMatrix.addMultBand(1.0, V, 8, 1.0, W, 4);
        W = V.copy();
        DMatrix.addMultBand(1.0, W, 9, 1.0, U, 9);
        T = V.copy();
        DMatrix.addMultBand(1.0, T, 9, -1.0, U, 9);
        DMatrix.solveTriangular(T, W, B);
        double r = mu * v;
        r = Math.exp(r);
        DMatrix.multBand(B, n - 1, r);
        for (int i = 0; i < s; ++i) {
            DMatrix.multBand(B, n - 1, B, n - 1, T);
            B = T.copy();
        }
        return B;
    }

    static void multBand(DoubleMatrix2D A, int sa, DoubleMatrix2D B, int sb, DoubleMatrix2D C) {
        DoubleMatrix2D S = A == C ? A.copy() : A;
        DoubleMatrix2D T = B == C ? B.copy() : B;
        DMatrix.innerMultBand(S, sa, T, sb, C);
    }

    static void multBand(DoubleMatrix2D A, int sa, double h) {
        int n = A.rows();
        for (int i = 0; i < n; ++i) {
            int jmax = Math.min(i + sa, n - 1);
            for (int j = i; j <= jmax; ++j) {
                double z = A.getQuick(i, j);
                A.setQuick(i, j, z * h);
            }
        }
    }

    static void addMultBand(double g, DoubleMatrix2D A, int sa, double h, DoubleMatrix2D B, int sb) {
        int n = A.rows();
        for (int i = 0; i < n; ++i) {
            int jmax = Math.max(i + sa, i + sb);
            jmax = Math.min(jmax, n - 1);
            for (int j = i; j <= jmax; ++j) {
                double z = g * A.getQuick(i, j) + h * B.getQuick(i, j);
                A.setQuick(i, j, z);
            }
        }
    }

    public static String toString(double[][] M) {
        StringBuffer sb = new StringBuffer();
        sb.append("{" + PrintfFormat.NEWLINE);
        for (int i = 0; i < M.length; ++i) {
            sb.append("   { ");
            for (int j = 0; j < M[i].length; ++j) {
                sb.append(M[i][j] + " ");
                if (j >= M.length - 1) continue;
                sb.append(" ");
            }
            sb.append("}" + PrintfFormat.NEWLINE);
        }
        sb.append("}");
        return sb.toString();
    }

    public String toString() {
        return DMatrix.toString(this.mat);
    }

    public int numRows() {
        return this.r;
    }

    public int numColumns() {
        return this.c;
    }

    public double get(int row, int column) {
        if (row >= this.r || column >= this.c) {
            throw new IndexOutOfBoundsException();
        }
        return this.mat[row][column];
    }

    public void set(int row, int column, double value) {
        if (row >= this.r || column >= this.c) {
            throw new IndexOutOfBoundsException();
        }
        this.mat[row][column] = value;
    }

    public DMatrix transpose() {
        DMatrix result = new DMatrix(this.c, this.r);
        for (int i = 0; i < this.r; ++i) {
            for (int j = 0; j < this.c; ++j) {
                result.mat[j][i] = this.mat[i][j];
            }
        }
        return result;
    }
}

