/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.type;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.util.Arrays;
import org.geotools.feature.AttributeType;
import org.geotools.feature.DefaultAttributeType;
import org.geotools.feature.GeometryAttributeType;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.NameImpl;
import org.geotools.feature.type.AttributeDescriptorImpl;
import org.geotools.feature.type.GeometryTypeImpl;
import org.opengis.feature.type.GeometryType;
import org.opengis.filter.Filter;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ChoiceAttributeType
extends AttributeDescriptorImpl
implements AttributeType {
    private final AttributeType[] children;

    public ChoiceAttributeType(ChoiceAttributeType copy) {
        super(copy.getType(), copy.getName(), copy.getMinOccurs(), copy.getMaxOccurs(), copy.isNillable(), copy.getDefaultValue());
        this.children = this.copyChildren(copy.getAttributeTypes());
    }

    public ChoiceAttributeType(String name, int min, int max, AttributeType[] children, Filter restriction) {
        super(DefaultAttributeType.createAttributeType(name, Object.class, restriction), new NameImpl(name), min, max, ChoiceAttributeType.calculateNillableStatic(children), null);
        this.children = this.copyChildren(children);
    }

    public ChoiceAttributeType(String name, AttributeType[] children) {
        this(name, 1, 1, children, (Filter)Filter.EXCLUDE);
    }

    public Filter getRestriction() {
        return DefaultAttributeType.getRestriction(this);
    }

    protected AttributeType[] copyChildren(AttributeType[] attributes) {
        int length = attributes.length;
        AttributeType[] returnArray = new AttributeType[length];
        System.arraycopy(attributes, 0, returnArray, 0, length);
        return returnArray;
    }

    public String getLocalName() {
        return DefaultAttributeType.getLocalName(this);
    }

    public Class getBinding() {
        return DefaultAttributeType.getBinding(this);
    }

    public boolean calculateNillable(AttributeType[] children) {
        return ChoiceAttributeType.calculateNillableStatic(children);
    }

    private static boolean calculateNillableStatic(AttributeType[] children) {
        int ii = children.length;
        for (int i = 0; i < ii; ++i) {
            if (!children[i].isNillable()) continue;
            return true;
        }
        return false;
    }

    public boolean isGeometry() {
        return false;
    }

    public Object parse(Object value) throws IllegalArgumentException {
        for (int i = 0; i < this.children.length; ++i) {
            try {
                return this.children[i].parse(value);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                continue;
            }
        }
        throw new IllegalArgumentException("Could not be parsed :(");
    }

    public void validate(Object obj) throws IllegalArgumentException {
        for (int i = 0; i < this.children.length; ++i) {
            try {
                this.children[i].validate(obj);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                continue;
            }
        }
        throw new IllegalArgumentException("Could not be validated :(");
    }

    public Object duplicate(Object src) throws IllegalAttributeException {
        for (int i = 0; i < this.children.length; ++i) {
            try {
                return this.children[i].duplicate(src);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                continue;
            }
        }
        throw new IllegalArgumentException("Could not be duplicated :(");
    }

    public Object createDefaultValue() {
        for (int i = 0; i < this.children.length; ++i) {
            try {
                return this.children[i].createDefaultValue();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                continue;
            }
        }
        return null;
    }

    public boolean hasAttributeType(String xPath) {
        return this.getAttributeType(xPath) != null;
    }

    public int getAttributeCount() {
        return this.children.length;
    }

    public AttributeType getAttributeType(String xPath) {
        AttributeType attType = null;
        int idx = this.find(xPath);
        if (idx >= 0) {
            attType = this.children[idx];
        }
        return attType;
    }

    public int find(AttributeType type) {
        if (type == null) {
            return -1;
        }
        int idx = this.find(type.getLocalName());
        if (idx < 0 || !this.children[idx].equals(type)) {
            idx = -1;
        }
        return idx;
    }

    public int find(String attName) {
        int i;
        for (i = 0; i < this.children.length && !attName.equals(this.children[i].getLocalName()); ++i) {
        }
        return i == this.children.length ? -1 : i;
    }

    public AttributeType getAttributeType(int position) {
        return this.children[position];
    }

    public AttributeType[] getAttributeTypes() {
        return (AttributeType[])this.children.clone();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof ChoiceAttributeType)) {
            return false;
        }
        ChoiceAttributeType att = (ChoiceAttributeType)other;
        if (!super.equals(att)) {
            return false;
        }
        return Arrays.equals(this.children, att.getAttributeTypes());
    }

    public int hashCode() {
        int hash = super.hashCode();
        int ii = this.children.length;
        for (int i = 0; i < ii; ++i) {
            hash ^= this.children[i].hashCode();
        }
        return hash;
    }

    public String toString() {
        String details = "name=" + this.name;
        details = details + " , nillable=" + this.isNillable() + ", min=" + this.getMinOccurs() + ", max=" + this.getMaxOccurs();
        details = details + ", choices: " + Arrays.asList(this.children);
        return "ChoiceAttributeType [" + details + "]";
    }

    public static final class Geometric
    extends ChoiceAttributeType
    implements GeometryAttributeType {
        public Geometric(Geometric copy) {
            super(copy);
        }

        public Geometric(String name, int min, int max, GeometryAttributeType[] children, Filter restriction) {
            super(name, min, max, children, restriction);
        }

        public Geometric(String name, GeometryAttributeType[] children) {
            super(name, children);
        }

        public GeometryType getType() {
            return new GeometryTypeImpl(this.getName(), Geometry.class, this.getCoordinateSystem(), false, false, null, null, null);
        }

        public CoordinateReferenceSystem getCoordinateSystem() {
            GeometryAttributeType first = (GeometryAttributeType)this.getAttributeType(0);
            return first.getCoordinateSystem();
        }

        public CoordinateReferenceSystem getCoordinateReferenceSystem() {
            return this.getCoordinateSystem();
        }

        public GeometryFactory getGeometryFactory() {
            GeometryAttributeType first = (GeometryAttributeType)this.getAttributeType(0);
            return first.getGeometryFactory();
        }

        public boolean isGeometry() {
            return true;
        }
    }
}

