/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Set;
import org.geotools.util.CheckedCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DerivedSet<B, E>
extends AbstractSet<E>
implements CheckedCollection<E>,
Serializable {
    private static final long serialVersionUID = -4662336508586424581L;
    protected final Set<B> base;
    private final Class<E> derivedType;

    public DerivedSet(Set<B> base) {
        this(base, Object.class);
    }

    public DerivedSet(Set<B> base, Class<E> derivedType) {
        this.base = base;
        this.derivedType = derivedType;
    }

    @Override
    public Class<E> getElementType() {
        return this.derivedType;
    }

    protected abstract E baseToDerived(B var1);

    protected abstract B derivedToBase(E var1);

    @Override
    public Iterator<E> iterator() {
        return new Iter(this.base.iterator());
    }

    @Override
    public int size() {
        int count = 0;
        Iterator<E> it = this.iterator();
        while (it.hasNext()) {
            it.next();
            ++count;
        }
        return count;
    }

    @Override
    public boolean isEmpty() {
        return this.base.isEmpty() || super.isEmpty();
    }

    @Override
    public boolean contains(Object element) {
        if (this.derivedType.isInstance(element)) {
            return this.base.contains(this.derivedToBase(this.derivedType.cast(element)));
        }
        return false;
    }

    @Override
    public boolean add(E element) throws UnsupportedOperationException {
        return this.base.add(this.derivedToBase(element));
    }

    @Override
    public boolean remove(Object element) throws UnsupportedOperationException {
        if (this.derivedType.isInstance(element)) {
            return this.base.remove(this.derivedToBase(this.derivedType.cast(element)));
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Iter
    implements Iterator<E> {
        private final Iterator<B> iterator;
        private transient E next;

        public Iter(Iterator<B> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            while (this.next == null) {
                if (!this.iterator.hasNext()) {
                    return false;
                }
                this.next = DerivedSet.this.baseToDerived(this.iterator.next());
            }
            return true;
        }

        @Override
        public E next() {
            while (this.next == null) {
                this.next = DerivedSet.this.baseToDerived(this.iterator.next());
            }
            Object value = this.next;
            this.next = null;
            return value;
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

