/*
 * Decompiled with CFR 0.152.
 */
package jams.workspace.dsproc;

import jams.JAMS;
import jams.data.JAMSCalendar;
import jams.io.BufferedFileReader;
import jams.workspace.dsproc.AbstractDataStoreProcessor;
import jams.workspace.dsproc.DataMatrix;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.Observer;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.h2.jdbc.JdbcSQLException;

public class DataStoreProcessor
extends AbstractDataStoreProcessor {
    public static final HashMap<String, String> TYPE_MAP = DataStoreProcessor.getTypeMap();
    public static final String DB_USER = "jamsuser";
    public static final String DB_PASSWORD = "";
    private File dsFile;
    private ArrayList<AbstractDataStoreProcessor.ContextData> contexts = new ArrayList();
    private ArrayList<AbstractDataStoreProcessor.FilterData> filters = new ArrayList();
    private ArrayList<AbstractDataStoreProcessor.AttributeData> attributes = new ArrayList();
    private BufferedFileReader reader;
    private int overallSize;
    private String jdbcURL;
    private Connection conn;
    private Statement stmt;
    private AbstractDataStoreProcessor.ImportProgressObservable importProgressObservable = new AbstractDataStoreProcessor.ImportProgressObservable();
    private boolean cancelCreateIndex = false;
    private PreparedStatement pIndexInsertStmt;

    public DataStoreProcessor(File dsFile) {
        super(dsFile);
        this.dsFile = dsFile;
        try {
            this.initDS();
        }
        catch (IOException ex) {
            Logger.getLogger(DataStoreProcessor.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.jdbcURL = dsFile.toString().lastIndexOf(".") == -1 ? "jdbc:h2:mem:" + dsFile.toString() + ";LOG=0" : "jdbc:h2:mem:" + dsFile.toString().substring(0, dsFile.toString().lastIndexOf(".")) + ";LOG=0";
    }

    @Override
    public boolean isEmpty() {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(this.dsFile));
            String line = null;
            boolean isDataStart = false;
            int dataCounter = 0;
            while ((line = reader.readLine()) != null) {
                if (line.contains("@data")) {
                    isDataStart = true;
                    continue;
                }
                if (!isDataStart) continue;
                ++dataCounter;
            }
            reader.close();
            return dataCounter <= 1;
        }
        catch (IOException fnfe) {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                return true;
            }
            return true;
        }
    }

    public static AbstractDataStoreProcessor.DataStoreType getDataStoreType(File file) {
        DataStoreProcessor dsdb = new DataStoreProcessor(file);
        try {
            if (dsdb.isTimeSpaceDatastore()) {
                return AbstractDataStoreProcessor.DataStoreType.SpatioTemporal;
            }
            if (dsdb.isSimpleDataSerieDatastore()) {
                return AbstractDataStoreProcessor.DataStoreType.DataSerie1D;
            }
            if (dsdb.isSimpleTimeSerieDatastore()) {
                return AbstractDataStoreProcessor.DataStoreType.Timeserie;
            }
            if (dsdb.isEnsembleTimeSeriesDatastore()) {
                return AbstractDataStoreProcessor.DataStoreType.TimeDataSerie;
            }
            return AbstractDataStoreProcessor.DataStoreType.Unsupported;
        }
        catch (Exception e) {
            Logger.getLogger(DataStoreProcessor.class.getName()).log(Level.SEVERE, null, e);
            return AbstractDataStoreProcessor.DataStoreType.Unsupported;
        }
    }

    @Override
    public synchronized void createDB() throws IOException, SQLException, ClassNotFoundException {
        Class.forName("org.h2.Driver");
        this.clearDB();
        this.initTables();
        this.createIndex();
    }

    private static HashMap<String, String> getTypeMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("JAMSInteger", "INT4");
        result.put("JAMSLong", "INT8");
        result.put("JAMSFloat", "FLOAT4");
        result.put("JAMSDouble", "FLOAT8");
        result.put("JAMSString", "VARCHAR(255)");
        result.put("JAMSCalendar", "TIMESTAMP");
        return result;
    }

    @Override
    public void clearDB() throws SQLException {
        if (this.conn == null || this.conn.isClosed()) {
            this.conn = this.getH2Connection(false);
        }
        this.stmt = this.conn.createStatement();
        ResultSet rs = this.stmt.executeQuery("SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA='PUBLIC'");
        ArrayList<String> tables = new ArrayList<String>();
        while (rs.next()) {
            tables.add(rs.getString("TABLE_NAME"));
        }
        rs.close();
        for (String table : tables) {
            this.stmt.execute("DROP TABLE IF EXISTS " + table);
        }
    }

    @Override
    public void removeDBFiles() {
        File[] h2Files;
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                String prefix = new File(DataStoreProcessor.this.dsFile.toString().substring(0, DataStoreProcessor.this.dsFile.toString().lastIndexOf("."))).getPath();
                return pathname.getPath().endsWith(".db") && pathname.getPath().startsWith(prefix);
            }
        };
        File parent = this.dsFile.getParentFile();
        for (File h2File : h2Files = parent.listFiles(filter)) {
            boolean result = h2File.delete();
            Logger.getLogger(DataStoreProcessor.class.getName()).log(Level.INFO, "Trying to delete {0}: {1}", new Object[]{h2File.getPath(), result});
        }
    }

    @Override
    public void close() throws SQLException {
        if (this.conn != null && !this.conn.isClosed()) {
            Logger.getLogger(DataStoreProcessor.class.getName()).log(Level.INFO, "Closing database connection");
            this.conn.close();
        }
    }

    @Override
    public boolean existsH2DB() throws SQLException {
        if (this.conn == null || this.conn.isClosed()) {
            this.conn = this.getH2Connection(false);
        }
        this.stmt = this.conn.createStatement();
        ResultSet rs = this.stmt.executeQuery("SELECT count(*) FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_NAME='INDEX' OR TABLE_NAME='DATA'");
        rs.next();
        int count = rs.getInt(1);
        rs.close();
        return count == 2;
    }

    @Override
    public boolean isDBObsolete() {
        return true;
    }

    @Override
    public boolean existsH2DBFiles() {
        String prefix = this.dsFile.toString().substring(0, this.dsFile.toString().lastIndexOf("."));
        File dataFile = new File(prefix + ".data.db");
        File indexFile = new File(prefix + ".index.db");
        return dataFile.exists() && indexFile.exists();
    }

    @Override
    public Connection getH2Connection(boolean checkForDB) throws SQLException {
        if (this.conn != null) {
            return this.conn;
        }
        if (!checkForDB || this.existsH2DBFiles()) {
            try {
                this.conn = DriverManager.getConnection(this.jdbcURL, DB_USER, DB_PASSWORD);
            }
            catch (JdbcSQLException ex) {
                File[] children;
                for (File child : children = this.dsFile.getParentFile().listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        return pathname.getPath().endsWith("db");
                    }
                })) {
                    child.delete();
                }
                try {
                    this.conn = DriverManager.getConnection(this.jdbcURL, DB_USER, DB_PASSWORD);
                }
                catch (JdbcSQLException ex2) {
                    return null;
                }
            }
            return this.conn;
        }
        return null;
    }

    private void initTables() throws SQLException {
        AbstractDataStoreProcessor.ContextData cd;
        int i;
        this.conn = this.getH2Connection(false);
        this.stmt = this.conn.createStatement();
        this.stmt.execute("DROP TABLE IF EXISTS index");
        String q = "CREATE TABLE index (";
        for (i = this.contexts.size() - 1; i > 0; --i) {
            cd = this.contexts.get(i);
            q = q + cd.getName() + "ID " + TYPE_MAP.get(cd.getIdType()) + ",";
        }
        q = q + "position " + TYPE_MAP.get("JAMSLong") + ")";
        this.stmt.execute(q);
        for (i = this.contexts.size() - 1; i > 0; --i) {
            cd = this.contexts.get(i);
            q = "CREATE INDEX " + cd.getName() + "_index ON index (" + cd.getName() + "ID)";
            this.stmt.execute(q);
        }
        this.stmt.execute("DROP TABLE IF EXISTS data");
        q = "CREATE TABLE data (";
        for (i = this.contexts.size() - 1; i >= 0; --i) {
            cd = this.contexts.get(i);
            q = q + cd.getName() + "ID " + TYPE_MAP.get(cd.getIdType()) + ",";
        }
        for (i = 0; i < this.attributes.size(); ++i) {
            AbstractDataStoreProcessor.AttributeData attribute = this.attributes.get(i);
            String dataType = TYPE_MAP.get(attribute.getType());
            if (dataType == null) {
                throw new SQLException("unsupported attribute type: " + attribute.getType());
            }
            String attributeName = attribute.getName();
            while (q.contains(attributeName)) {
                attributeName = attributeName + "_";
            }
            q = q + "\"" + attributeName + "\" " + dataType + ",";
        }
        q = q.substring(0, q.length() - 1);
        q = q + ")";
        this.stmt.execute(q);
        for (i = this.contexts.size() - 1; i >= 0; --i) {
            cd = this.contexts.get(i);
            q = "CREATE INDEX " + cd.getName() + "_data ON data (" + cd.getName() + "ID)";
            this.stmt.execute(q);
        }
    }

    private void initDS() throws IOException {
        this.reader = new BufferedFileReader(new FileInputStream(this.dsFile));
        String row = this.reader.readLine();
        if (row == null || !row.equals("@context")) {
            this.reader.close();
            return;
        }
        row = this.reader.readLine();
        StringTokenizer tok = new StringTokenizer(row);
        this.contexts.add(new AbstractDataStoreProcessor.ContextData(tok.nextToken(), tok.nextToken(), tok.nextToken(), null));
        row = this.reader.readLine();
        row = this.reader.readLine();
        this.overallSize = 0;
        while (!row.equals("@filters")) {
            tok = new StringTokenizer(row);
            AbstractDataStoreProcessor.ContextData cd = new AbstractDataStoreProcessor.ContextData(tok.nextToken(), tok.nextToken(), tok.nextToken(), null);
            this.contexts.add(cd);
            this.overallSize += cd.getSize();
            row = this.reader.readLine();
        }
        row = this.reader.readLine();
        while (!row.equals("@attributes")) {
            tok = new StringTokenizer(row);
            this.filters.add(new AbstractDataStoreProcessor.FilterData(tok.nextToken(), tok.nextToken()));
            row = this.reader.readLine();
        }
        row = this.reader.readLine();
        StringTokenizer attributeTokenizer = new StringTokenizer(row);
        row = this.reader.readLine();
        row = this.reader.readLine();
        StringTokenizer typeTokenizer = new StringTokenizer(row);
        typeTokenizer.nextToken();
        attributeTokenizer.nextToken();
        while (attributeTokenizer.hasMoreTokens() && typeTokenizer.hasMoreTokens()) {
            this.attributes.add(new AbstractDataStoreProcessor.AttributeData(typeTokenizer.nextToken(), attributeTokenizer.nextToken()));
        }
    }

    private synchronized void createIndex() throws IOException, SQLException {
        float counter = 0.0f;
        int percent = 0;
        this.reader = new BufferedFileReader(new FileInputStream(this.dsFile));
        while (!this.reader.readLine().equals("@data")) {
        }
        String indexInsert = "INSERT INTO index VALUES (";
        for (int i = this.contexts.size() - 1; i > 0; --i) {
            indexInsert = indexInsert + "?,";
        }
        indexInsert = indexInsert + "?)";
        this.pIndexInsertStmt = this.conn.prepareStatement(indexInsert);
        boolean result = this.parseBlock();
        while (result) {
            if (this.cancelCreateIndex) {
                this.clearDB();
                return;
            }
            result = this.parseBlock();
            int current = Math.round((counter += 1.0f) / (float)this.overallSize * 100.0f);
            if (current <= percent) continue;
            percent = current;
            this.importProgressObservable.setProgress(percent);
        }
    }

    @Override
    public void cancelCreateIndex() {
        this.cancelCreateIndex = true;
    }

    private boolean parseBlock() throws IOException, SQLException {
        JAMSCalendar cal = new JAMSCalendar();
        String row = this.reader.readLine();
        if (row == null) {
            return false;
        }
        for (int i = 1; i < this.contexts.size(); ++i) {
            AbstractDataStoreProcessor.ContextData cd = this.contexts.get(i);
            StringTokenizer tok = new StringTokenizer(row, "\t");
            tok.nextToken();
            String value = tok.nextToken();
            if (cd.getType().endsWith("TemporalContext") || cd.getType().endsWith("TemporalNestedContext")) {
                value = value + ":00";
                cal.setValue(value);
                Timestamp ts = new Timestamp(cal.getTimeInMillis());
                this.pIndexInsertStmt.setTimestamp(this.contexts.size() - i, ts, cal);
            } else if (cd.getType().contains("optas") || cd.getType().contains("optimizer")) {
                this.pIndexInsertStmt.setLong(this.contexts.size() - i, Long.parseLong(value));
            }
            row = this.reader.readLine();
        }
        long position = this.reader.getPosition();
        this.pIndexInsertStmt.setLong(this.contexts.size(), position);
        while ((row = this.reader.readLine()) != null && !row.startsWith("@end")) {
        }
        this.pIndexInsertStmt.execute();
        return true;
    }

    @Override
    public boolean fillBlock(long position) throws IOException, SQLException {
        String row;
        String insertString = "INSERT INTO data VALUES ";
        String queryPrefix = "(";
        for (int i = this.contexts.size() - 1; i > 0; --i) {
            AbstractDataStoreProcessor.ContextData cd = this.contexts.get(i);
            row = this.reader.readLine();
            if (row == null) {
                return false;
            }
            StringTokenizer tok = new StringTokenizer(row, "\t");
            tok.nextToken();
            String value = tok.nextToken();
            if (cd.getType().endsWith("TemporalContext")) {
                value = value + ":00";
            }
            queryPrefix = queryPrefix + "'" + value + "',";
        }
        row = this.reader.readLine();
        int rowCount = 1;
        do {
            String q = DB_PASSWORD;
            for (int i = 0; i < rowCount && !(row = this.reader.readLine()).startsWith("@end"); ++i) {
                q = q + queryPrefix;
                StringTokenizer tok = new StringTokenizer(row, "\t");
                while (tok.hasMoreTokens()) {
                    q = q + tok.nextToken() + ",";
                }
                q = q.substring(0, q.length() - 1);
                q = q + "),";
            }
            if (q.isEmpty()) continue;
            q = insertString + q.substring(0, q.length() - 1);
            this.stmt.execute(q);
        } while (!row.startsWith("@end"));
        return true;
    }

    @Override
    public synchronized boolean isTimeSpaceDatastore() {
        ArrayList<AbstractDataStoreProcessor.ContextData> cntxt = this.getContexts();
        if (cntxt.size() == 2) {
            if (!(cntxt.get(0).getType().equals("jams.model.JAMSSpatialContext") || cntxt.get(0).getType().equals("jams.components.core.SpatialContext") || cntxt.get(0).getType().equals("jams.components.conditional.FilteredSpatialContext"))) {
                return false;
            }
            if (!cntxt.get(1).getType().equals("jams.model.JAMSTemporalContext") && !cntxt.get(1).getType().equals("jams.components.core.TemporalContext")) {
                return false;
            }
            this.contexts = cntxt;
            return true;
        }
        if (cntxt.size() == 3) {
            if (!(cntxt.get(0).getType().equals("jams.model.JAMSSpatialContext") || cntxt.get(0).getType().equals("jams.components.core.SpatialContext") || cntxt.get(0).getType().equals("jams.components.conditional.FilteredSpatialContext"))) {
                return false;
            }
            if (!cntxt.get(1).getType().equals("jams.components.core.TemporalNestedContext")) {
                return false;
            }
            if (!cntxt.get(2).getType().equals("jams.model.JAMSTemporalContext") && !cntxt.get(2).getType().equals("jams.components.core.TemporalContext")) {
                return false;
            }
            this.contexts = cntxt;
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean isEnsembleTimeSeriesDatastore() {
        ArrayList<AbstractDataStoreProcessor.ContextData> cntxt = this.getContexts();
        if (cntxt.size() != 2) {
            return false;
        }
        if (!cntxt.get(0).getType().equals("jams.components.core.TemporalContext")) {
            return false;
        }
        if (!cntxt.get(1).getType().contains("jams.components.optimizer") && !cntxt.get(1).getType().contains("optas.optimizer")) {
            return false;
        }
        this.contexts = cntxt;
        return true;
    }

    @Override
    public synchronized boolean isSimpleTimeSerieDatastore() {
        ArrayList<AbstractDataStoreProcessor.ContextData> cntxt = this.getContexts();
        if (cntxt.size() != 1) {
            return false;
        }
        if (cntxt.get(0).getType().contains("Temporal")) {
            return true;
        }
        this.contexts = cntxt;
        return false;
    }

    @Override
    public synchronized boolean isSimpleDataSerieDatastore() {
        ArrayList<AbstractDataStoreProcessor.ContextData> cntxt = this.getContexts();
        if (cntxt.size() != 1) {
            return false;
        }
        if (cntxt.get(0).getType().equals("jams.components.core.TemporalContext")) {
            return false;
        }
        this.contexts = cntxt;
        return true;
    }

    @Override
    public ArrayList<AbstractDataStoreProcessor.ContextData> getContexts() {
        return this.contexts;
    }

    @Override
    public ArrayList<AbstractDataStoreProcessor.FilterData> getFilters() {
        return this.filters;
    }

    @Override
    public ArrayList<AbstractDataStoreProcessor.AttributeData> getAttributes() {
        return this.attributes;
    }

    @Override
    public File getFile() {
        return this.dsFile;
    }

    @Override
    public void addImportProgressObserver(Observer o) {
        this.importProgressObservable.addObserver(o);
    }

    @Override
    public int getSize() {
        int size = 1;
        for (AbstractDataStoreProcessor.ContextData cd : this.contexts) {
            size *= cd.getSize();
        }
        return size;
    }

    @Override
    public long getStartPosition() throws IOException {
        this.reader.setPosition(0L);
        while (!this.reader.readLine().startsWith("@start")) {
        }
        return this.reader.getPosition();
    }

    @Override
    public synchronized DataMatrix getData(long position) throws IOException {
        String line;
        int numSelected = 0;
        boolean[] selected = new boolean[this.attributes.size()];
        ArrayList<String> attributeNames = new ArrayList<String>();
        int i = 0;
        for (AbstractDataStoreProcessor.AttributeData a : this.attributes) {
            if (a.isSelected() && a.getType().equals("JAMSDouble")) {
                selected[i] = true;
                attributeNames.add(a.getName());
                ++numSelected;
            } else {
                selected[i] = false;
            }
            ++i;
        }
        ArrayList<double[]> rows = new ArrayList<double[]>();
        ArrayList<String> idList = new ArrayList<String>();
        this.reader.setPosition(position);
        while ((line = this.reader.readLine()) != null && !line.startsWith("@end")) {
            double[] cols = new double[numSelected];
            StringTokenizer tok = new StringTokenizer(line, "\t");
            int j = 0;
            String token = null;
            idList.add(tok.nextToken());
            for (i = 0; i < this.attributes.size(); ++i) {
                try {
                    token = tok.nextToken();
                }
                catch (NoSuchElementException nsee) {
                    System.out.println(nsee);
                }
                if (!selected[i]) continue;
                cols[j] = Double.parseDouble(token);
                if (cols[j] == -9999.0 || cols[j] == JAMS.getMissingDataValue()) {
                    cols[j] = Double.NaN;
                }
                ++j;
            }
            rows.add(cols);
        }
        double[][] data = (double[][])rows.toArray((T[])new double[rows.size()][numSelected]);
        Object[] ids = idList.toArray(new String[idList.size()]);
        return new DataMatrix(data, ids, attributeNames.toArray(new String[attributeNames.size()]));
    }

    @Override
    public synchronized String[] getSelectedDoubleAttribs() {
        ArrayList<String> attribs = new ArrayList<String>();
        for (AbstractDataStoreProcessor.AttributeData a : this.getAttributes()) {
            if (!a.isSelected() || !a.getType().equals("JAMSDouble")) continue;
            attribs.add(a.getName());
        }
        return attribs.toArray(new String[attribs.size()]);
    }

    @Override
    public AbstractDataStoreProcessor[] getSubDataStores() {
        return new AbstractDataStoreProcessor[0];
    }

    public String toString() {
        return this.dsFile.getName();
    }
}

