/*
 * Decompiled with CFR 0.152.
 */
package jams.workspace.dsproc;

import jams.data.JAMSCalendar;
import jams.workspace.dsproc.AbstractDataStoreProcessor;
import jams.workspace.dsproc.DataMatrix;
import jams.workspace.dsproc.DataStoreProcessor;
import jams.workspace.dsproc.TimeSpaceProcessor;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.sql.SQLException;
import java.util.Observable;
import java.util.Observer;

public class DSExample {
    public static void main(String[] args) throws IOException, SQLException, ClassNotFoundException, URISyntaxException {
        double[] rowData;
        DataStoreProcessor dsdb = new DataStoreProcessor(new File("/Users/bigr/Documents/BA-Arbeit/trunk/JAMSworldwind/shapefiles/J2000_Dudh-Kosi/output/20131220_142111/HRULoop.dat"));
        dsdb.addImportProgressObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                System.out.print(arg + " ");
            }
        });
        dsdb.createDB();
        TimeSpaceProcessor tsproc = new TimeSpaceProcessor(dsdb);
        System.out.println("\nDatastore loaded");
        tsproc.addProcessingProgressObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                System.out.print(arg + " ");
            }
        });
        Long[] ids = tsproc.getEntityIDs();
        JAMSCalendar[] dates = tsproc.getTimeSteps();
        int count = 0;
        for (AbstractDataStoreProcessor.AttributeData attribute : dsdb.getAttributes()) {
            if (!attribute.getName().equals("precip") && !attribute.getName().equals("tmean")) continue;
            attribute.setSelected(true);
            ++count;
        }
        System.out.println(count);
        int i = 0;
        long[] entityIds = new long[ids.length];
        for (Long id : ids) {
            entityIds[i++] = id;
        }
        i = 0;
        String[] dateIds = new String[dates.length];
        for (JAMSCalendar date : dates) {
            dateIds[i++] = date.toString();
        }
        DataMatrix crossProduct = tsproc.getCrossProduct(entityIds, dateIds);
        System.out.println("\nHRU IDs:");
        for (String string : crossProduct.getAttributeIDs()) {
            System.out.print(string + " ");
        }
        System.out.println("\nDates:");
        for (Object object : crossProduct.getIds()) {
            System.out.print(object + " ");
        }
        System.out.println("\nValues for 1997-09-16 00:00");
        int rowID = crossProduct.getIDPosition("1997-09-16 00:00");
        for (double d : rowData = crossProduct.getRow(rowID)) {
            System.out.print(d + " ");
        }
        double[][] data = crossProduct.getArray();
    }
}

