/*
 * Decompiled with CFR 0.152.
 */
package jams.workspace;

import jams.data.Attribute;
import jams.data.DefaultDataFactory;
import jams.workspace.DefaultDataSet;
import jams.workspace.stores.TSDataStore;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class TSDumpProcessor {
    public static final String COMMENT_TAG = "@comments";
    public static final String METADATA_TAG = "@metadata";
    public static final String DATA_TAG = "@data";
    public static final String END_TAG = "@end";

    public String toASCIIString(TSDataStore store) throws IOException {
        StringTarget target = new StringTarget();
        this.output(store, target);
        return target.buffer.toString();
    }

    public void toASCIIFile(TSDataStore store, File file) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        FileTarget target = new FileTarget(writer);
        this.output(store, target);
        writer.close();
    }

    public TSDataStore fromASCIIFile(File file) {
        return null;
    }

    private TSDataStore input(InputSource source) throws IOException {
        return null;
    }

    private void output(TSDataStore store, OutputTarget target) throws IOException {
        target.append("#JAMSdatadump\n");
        target.append("@comments\n");
        target.append("#ID: " + store.getID() + "\n");
        target.append("#TYPE: " + store.getClass().getSimpleName() + "\n");
        target.append("#START: " + store.getStartDate() + "\n");
        target.append("#END: " + store.getEndDate() + "\n");
        target.append("#STEPUNIT: " + store.getTimeUnit() + "\n");
        target.append("#STEPSIZE: " + store.getTimeUnitCount() + "\n");
        target.append("#MISSINGDATAVALUE: " + store.getMissingDataValue() + "\n");
        Attribute.Calendar creationDate = DefaultDataFactory.getDataFactory().createCalendar();
        target.append("#DATE: " + creationDate + "\n");
        target.append("#DESCRIPTION:\n");
        String description = store.getDescription();
        if (!description.equals("")) {
            target.append("# " + description.replace("\n", "\n# ") + "\n");
        }
        target.append("@metadata\n");
        target.append(store.getDataSetDefinition().toASCIIString());
        target.append("@data\n");
        while (store.hasNext()) {
            DefaultDataSet ds = store.getNext();
            target.append(ds.toString(store.getMissingDataValue()) + "\n");
        }
        target.append(END_TAG);
    }

    class FileTarget
    implements OutputTarget {
        BufferedWriter writer;

        public FileTarget(BufferedWriter writer) {
            this.writer = writer;
        }

        @Override
        public void append(String s) throws IOException {
            this.writer.write(s);
        }
    }

    class StringTarget
    implements OutputTarget {
        StringBuffer buffer = new StringBuffer();

        StringTarget() {
        }

        @Override
        public void append(String s) {
            this.buffer.append(s);
        }
    }

    static interface InputSource {
        public String readln() throws IOException;
    }

    static interface OutputTarget {
        public void append(String var1) throws IOException;
    }
}

