/*
 * Decompiled with CFR 0.152.
 */
package jams.runtime;

import jams.JAMS;
import jams.JAMSException;
import jams.JAMSVersion;
import jams.SystemProperties;
import jams.data.CheckedDataFactory;
import jams.data.DataFactory;
import jams.data.DefaultDataFactory;
import jams.data.JAMSData;
import jams.io.ModelLoader;
import jams.io.ParameterProcessor;
import jams.meta.ModelDescriptor;
import jams.meta.ModelIO;
import jams.model.FullModelState;
import jams.model.GUIComponent;
import jams.model.JAMSContext;
import jams.model.JAMSFullModelState;
import jams.model.JAMSModel;
import jams.model.JAMSSmallModelState;
import jams.model.Model;
import jams.model.SmallModelState;
import jams.runtime.JAMSClassLoader;
import jams.runtime.JAMSRuntime;
import jams.runtime.RuntimeLogger;
import jams.runtime.RuntimeManager;
import jams.tools.JAMSTools;
import jams.tools.StringTools;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.filechooser.FileFilter;
import org.w3c.dom.Document;

public class StandardRuntime
extends Observable
implements JAMSRuntime,
Serializable {
    private HashMap<String, JAMSData> dataHandles = new HashMap();
    private RuntimeLogger errorLog = new RuntimeLogger();
    private RuntimeLogger infoLog = new RuntimeLogger();
    private int debugLevel = 1;
    private ArrayList<GUIComponent> guiComponents = new ArrayList();
    private transient JButton stopButton;
    private transient JButton pauseButton;
    private transient JButton saveButton;
    private transient JButton closeButton;
    private transient JFrame frame;
    private Model model;
    private transient PrintStream infoStream;
    private transient PrintStream errorStream;
    private boolean guiEnabled = false;
    private transient ClassLoader classLoader;
    private Document modelDocument = null;
    private SystemProperties properties = null;
    private int runState = -1;
    private HashMap<String, Integer> idMap;
    private transient SmallModelState state = null;
    private DataFactory dataFactory = DefaultDataFactory.getDataFactory();
    private transient ScheduledExecutorService progressService;
    private transient Runnable progressRunnable;
    private transient FileWriter progressWriter;

    public StandardRuntime(SystemProperties properties) {
        this.properties = properties;
        this.init(true);
    }

    public void loadModel(Document modelDocument, String defaultWorkspacePath, String modelFilePath) {
        this.modelDocument = modelDocument;
        long start = System.currentTimeMillis();
        try {
            this.println("", 1);
            this.println(JAMS.i18n("Loading_Model"), 1);
            ModelIO modelIO = ModelIO.getStandardModelIO();
            ModelDescriptor md = modelIO.loadModelDescriptor(modelDocument, this.getClassLoader(), false);
            this.state = new JAMSSmallModelState(this.getClassLoader());
            boolean doAutoPreprocessing = Boolean.parseBoolean(this.properties.getProperty("preprocessing", "false"));
            if (doAutoPreprocessing) {
                md.metaProcess(this);
            }
            if (StringTools.isEmptyString(md.getWorkspacePath()) && defaultWorkspacePath != null) {
                md.setWorkspacePath(defaultWorkspacePath);
                this.println(JAMS.i18n("no_workspace_defined_use_loadpath") + defaultWorkspacePath, 1);
            }
            if (modelFilePath != null) {
                md.setModelFilePath(modelFilePath);
            }
            this.println("", 1);
            ModelLoader modelLoader = new ModelLoader(this);
            this.model = modelLoader.loadModel(md);
            this.idMap = modelLoader.getIdMap();
        }
        catch (UnsupportedClassVersionError ucve) {
            String osArch = JAMSTools.is64Bit() ? "64 bit" : "32 bit";
            throw new JAMSException(String.format("The version of your Java VM seems to be to old for JAMS. Please update to a current version (%s)!", osArch), (Throwable)ucve);
        }
        catch (Error t) {
            this.handle((Throwable)t, false);
        }
        boolean doProfiling = Boolean.parseBoolean(this.properties.getProperty("profiling", "false"));
        this.model.setProfiling(doProfiling);
        boolean wEnable = Boolean.parseBoolean(this.properties.getProperty("windowenable", "true"));
        if (wEnable) {
            int width = Integer.parseInt(this.properties.getProperty("windowwidth", "600"));
            int height = Integer.parseInt(this.properties.getProperty("windowheight", "400"));
            boolean ontop = Boolean.parseBoolean(this.properties.getProperty("windowontop", "false"));
            this.initGUI(this.model.getName(), ontop, width, height);
            this.guiEnabled = true;
        }
        long end = System.currentTimeMillis();
        this.println(JAMS.i18n("*************************************"), 1);
        this.println(JAMS.i18n("JAMS_model_setup_time:_") + (end - start) + " ms", 1);
        this.println(JAMS.i18n("*************************************"), 1);
        this.runState = 1;
    }

    private void initLogging() {
        boolean errorDlg;
        this.setDebugLevel(Integer.parseInt(this.properties.getProperty("debug", "1")));
        boolean verbose = Boolean.parseBoolean(this.properties.getProperty("verbose", "1"));
        if (verbose) {
            this.addInfoLogObserver(new Observer(){

                @Override
                public void update(Observable obs, Object obj) {
                    System.out.print(obj);
                }
            });
            this.addErrorLogObserver(new Observer(){

                @Override
                public void update(Observable obs, Object obj) {
                    System.out.print(obj);
                }
            });
        }
        if (errorDlg = Boolean.parseBoolean(this.properties.getProperty("errordlg", "0"))) {
            this.addErrorLogObserver(new Observer(){

                @Override
                public void update(Observable obs, Object obj) {
                    Object[] options = new Object[]{JAMS.i18n("OK"), JAMS.i18n("OK,_skip_other_messages")};
                    int result = JOptionPane.showOptionDialog(StandardRuntime.this.frame, obj.toString(), JAMS.i18n("Model_execution_error"), 0, 0, null, options, options[0]);
                    if (result == 1) {
                        StandardRuntime.this.deleteErrorLogObserver(this);
                    }
                }
            });
        }
        try {
            String infoLogFile = this.properties.getProperty("infolog");
            if (!StringTools.isEmptyString(infoLogFile)) {
                this.infoStream = new PrintStream(infoLogFile);
            }
        }
        catch (FileNotFoundException fnfe) {
            this.handle(fnfe);
        }
        try {
            String errorLogFile = this.properties.getProperty("errorlog");
            if (!StringTools.isEmptyString(errorLogFile)) {
                this.errorStream = new PrintStream(errorLogFile);
            }
        }
        catch (FileNotFoundException fnfe) {
            this.handle(fnfe);
        }
    }

    public Document getModelDocument() {
        return this.modelDocument;
    }

    private void init(boolean start) {
        if (start) {
            String user = this.properties.getProperty("username");
            user = !StringTools.isEmptyString(user) ? System.getProperty("user.name") + " (" + user + ")" : System.getProperty("user.name");
            this.println(JAMS.i18n("*************************************"), 1);
            this.println(JAMS.i18n("JAMS_version") + JAMSVersion.getInstance().getVersionDateString(), 1);
            this.println(JAMS.i18n("User_name_:") + user, 1);
            this.println(JAMS.i18n("Date_time") + new SimpleDateFormat().format(new Date()), 1);
            this.println(JAMS.i18n("*************************************"), 1);
            this.println("", 1);
        }
        RuntimeLogger log = new RuntimeLogger();
        this.classLoader = JAMSClassLoader.createClassLoader(this.getLibs(), log);
        for (String line : log.toString().split("\n")) {
            this.println(line, 1);
        }
        this.initLogging();
        boolean debugMode = Boolean.parseBoolean(this.properties.getProperty("debugmode"));
        this.dataFactory = debugMode ? CheckedDataFactory.getDataFactory() : DefaultDataFactory.getDataFactory();
    }

    public String[] getLibs() {
        return StringTools.toArray(this.properties.getProperty("libs", ""), ";");
    }

    public FullModelState getFullModelState() {
        try {
            this.getModel().getWorkspace().saveState(this.state);
            return new JAMSFullModelState(this.state, this.getModel());
        }
        catch (IOException ioe) {
            this.sendErrorMsg(ioe.toString());
            return null;
        }
    }

    private void recoverIteratorStates(JAMSContext context, SmallModelState state) {
        context.setModel(this.model);
        for (int i = 0; i < context.getComponents().size(); ++i) {
            if (!(context.getComponents().get(i) instanceof JAMSContext)) continue;
            this.recoverIteratorStates((JAMSContext)context.getComponents().get(i), state);
        }
    }

    public void resume(SmallModelState state) throws Exception {
        this.state = state;
        if (this.guiEnabled && this.guiComponents.size() > 0) {
            this.frame.setVisible(true);
        }
        this.recoverIteratorStates((JAMSModel)this.model, state);
        this.model.getWorkspace().restore(state);
        this.setRunState(1);
        RuntimeManager.getInstance().addRuntime(this);
        long start = System.currentTimeMillis();
        this.setupProgressLogging();
        this.model.restore();
        if (this.getState() == 1) {
            this.model.resume();
        }
        if (this.getState() == 1) {
            this.model.cleanup();
        }
        if (this.getState() == 2) {
            this.model.getWorkspace().saveState(state);
        }
        state.setExecutionTime(state.getExecutionTime() + (System.currentTimeMillis() - start));
        this.finishModelExecution(state.getExecutionTime());
        this.finishProgressLogging();
    }

    public void runModel() throws Exception {
        if (this.getState() != 1) {
            return;
        }
        RuntimeManager.getInstance().addRuntime(this);
        if (this.guiEnabled && this.guiComponents.size() > 0) {
            this.frame.setVisible(true);
        }
        long start = System.currentTimeMillis();
        if (this.getState() == 1) {
            this.model.init();
        }
        if (Boolean.parseBoolean(this.properties.getProperty("autosaveparams", "1"))) {
            this.saveModelParameter();
        }
        if (this.getState() == 1) {
            this.model.initAll();
        }
        this.setupProgressLogging();
        if (this.getState() == 1) {
            this.model.run();
        }
        if (this.getState() == 1) {
            this.model.cleanupAll();
        }
        if (this.getState() == 1) {
            this.model.cleanup();
        }
        this.finishModelExecution(System.currentTimeMillis() - start);
        this.finishProgressLogging();
        if (Boolean.parseBoolean(this.properties.getProperty("autosavelogs", "1"))) {
            this.saveModelLogs();
        }
        if (this.getState() != 2) {
            this.model = null;
            this.classLoader = null;
            Runtime.getRuntime().gc();
        }
    }

    private void finishProgressLogging() {
        if (this.progressService != null) {
            this.progressService.shutdownNow();
        }
        if (this.progressRunnable != null) {
            this.progressRunnable.run();
        }
        if (this.progressWriter != null) {
            try {
                this.progressWriter.close();
            }
            catch (IOException ex) {
                this.handle((Throwable)ex, true);
            }
        }
    }

    private void setupProgressLogging() throws IOException {
        long progressperiod = Long.parseLong(this.properties.getProperty("progressperiod", "-1"));
        String progressFileName = this.properties.getProperty("progressfilename", "");
        if (progressperiod <= 0L || progressFileName.equals("")) {
            this.properties.setProperty("progressperiod", Long.toString(progressperiod));
            this.properties.setProperty("progressfilename", progressFileName);
            return;
        }
        this.progressWriter = new FileWriter(progressFileName);
        this.progressRunnable = new Runnable(){

            @Override
            public void run() {
                long[] progress = StandardRuntime.this.getModel().getProgress();
                float f = progress[1] > 0L ? (float)progress[0] / (float)progress[1] : 0.0f;
                try {
                    StandardRuntime.this.progressWriter.write(String.format(Locale.ENGLISH, "%d %1.2f\r\n", System.currentTimeMillis(), Float.valueOf(f)));
                    StandardRuntime.this.progressWriter.flush();
                }
                catch (IOException ex) {
                    StandardRuntime.this.handle((Throwable)ex, false);
                }
            }
        };
        this.progressService = Executors.newSingleThreadScheduledExecutor();
        this.progressService.scheduleAtFixedRate(this.progressRunnable, 0L, progressperiod, TimeUnit.MILLISECONDS);
    }

    private void finishModelExecution(long executionTime) {
        if (this.getState() == 2) {
            this.model.getWorkspace().saveState(this.state);
        }
        if (this.model.getWorkspace() != null) {
            this.model.getWorkspace().close();
        }
        if (this.infoStream != null) {
            this.infoStream.print(this.getInfoLog());
            this.infoStream.flush();
            this.infoStream.close();
        }
        if (this.errorStream != null) {
            this.errorStream.print(this.getErrorLog());
            this.errorStream.close();
        }
        if (this.getState() != 2) {
            this.println(JAMS.i18n("*************************************"), 1);
            this.println(JAMS.i18n("JAMS_model_execution_time:_") + executionTime + " ms", 1);
            this.println(JAMS.i18n("*************************************"), 1);
            this.sendHalt();
        } else {
            this.println(JAMS.i18n("*************************************"), 1);
            this.println(JAMS.i18n("JAMS_model_execution_paused"), 1);
            this.println(JAMS.i18n("*************************************"), 1);
        }
    }

    public void initGUI(String title, boolean ontop, int width, int height) {
        if (this.guiComponents.isEmpty()) {
            return;
        }
        this.frame = new JFrame();
        this.frame.setDefaultCloseOperation(2);
        this.frame.setTitle(title);
        this.frame.setName(title);
        this.frame.setAlwaysOnTop(ontop);
        this.frame.setIconImages(JAMSTools.getJAMSIcons());
        this.frame.setPreferredSize(new Dimension(width, height));
        ListIterator<GUIComponent> i = this.guiComponents.listIterator();
        if (this.guiComponents.size() > 1) {
            JTabbedPane tabbedPane = new JTabbedPane();
            tabbedPane.setTabPlacement(2);
            while (i.hasNext()) {
                GUIComponent comp = i.next();
                try {
                    tabbedPane.addTab(comp.getInstanceName(), comp.getPanel());
                }
                catch (Throwable t) {
                    this.sendErrorMsg(JAMS.i18n("Could_not_load_component") + comp.getInstanceName() + "\"");
                    this.handle(t, true);
                }
            }
            this.frame.getContentPane().add((Component)tabbedPane, "Center");
        } else {
            while (i.hasNext()) {
                this.frame.getContentPane().add((Component)i.next().getPanel(), "Center");
            }
        }
        JToolBar toolBar = new JToolBar();
        this.stopButton = new JButton();
        this.stopButton.setToolTipText(JAMS.i18n("Stop_model"));
        this.stopButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/images/ModelStop.png")));
        this.stopButton.setEnabled(true);
        this.stopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StandardRuntime.this.sendHalt();
                StandardRuntime.this.stopButton.setEnabled(false);
                StandardRuntime.this.saveButton.setEnabled(false);
            }
        });
        toolBar.add(this.stopButton);
        this.pauseButton = new JButton();
        this.pauseButton.setToolTipText(JAMS.i18n("Pause_model"));
        this.pauseButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/images/ModelPause.png")));
        this.pauseButton.setEnabled(true);
        this.pauseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (StandardRuntime.this.runState == 1) {
                    StandardRuntime.this.pause();
                    StandardRuntime.this.pauseButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/images/ModelRun.png")));
                    StandardRuntime.this.saveButton.setEnabled(true);
                } else if (StandardRuntime.this.runState == 2) {
                    Thread resumedModelThread = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            StandardRuntime.this.pauseButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/images/ModelPause.png")));
                            StandardRuntime.this.saveButton.setEnabled(false);
                            try {
                                StandardRuntime.this.resume(StandardRuntime.this.state);
                            }
                            catch (Exception e) {
                                StandardRuntime.this.sendErrorMsg(e.toString());
                                StandardRuntime.this.handle((Throwable)e, true);
                            }
                        }
                    });
                    resumedModelThread.start();
                }
            }
        });
        toolBar.add(this.pauseButton);
        this.saveButton = new JButton();
        this.saveButton.setToolTipText(JAMS.i18n("Pause_model"));
        this.saveButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/images/ModelSave.png")));
        this.saveButton.setEnabled(false);
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (StandardRuntime.this.runState == 2) {
                    JFileChooser fc = new JFileChooser();
                    fc.setFileFilter(new FileFilter(){

                        @Override
                        public boolean accept(File f) {
                            return f.isDirectory() || f.getName().toLowerCase().endsWith(".ser");
                        }

                        @Override
                        public String getDescription() {
                            return JAMS.i18n("Serialization_(ser)");
                        }
                    });
                    int returnVal = fc.showSaveDialog(StandardRuntime.this.frame);
                    if (returnVal == 0) {
                        File file = fc.getSelectedFile();
                        try {
                            JAMSFullModelState state = new JAMSFullModelState(StandardRuntime.this.state, StandardRuntime.this.getModel());
                            state.writeToFile(file);
                        }
                        catch (IOException e) {
                            StandardRuntime.this.sendErrorMsg(JAMS.i18n("Unable_to_save_model_state_because,") + e.toString());
                            StandardRuntime.this.handle((Throwable)e, true);
                        }
                    }
                }
            }
        });
        toolBar.add(this.saveButton);
        this.closeButton = new JButton();
        this.closeButton.setToolTipText(JAMS.i18n("Close_window"));
        this.closeButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/images/Shutdown.png")));
        this.closeButton.setEnabled(false);
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StandardRuntime.this.sendHalt();
                StandardRuntime.this.frame.dispose();
                Runtime.getRuntime().gc();
            }
        });
        toolBar.add(this.closeButton);
        this.frame.add((Component)toolBar, "North");
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                StandardRuntime.this.sendHalt();
                StandardRuntime.this.frame.dispose();
                Runtime.getRuntime().gc();
            }
        });
        this.addStateObserver(new Observer(){

            @Override
            public void update(Observable obs, Object obj) {
                if (StandardRuntime.this.getState() == 0) {
                    StandardRuntime.this.stopButton.setEnabled(false);
                    StandardRuntime.this.closeButton.setEnabled(true);
                }
            }
        });
        this.frame.pack();
        this.frame.setLocation((int)(Toolkit.getDefaultToolkit().getScreenSize().getWidth() - (double)width) / 2, (int)(Toolkit.getDefaultToolkit().getScreenSize().getHeight() - (double)height) / 2);
    }

    public HashMap<String, JAMSData> getDataHandles() {
        return this.dataHandles;
    }

    public DataFactory getDataFactory() {
        return this.dataFactory;
    }

    public void setDataHandles(HashMap<String, JAMSData> dataHandles) {
        this.dataHandles = dataHandles;
    }

    public void println(String s, int debugLevel) {
        if (debugLevel <= this.getDebugLevel()) {
            this.sendInfoMsg(s);
        }
    }

    public void println(String s) {
        this.sendInfoMsg(s);
    }

    public int getDebugLevel() {
        return this.debugLevel;
    }

    public void setDebugLevel(int aDebugLevel) {
        this.debugLevel = aDebugLevel;
    }

    public void handle(Throwable t) {
        this.handle(t, null, false);
    }

    public void handle(Throwable t, String cName) {
        this.handle(t, cName, false);
    }

    public void handle(Throwable t, boolean proceed) {
        this.handle(t, null, proceed);
    }

    public void handle(Throwable t, String cName, boolean proceed) {
        String message = "";
        if (cName != null) {
            message = message + JAMS.i18n("Exception_occured_in_component_") + cName + "!\n";
        }
        message = message + t.toString();
        Throwable wrappedException = null;
        if (JAMSException.class.isAssignableFrom(t.getClass())) {
            JAMSException ex = (JAMSException)t;
            if (ex.getType() == 0) {
                this.sendInfoMsg(ex.getMessage());
                return;
            }
            wrappedException = ex.getWrappedException();
        }
        if (this.getDebugLevel() > 1) {
            if (wrappedException == null) {
                message = message + "\n" + StringTools.getStackTraceString(t.getStackTrace());
            } else {
                message = message + "\n" + JAMS.i18n("causedby");
                message = message + wrappedException.toString();
                if (this.getDebugLevel() > 1) {
                    message = message + "\n" + StringTools.getStackTraceString(wrappedException.getStackTrace());
                }
            }
        }
        this.sendErrorMsg(message);
        if (!proceed) {
            this.sendHalt();
        }
    }

    public void sendHalt() {
        this.setRunState(0);
    }

    public void sendHalt(String str) {
        this.sendErrorMsg(str);
        this.sendHalt();
    }

    private String getCallerID() {
        String jamsID = "[000]";
        if (this.getState() != 1) {
            return jamsID;
        }
        StackTraceElement[] ste = Thread.currentThread().getStackTrace();
        int i = 1;
        String caller = ste[i].getClassName();
        while (caller.equals("jams.runtime.StandardRuntime")) {
            caller = ste[++i].getClassName();
        }
        Integer id = this.idMap.get(caller);
        if (id != null) {
            return "[" + String.format("%03d", id) + "]";
        }
        return jamsID;
    }

    public void sendErrorMsg(String str) {
        this.errorLog.print(JAMS.i18n("ERROR") + this.getCallerID() + ": " + str + "\n");
    }

    public void sendInfoMsg(String str) {
        this.infoLog.print(JAMS.i18n("INFO") + this.getCallerID() + ": " + str + "\n");
    }

    public void addStateObserver(Observer o) {
        this.addObserver(o);
    }

    public int getState() {
        return this.runState;
    }

    public void pause() {
        this.setRunState(2);
    }

    private void setRunState(int state) {
        this.runState = state;
        if (this.getModel() != null) {
            this.getModel().setExecutionState(state);
        }
        this.setChanged();
        this.notifyObservers();
    }

    public void addInfoLogObserver(Observer o) {
        this.infoLog.addObserver(o);
    }

    public void deleteInfoLogObservers() {
        this.infoLog.deleteObservers();
    }

    public void deleteInfoLogObserver(Observer o) {
        this.infoLog.deleteObserver(o);
    }

    public void addErrorLogObserver(Observer o) {
        this.errorLog.addObserver(o);
    }

    public void deleteErrorLogObservers() {
        this.errorLog.deleteObservers();
    }

    public void deleteErrorLogObserver(Observer o) {
        this.errorLog.deleteObserver(o);
    }

    public String getErrorLog() {
        return this.errorLog.getLogString();
    }

    public String getInfoLog() {
        return this.infoLog.getLogString();
    }

    public void addGUIComponent(GUIComponent component) {
        this.guiComponents.add(component);
    }

    private void saveModelParameter() {
        if (this.model.getWorkspace() == null) {
            return;
        }
        try {
            File modelFile = new File(this.model.getWorkspace().getOutputDataDirectory(), "model.jmp");
            modelFile.getParentFile().mkdirs();
            ParameterProcessor.saveParams(this.modelDocument, modelFile, this.properties.getProperty("username"), null);
        }
        catch (IOException ioe) {
            this.getModel().getRuntime().handle((Throwable)ioe);
        }
    }

    private void saveModelLogs() {
        if (this.model.getWorkspace() == null) {
            return;
        }
        try {
            File infoLogFile = new File(this.model.getWorkspace().getOutputDataDirectory(), "info.log");
            infoLogFile.getParentFile().mkdirs();
            PrintWriter out = new PrintWriter(infoLogFile);
            out.print(this.getInfoLog());
            out.close();
            File errorLogFile = new File(this.model.getWorkspace().getOutputDataDirectory(), "error.log");
            errorLogFile.getParentFile().mkdirs();
            out = new PrintWriter(errorLogFile);
            out.print(this.getErrorLog());
            out.close();
        }
        catch (IOException ioe) {
            this.getModel().getRuntime().handle((Throwable)ioe);
        }
    }

    public Model getModel() {
        return this.model;
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    private void readObject(ObjectInputStream objIn) throws IOException, ClassNotFoundException {
        objIn.defaultReadObject();
        if (objIn instanceof JAMSFullModelState.ClassLoaderObjectInputStream) {
            this.classLoader = ((JAMSFullModelState.ClassLoaderObjectInputStream)objIn).getClassLoader();
        }
        if (objIn instanceof JAMSSmallModelState.ClassLoaderObjectInputStream) {
            this.classLoader = ((JAMSSmallModelState.ClassLoaderObjectInputStream)objIn).getClassLoader();
        }
    }

    private void writeObject(ObjectOutputStream objOut) throws IOException {
        objOut.defaultWriteObject();
    }
}

