/*
 * Decompiled with CFR 0.152.
 */
package jams.meta;

import jams.meta.ComponentDescriptor;
import jams.meta.ComponentField;
import jams.meta.ContextAttribute;
import jams.meta.HelpComponent;
import jams.tools.StringTools;
import java.util.ArrayList;
import java.util.HashMap;

public class ModelProperties {
    private HashMap<String, Group> groups = new HashMap();
    private ArrayList<Group> groupList = new ArrayList();
    private static String groupSeparator = Character.toString('\u00bb');

    public boolean addProperty(Group group, ModelProperty p) {
        ArrayList properties = group.propertyList;
        if (properties.contains(p)) {
            return false;
        }
        properties.add(p);
        p.setGroup(group);
        return true;
    }

    public void removeAll() {
        this.groups = new HashMap();
        this.groupList = new ArrayList();
    }

    public void removePropertyFromGroup(Group group, ModelElement p) {
        group.propertyList.remove(p);
        p.group = null;
    }

    public void addPropertyToGroup(Group group, ModelElement p) {
        group.propertyList.add(p);
        p.group = group;
    }

    public void addPropertyToGroup(Group group, ModelElement p, int index) {
        group.propertyList.add(index, p);
    }

    public void removeGroup(Group group) {
        this.groups.remove(group.name);
        this.groupList.remove(group);
    }

    public boolean addGroup(String groupName) {
        if (this.groups.keySet().contains(groupName)) {
            return false;
        }
        Group group = new Group();
        group.name = groupName;
        this.groups.put(groupName, group);
        this.groupList.add(group);
        return true;
    }

    public boolean insertGroup(Group group, int index) {
        if (index >= 0 && index <= this.groupList.size()) {
            this.groups.put(group.name, group);
            this.groupList.add(index, group);
            return true;
        }
        return false;
    }

    public ModelProperty createProperty() {
        return new ModelProperty();
    }

    public Group createSubgroup(Group theGroup, String theSubgroupName) {
        Group subgroup = new Group();
        subgroup.setSubGroup(true);
        subgroup.setName(theSubgroupName);
        this.addPropertyToGroup(theGroup, subgroup);
        return subgroup;
    }

    public ArrayList<Group> getGroupList() {
        return this.groupList;
    }

    public Group getGroup(String groupName) {
        if (groupName.indexOf(groupSeparator) > 0) {
            String[] groupNames = StringTools.toArray(groupName, groupSeparator);
            return this.getGroup(groupNames[0], groupNames[1]);
        }
        return this.groups.get(groupName);
    }

    public Group getGroup(String groupName, String subgroupName) {
        Group group = this.getGroup(groupName);
        if (StringTools.isEmptyString(subgroupName)) {
            return group;
        }
        for (Object modelElement : group.propertyList) {
            if (!(modelElement instanceof Group)) continue;
            Group subgroup = (Group)modelElement;
            if (!subgroup.name.equals(subgroupName)) continue;
            return subgroup;
        }
        return null;
    }

    public Group getGroup(int index) {
        return this.groupList.get(index);
    }

    public HashMap<String, Group> getGroups() {
        return this.groups;
    }

    public boolean setGroupName(Group group, String name) {
        if (this.groups.keySet().contains(name)) {
            return false;
        }
        this.groups.remove(group.name);
        group.name = name;
        this.groups.put(group.name, group);
        return true;
    }

    public String[] getGroupNames() {
        String[] result = new String[this.groupList.size()];
        int i = 0;
        for (Group group : this.groupList) {
            result[i++] = group.getName();
        }
        return result;
    }

    public String[] getAllGroupNames() {
        ArrayList<String> rv = new ArrayList<String>();
        for (Group group : this.groupList) {
            rv.add(group.getName());
            for (Object e : group.propertyList) {
                if (!(e instanceof Group)) continue;
                rv.add(((Group)e).getName());
            }
        }
        String[] result = new String[rv.size()];
        int i = 0;
        for (Object e : rv) {
            result[i++] = (String)e;
        }
        return result;
    }

    public class Group
    extends ModelElement {
        private ArrayList<Object> propertyList;
        private boolean subGroup;

        public Group() {
            this.propertyList = new ArrayList();
            this.subGroup = false;
        }

        public ArrayList<Object> getProperties() {
            return this.propertyList;
        }

        public boolean isSubGroup() {
            return this.subGroup;
        }

        public void setSubGroup(boolean isSubGroup) {
            this.subGroup = isSubGroup;
        }

        @Override
        public String getName() {
            if (this.isSubGroup()) {
                return this.getGroup().getName() + groupSeparator + this.name;
            }
            return this.name;
        }

        public String getCanonicalName() {
            return this.name;
        }
    }

    public class ModelProperty
    extends ModelElement {
        public String description;
        public ComponentDescriptor component;
        public ComponentField var;
        public ContextAttribute attribute;
        public double lowerBound;
        public double upperBound;
        public int length;
    }

    public class ModelElement {
        public String name;
        private Group group;
        private HelpComponent helpComponent = new HelpComponent();

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Group getGroup() {
            return this.group;
        }

        public Group getMainGroup() {
            Group theGroup = this.getGroup();
            if (theGroup.isSubGroup()) {
                return theGroup.getGroup();
            }
            return theGroup;
        }

        public void setGroup(Group group) {
            this.group = group;
        }

        public HelpComponent getHelpComponent() {
            return this.helpComponent;
        }

        public void setHelpComponent(HelpComponent helpComponent) {
            this.helpComponent = helpComponent;
        }
    }
}

