/*
 * Decompiled with CFR 0.152.
 */
package jams.meta;

import jams.JAMSException;
import jams.JAMSLogging;
import jams.meta.ComponentCollection;
import jams.meta.ComponentDescriptor;
import jams.meta.ComponentField;
import jams.meta.ContextDescriptor;
import java.util.Enumeration;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class ModelNode
extends DefaultMutableTreeNode {
    public static final int COMPONENT_TYPE = 0;
    public static final int CONTEXT_TYPE = 1;
    public static final int MODEL_TYPE = 2;
    private int type;

    public ModelNode(Object o) {
        super(o);
        JAMSLogging.registerLogger(JAMSLogging.LogOption.CollectAndShow, Logger.getLogger(this.getClass().getName()));
        if (ComponentDescriptor.class.isAssignableFrom(o.getClass())) {
            ((ComponentDescriptor)o).setNode(this);
        }
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public ModelNode clone(ComponentCollection target, boolean deepCopy, Map<ContextDescriptor, ContextDescriptor> contextMap) {
        ModelNode nodeCopy = null;
        ComponentDescriptor cd = (ComponentDescriptor)this.getUserObject();
        ComponentDescriptor cdCopy = cd.cloneNode();
        nodeCopy = new ModelNode(cdCopy);
        nodeCopy.setType(this.getType());
        cdCopy.register(target);
        if (cd instanceof ContextDescriptor) {
            contextMap.put((ContextDescriptor)cd, (ContextDescriptor)cdCopy);
        }
        if (deepCopy && nodeCopy != null) {
            Enumeration<TreeNode> e = this.children();
            while (e.hasMoreElements()) {
                ModelNode childNode = ((ModelNode)e.nextElement()).clone(target, true, contextMap);
                nodeCopy.add(childNode);
                ComponentDescriptor childCd = (ComponentDescriptor)childNode.getUserObject();
                for (ComponentField field : childCd.getComponentFields().values()) {
                    ContextDescriptor context = field.getContext();
                    if (context == null || !contextMap.containsKey(context)) continue;
                    try {
                        ContextDescriptor newContext = contextMap.get(context);
                        field.linkToAttribute(newContext, field.getAttribute());
                    }
                    catch (JAMSException ex) {
                        Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, ex.getMessage(), ex);
                    }
                }
            }
        }
        return nodeCopy;
    }
}

