/*
 * Decompiled with CFR 0.152.
 */
package jams.meta;

import jams.meta.ContextDescriptor;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MetaProcessorDescriptor {
    private String className;
    private boolean enabled;
    private HashMap<String, String> properties = new HashMap();
    private ContextDescriptor context;

    public MetaProcessorDescriptor(String className, ContextDescriptor context, boolean enabled) {
        this.className = className;
        this.context = context;
        this.enabled = enabled;
    }

    public Document createDocument() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.newDocument();
        Element mpElement = document.createElement("metaprocessor");
        mpElement.setAttribute("context", this.context.getInstanceName());
        mpElement.setAttribute("class", this.getClassName());
        mpElement.setAttribute("enabled", Boolean.toString(this.enabled));
        for (Map.Entry<String, String> e : this.getProperties().entrySet()) {
            Element propertyElement = document.createElement("property");
            propertyElement.setAttribute("name", e.getKey());
            propertyElement.setAttribute("value", e.getValue());
            mpElement.appendChild(propertyElement);
        }
        document.appendChild(mpElement);
        return document;
    }

    public HashMap<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(HashMap<String, String> properties) {
        this.properties = properties;
    }

    public ContextDescriptor getContext() {
        return this.context;
    }

    public String getClassName() {
        return this.className;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

