/*
 * Decompiled with CFR 0.152.
 */
package jams.io.datatracer;

import jams.JAMS;
import jams.dataaccess.DataAccessor;
import jams.io.datatracer.DataTracer;
import jams.model.Context;
import jams.workspace.stores.OutputDataStore;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public abstract class AbstractTracer
implements DataTracer {
    protected DataAccessor[] accessorObjects;
    private ArrayList<String> attributeNames;
    protected Context context;
    private Context[] parents;
    protected OutputDataStore store;
    private Class idClazz;
    private boolean output;

    public AbstractTracer(Context context, OutputDataStore store, Class idClazz) {
        this.context = context;
        this.store = store;
        this.idClazz = idClazz;
        this.init();
    }

    @Override
    public void updateDataAccessors() {
        HashMap dataObjectHash = this.context.getDataAccessorMap();
        ArrayList<DataAccessor> accessorObjectList = new ArrayList<DataAccessor>();
        this.attributeNames = new ArrayList();
        for (String string : this.store.getAttributes()) {
            DataAccessor dataAccessor = (DataAccessor)dataObjectHash.get(string);
            if (dataAccessor == null) continue;
            accessorObjectList.add(dataAccessor);
            this.attributeNames.add(string);
        }
        this.accessorObjects = accessorObjectList.toArray(new DataAccessor[accessorObjectList.size()]);
        block1: for (String string : this.store.getFilters()) {
            Context superContext = this.context;
            while (superContext != null) {
                if (superContext.getInstanceName().equals(string.getContextName())) {
                    string.setContext(superContext);
                    continue block1;
                }
                superContext = this.context.getContext();
            }
        }
    }

    private void init() {
        this.updateDataAccessors();
        this.createHeader();
    }

    private void createHeader() {
        try {
            this.store.open(false);
        }
        catch (IOException ioe) {
            this.context.getModel().getRuntime().sendErrorMsg("Datastore \"" + this.store.getID() + "\": " + JAMS.i18n("Error_creating_data_output_directory!"));
            this.context.getModel().getRuntime().handle((Throwable)ioe, true);
            return;
        }
        Context parent = this.context;
        ArrayList<Context> parentList = new ArrayList<Context>();
        while (parent != this.context.getModel()) {
            if ((parent = parent.getContext()).getNumberOfIterations() == 1L) continue;
            parentList.add(parent);
        }
        this.parents = parentList.toArray(new Context[parentList.size()]);
        this.write("@context\n");
        this.write(this.context.getClass().getName() + "\t" + this.context.getInstanceName() + "\t" + this.context.getNumberOfIterations() + "\n");
        this.write("@ancestors\n");
        for (Context context : this.parents) {
            this.write(context.getClass().getName() + "\t" + context.getInstanceName() + "\t" + context.getNumberOfIterations() + "\n");
        }
        this.write("@filters\n");
        for (Context context : this.store.getFilters()) {
            this.write(context.getContextName() + "\t" + context.getExpression() + "\n");
        }
        this.write("@attributes\n");
        this.write("ID\t");
        for (String attributeName : this.attributeNames) {
            this.write(attributeName + "\t");
        }
        this.write("\n@types\n");
        this.write(this.idClazz.getSimpleName() + "\t");
        for (DataAccessor dataAccessor : this.accessorObjects) {
            this.write(dataAccessor.getComponentObject().getClass().getSimpleName() + "\t");
        }
        this.write("\n@data\n");
    }

    private void write(Object o) {
        try {
            this.store.write(o);
        }
        catch (IOException ioe) {
            this.context.getModel().getRuntime().handle((Throwable)ioe, true);
        }
    }

    protected void output(Object o) {
        try {
            this.store.writeCell(o);
        }
        catch (IOException ioe) {
            this.context.getModel().getRuntime().handle((Throwable)ioe, true);
        }
    }

    protected void nextRow() {
        try {
            this.store.nextRow();
        }
        catch (IOException ioe) {
            this.context.getModel().getRuntime().handle((Throwable)ioe, true);
        }
    }

    protected void flush() {
        try {
            this.store.flush();
        }
        catch (IOException ioe) {
            this.context.getModel().getRuntime().handle((Throwable)ioe, true);
        }
    }

    @Override
    public DataAccessor[] getAccessorObjects() {
        return this.accessorObjects;
    }

    @Override
    public abstract void trace();

    @Override
    public void startMark() {
        for (Context parent : this.parents) {
            this.write(parent.getInstanceName() + "\t" + parent.getTraceMark() + "\n");
        }
        this.write("@start\n");
    }

    @Override
    public void endMark() {
        this.write("@end\n");
    }

    @Override
    public void close() {
        try {
            this.store.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public boolean hasOutput() {
        return this.output;
    }

    @Override
    public void setOutput(boolean output) {
        this.output = output;
    }
}

