/*
 * Decompiled with CFR 0.152.
 */
package jams.io;

import jams.JAMS;
import jams.data.Attribute;
import jams.data.DefaultDataFactory;
import jams.meta.ComponentField;
import jams.meta.ModelDescriptor;
import jams.tools.StringTools;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ParameterProcessor {
    public static final String COMPONENT_ENABLE_VALUE = "%enable%";

    public static Document loadParams(Document model, File paramFile) throws IOException {
        Properties props = new Properties();
        props.load(new FileReader(paramFile));
        return ParameterProcessor.loadParams(model, props);
    }

    public static Document loadParams(Document model, Properties params) {
        HashMap<String, HashMap<String, Element>> componentHash = ParameterProcessor.getAttributeHash(model);
        for (String componentName : componentHash.keySet()) {
            HashMap<String, Element> attributeHash = componentHash.get(componentName);
            for (String attributeName : attributeHash.keySet()) {
                Element attribute = attributeHash.get(attributeName);
                String key = componentName + "." + attribute.getAttribute("name");
                String value = params.getProperty(key);
                if (value == null) continue;
                attribute.setAttribute("value", value);
            }
        }
        return model;
    }

    public static boolean renameAttribute(Document model, String theAttributeName, String newAttribute) {
        boolean found = false;
        ArrayList<Element> elementList = ParameterProcessor.getElementList(model);
        for (Element element : elementList) {
            NodeList childs = element.getChildNodes();
            for (int j = 0; j < childs.getLength(); ++j) {
                String attributeName;
                Node child = childs.item(j);
                if (!child.getNodeName().equals("var")) continue;
                Element var = (Element)child;
                if (var.hasAttribute("attribute") && (attributeName = var.getAttribute("attribute")).equals(theAttributeName)) {
                    var.setAttribute("attribute", newAttribute);
                    System.out.println("could rename attribute " + theAttributeName + " to " + newAttribute);
                    found = true;
                }
                if (!var.hasAttribute("name")) continue;
                String name = var.getAttribute("name");
                String value = var.getAttribute("value");
                if (!name.equals("attributeName") || !value.equals(theAttributeName)) continue;
                var.setAttribute("value", newAttribute);
                System.out.println("changed value at attributeName to " + newAttribute);
            }
        }
        return found;
    }

    public static String getAttributeValue(Document model, String theAttributeName) {
        HashMap<String, HashMap<String, Element>> componentHash = ParameterProcessor.getAttributeHash(model);
        for (String componentName : componentHash.keySet()) {
            HashMap<String, Element> attributeHash = componentHash.get(componentName);
            for (String attributeName : attributeHash.keySet()) {
                Element attribute = attributeHash.get(attributeName);
                String key = componentName + "." + attribute.getAttribute("name");
                if (!key.equals(theAttributeName)) continue;
                return attribute.getAttribute("value");
            }
        }
        return null;
    }

    public static void saveParams(Document model, File paramsFile, String userName, String modelFileName) throws IOException {
        HashMap<String, HashMap<String, Element>> componentHash = ParameterProcessor.getAttributeHash(model);
        Properties params = new Properties();
        for (String componentName : componentHash.keySet()) {
            HashMap<String, Element> attributeHash = componentHash.get(componentName);
            for (String attributeName : attributeHash.keySet()) {
                Element attribute = attributeHash.get(attributeName);
                params.setProperty(componentName + "." + attribute.getAttribute("name"), attribute.getAttribute("value"));
            }
        }
        String userNameString = System.getProperty("user.name");
        if (userName != null && !userName.equals("")) {
            userNameString = userNameString + " <" + userName + ">";
        }
        String modelNameString = model.getDocumentElement().getAttribute("name");
        if (modelFileName != null && !modelFileName.equals("")) {
            modelNameString = modelNameString + " <" + modelFileName + ">";
        }
        params.store(new FileOutputStream(paramsFile), JAMS.i18n("JAMS_model_parameter_file") + "\nUser: " + userNameString + "\nModel: " + modelNameString);
    }

    public static void saveParams(ModelDescriptor md, File paramsFile, String userName, String modelFileName) throws IOException {
        ArrayList<ComponentField> cfList = md.getParameterFields();
        Properties params = new Properties();
        for (ComponentField cf : cfList) {
            params.setProperty(cf.getParent().getInstanceName() + "." + cf.getName(), cf.getValue());
        }
        String userNameString = System.getProperty("user.name");
        if (!StringTools.isEmptyString(userName)) {
            userNameString = userNameString + " <" + userName + ">";
        }
        String modelNameString = md.getModelName();
        if (!StringTools.isEmptyString(modelFileName)) {
            modelNameString = modelNameString + " <" + modelFileName + ">";
        }
        params.store(new FileOutputStream(paramsFile), JAMS.i18n("JAMS_model_parameter_file") + "\nUser: " + userNameString + "\nModel: " + modelNameString);
    }

    public static HashMap<String, Element> getComponentHash(Document model) {
        HashMap<String, Element> componentHash = new HashMap<String, Element>();
        ArrayList<Element> elementList = ParameterProcessor.getElementList(model);
        for (Element element : elementList) {
            componentHash.put(element.getAttribute("name"), element);
        }
        return componentHash;
    }

    public static HashMap<String, HashMap<String, Element>> getAttributeHash(Document model) {
        HashMap<String, HashMap<String, Element>> componentHash = new HashMap<String, HashMap<String, Element>>();
        ArrayList<Element> elementList = ParameterProcessor.getElementList(model);
        for (Element element : elementList) {
            HashMap<String, Element> attributeHash = new HashMap<String, Element>();
            attributeHash.put(element.getAttribute("name"), element);
            NodeList childs = element.getChildNodes();
            for (int j = 0; j < childs.getLength(); ++j) {
                Node child = childs.item(j);
                if (child.getNodeName().equals("var")) {
                    Element var = (Element)child;
                    if (!var.hasAttribute("value")) continue;
                    attributeHash.put(var.getAttribute("name"), var);
                    continue;
                }
                if (!child.getNodeName().equals("attribute")) continue;
                Element attribute = (Element)child;
                attributeHash.put(attribute.getAttribute("name"), attribute);
            }
            componentHash.put(element.getAttribute("name"), attributeHash);
        }
        return componentHash;
    }

    private static ArrayList<Element> getElementList(Document model) {
        Element root = model.getDocumentElement();
        ArrayList<Element> elementList = new ArrayList<Element>();
        elementList.add(root);
        NodeList contextList = root.getElementsByTagName("contextcomponent");
        for (int i = 0; i < contextList.getLength(); ++i) {
            elementList.add((Element)contextList.item(i));
        }
        NodeList componentList = root.getElementsByTagName("component");
        for (int i = 0; i < componentList.getLength(); ++i) {
            elementList.add((Element)componentList.item(i));
        }
        return elementList;
    }

    public static void stripPropertyElements(Document modelDoc) {
        NodeList propertyList = modelDoc.getDocumentElement().getElementsByTagName("property");
        for (int i = 0; i < propertyList.getLength(); ++i) {
            Element propertyElement = (Element)propertyList.item(i);
            propertyElement.removeAttribute("value");
            propertyElement.removeAttribute("default");
        }
    }

    public static void preProcess(Document modelDoc) {
        Element launcherElement = (Element)modelDoc.getDocumentElement().getElementsByTagName("launcher").item(0);
        if (launcherElement == null) {
            return;
        }
        NodeList propertyList = launcherElement.getElementsByTagName("property");
        HashMap<String, HashMap<String, Element>> attributeHash = ParameterProcessor.getAttributeHash(modelDoc);
        for (int i = 0; i < propertyList.getLength(); ++i) {
            String value;
            Element targetElement;
            String elementAttributeName;
            Element propertyElement = (Element)propertyList.item(i);
            if (!propertyElement.hasAttribute("value")) continue;
            String componentName = propertyElement.getAttribute("component");
            String componentAttributeName = propertyElement.getAttribute("attribute");
            HashMap<String, Element> attributeMap = attributeHash.get(componentName);
            if (attributeMap == null) continue;
            if (componentAttributeName.equals(COMPONENT_ENABLE_VALUE)) {
                elementAttributeName = "enabled";
                targetElement = attributeMap.get(componentName);
                Attribute.Boolean a = DefaultDataFactory.getDataFactory().createBoolean();
                a.setValue(propertyElement.getAttribute("value"));
                value = a.toString();
            } else {
                elementAttributeName = "value";
                targetElement = attributeMap.get(componentAttributeName);
                value = propertyElement.getAttribute("value");
            }
            if (targetElement != null) {
                targetElement.setAttribute(elementAttributeName, value);
            }
            propertyElement.removeAttribute("value");
            propertyElement.removeAttribute("default");
        }
    }
}

