/*
 * Decompiled with CFR 0.152.
 */
package jams.data;

import jams.data.Attribute;
import jams.tools.JAMSTools;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class JAMSCalendar
extends GregorianCalendar
implements Attribute.Calendar {
    private static final transient String FORMAT_PATTERN = "yyyy-MM-dd HH:mm";
    private static final transient TimeZone TIME_ZONE = Attribute.Calendar.DEFAULT_TIME_ZONE;
    private DateFormat dateFormat;

    public JAMSCalendar() {
        try {
            BeanInfo info = Introspector.getBeanInfo(JAMSCalendar.class);
            PropertyDescriptor[] propertyDescriptors = info.getPropertyDescriptors();
            for (int i = 0; i < propertyDescriptors.length; ++i) {
                PropertyDescriptor pd = propertyDescriptors[i];
                if (pd.getName().equals("milliSeconds")) continue;
                pd.setValue("transient", Boolean.TRUE);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setTimeInMillis(0L);
        this.initTZ();
    }

    JAMSCalendar(int year, int month, int dayOfMonth, int hourOfDay, int minute, int second) {
        super(year, month, dayOfMonth, hourOfDay, minute, second);
        try {
            BeanInfo info = Introspector.getBeanInfo(JAMSCalendar.class);
            PropertyDescriptor[] propertyDescriptors = info.getPropertyDescriptors();
            for (int i = 0; i < propertyDescriptors.length; ++i) {
                PropertyDescriptor pd = propertyDescriptors[i];
                if (pd.getName().equals("milliSeconds")) continue;
                pd.setValue("transient", Boolean.TRUE);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.set(14, 0);
        this.initTZ();
    }

    private void initTZ() {
        this.setTimeZone(DEFAULT_TIME_ZONE);
        this.dateFormat = new SimpleDateFormat(FORMAT_PATTERN);
        this.dateFormat.setTimeZone(DEFAULT_TIME_ZONE);
    }

    @Override
    public void setTimeZone(TimeZone timezone) {
        super.setTimeZone(timezone);
        this.dateFormat = new SimpleDateFormat(FORMAT_PATTERN);
        this.dateFormat.setTimeZone(timezone);
    }

    @Override
    public JAMSCalendar clone() {
        return new JAMSCalendar(this.get(1), this.get(2), this.get(5), this.get(11), this.get(12), this.get(13));
    }

    @Override
    public String toString() {
        Date date = new Date();
        date.setTime(this.getTimeInMillis());
        return this.dateFormat.format(date);
    }

    public String toString(DateFormat dateFormat) {
        Date date = new Date();
        date.setTime(this.getTimeInMillis());
        dateFormat.setTimeZone(DEFAULT_TIME_ZONE);
        return dateFormat.format(date);
    }

    public Attribute.Calendar getValue() {
        return this.clone();
    }

    public int compareTo(Attribute.Calendar cal, int accuracy) {
        JAMSCalendar cal1 = this.clone();
        Attribute.Calendar cal2 = cal.clone();
        cal1.removeUnsignificantComponents(accuracy);
        cal2.removeUnsignificantComponents(accuracy);
        return cal1.compareTo(cal2);
    }

    public void removeUnsignificantComponents(int accuracy) {
        if (accuracy < 14) {
            this.set(14, 0);
        }
        if (accuracy < 13) {
            this.set(13, 0);
        }
        if (accuracy < 12) {
            this.set(12, 0);
        }
        if (accuracy < 11) {
            this.set(11, 0);
        }
        if (accuracy < 5) {
            this.set(5, 1);
        }
        if (accuracy < 2) {
            this.set(2, 0);
        }
    }

    public void setValue(Attribute.Calendar cal) {
        this.setTimeInMillis(cal.getTimeInMillis());
        this.set(14, 0);
    }

    public void setValue(String value) {
        int[] englishFormat = new int[]{2, 0, 1, 3, 4, 5, 6};
        int[] jamsFormat = new int[]{0, 1, 2, 3, 4, 5, 6};
        String[] dateStrings = new String[]{"1970", "1", "1", "0", "0", "0", "0"};
        String[] parts = value.split("\\s+|:|-|/|\\.");
        int[] index = value.contains("-") ? jamsFormat : englishFormat;
        for (int i = 0; i < parts.length; ++i) {
            dateStrings[i] = parts[index[i]];
        }
        try {
            this.set(1, Integer.parseInt(dateStrings[0]));
        }
        catch (NumberFormatException nfe) {
            JAMSTools.handle(nfe);
        }
        try {
            this.set(2, Integer.parseInt(dateStrings[1]) - 1);
        }
        catch (NumberFormatException nfe) {
            JAMSTools.handle(nfe);
        }
        try {
            this.set(5, Integer.parseInt(dateStrings[2]));
        }
        catch (NumberFormatException nfe) {
            JAMSTools.handle(nfe);
        }
        try {
            this.set(11, Integer.parseInt(dateStrings[3]));
        }
        catch (NumberFormatException nfe) {
            JAMSTools.handle(nfe);
        }
        try {
            this.set(12, Integer.parseInt(dateStrings[4]));
        }
        catch (NumberFormatException nfe) {
            JAMSTools.handle(nfe);
        }
        try {
            this.set(13, Integer.parseInt(dateStrings[5]));
        }
        catch (NumberFormatException nfe) {
            JAMSTools.handle(nfe);
        }
        try {
            this.set(14, Integer.parseInt(dateStrings[6]));
        }
        catch (NumberFormatException nfe) {
            JAMSTools.handle(nfe);
        }
    }

    public void setValue(String value, String format) throws ParseException {
        SimpleDateFormat fromFormat = new SimpleDateFormat(format);
        fromFormat.setTimeZone(this.getTimeZone());
        Date date = fromFormat.parse(value);
        this.setTimeInMillis(date.getTime());
    }

    public void setDateFormat(String formatString) {
        this.dateFormat = new SimpleDateFormat(formatString);
        this.dateFormat.setTimeZone(this.getTimeZone());
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public boolean after(Attribute.Calendar calendar) {
        return super.after(calendar);
    }

    public boolean before(Attribute.Calendar calendar) {
        return super.before(calendar);
    }

    @Override
    public int compareTo(Attribute.Calendar cal) {
        long calTime;
        long thisTime = this.getTimeInMillis();
        return thisTime > (calTime = cal.getTimeInMillis()) ? 1 : (thisTime == calTime ? 0 : -1);
    }

    @Override
    public int get(int field) {
        return super.get(field);
    }

    @Override
    public void add(int field, int amount) {
        super.add(field, amount);
    }
}

