/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.grid.io;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageReadParam;
import javax.imageio.stream.ImageInputStream;
import javax.media.jai.PlanarImage;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.TypeMap;
import org.geotools.coverage.grid.GeneralGridRange;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.grid.io.OverviewPolicy;
import org.geotools.data.DataSourceException;
import org.geotools.data.DefaultServiceInfo;
import org.geotools.data.ServiceInfo;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.builder.GridToEnvelopeMapper;
import org.geotools.referencing.operation.transform.IdentityTransform;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.ColorInterpretation;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridCoverageReader;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public abstract class AbstractGridCoverage2DReader
implements GridCoverageReader {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.data.coverage.grid");
    public static final double EPS = 1.0E-6;
    protected static final Color[] demColors = new Color[]{new Color(5, 90, 5), new Color(150, 200, 150), new Color(190, 150, 20), new Color(100, 100, 50), new Color(200, 210, 220), Color.WHITE, Color.WHITE, Color.WHITE, Color.WHITE};
    protected int numOverviews = 0;
    protected MathTransform raster2Model = null;
    protected CoordinateReferenceSystem crs = null;
    protected GeneralEnvelope originalEnvelope = null;
    protected String coverageName = "geotools_coverage";
    protected Object source = null;
    protected Hints hints = GeoTools.getDefaultHints();
    protected double[] highestRes = null;
    protected boolean closeMe;
    protected boolean gzipped;
    protected GeneralGridRange originalGridRange = null;
    protected ImageInputStream inStream = null;
    protected double[][] overViewResolutions = null;
    protected GridCoverageFactory coverageFactory;
    private ArrayList<Resolution> resolutionsLevels;

    protected Integer setReadParams(OverviewPolicy overviewPolicy, ImageReadParam readP, GeneralEnvelope requestedEnvelope, Rectangle requestedDim) throws IOException, TransformException {
        Integer imageChoice = new Integer(0);
        if (overviewPolicy == null) {
            overviewPolicy = this.extractOverviewPolicy();
        }
        readP.setSourceSubsampling(1, 1, 0, 0);
        if (overviewPolicy.equals((Object)OverviewPolicy.IGNORE)) {
            return imageChoice;
        }
        boolean useOverviews = this.numOverviews > 0;
        double[] requestedRes = AbstractGridCoverage2DReader.getResolution(requestedEnvelope, requestedDim, this.crs);
        if (requestedRes == null) {
            return imageChoice;
        }
        if (useOverviews) {
            imageChoice = this.getOverviewImage(overviewPolicy, requestedRes);
        }
        this.decimationOnReadingControl(imageChoice, readP, requestedRes);
        return imageChoice;
    }

    private OverviewPolicy extractOverviewPolicy() {
        OverviewPolicy overviewPolicy = null;
        if (this.hints != null) {
            if (this.hints.containsKey((Object)Hints.OVERVIEW_POLICY)) {
                overviewPolicy = (OverviewPolicy)((Object)this.hints.get((Object)Hints.OVERVIEW_POLICY));
            } else if (this.hints.containsKey((Object)Hints.IGNORE_COVERAGE_OVERVIEW)) {
                OverviewPolicy overviewPolicy2 = overviewPolicy = (Boolean)this.hints.get((Object)Hints.IGNORE_COVERAGE_OVERVIEW) != false ? OverviewPolicy.IGNORE : OverviewPolicy.QUALITY;
            }
        }
        if (overviewPolicy == null) {
            overviewPolicy = OverviewPolicy.NEAREST;
        }
        assert (overviewPolicy != null);
        return overviewPolicy;
    }

    protected Integer setReadParams(ImageReadParam readP, GeneralEnvelope requestedEnvelope, Rectangle requestedDim) throws IOException, TransformException {
        Object o = this.hints.get((Object)Hints.IGNORE_COVERAGE_OVERVIEW);
        if (o != null && ((Boolean)o).booleanValue()) {
            return this.setReadParams(OverviewPolicy.IGNORE, readP, requestedEnvelope, requestedDim);
        }
        return this.setReadParams(OverviewPolicy.QUALITY, readP, requestedEnvelope, requestedDim);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer getOverviewImage(OverviewPolicy policy, double[] requestedRes) {
        double requestedScaleFactor;
        if (policy == null) {
            policy = this.extractOverviewPolicy();
        }
        AbstractGridCoverage2DReader abstractGridCoverage2DReader = this;
        synchronized (abstractGridCoverage2DReader) {
            if (this.resolutionsLevels == null) {
                this.resolutionsLevels = new ArrayList();
                this.resolutionsLevels.add(new Resolution(1.0, this.highestRes[0], this.highestRes[1], 0));
                if (this.numOverviews > 0) {
                    for (int i = 0; i < this.overViewResolutions.length; ++i) {
                        this.resolutionsLevels.add(new Resolution(this.overViewResolutions[i][0] / this.highestRes[0], this.overViewResolutions[i][0], this.overViewResolutions[i][1], i + 1));
                    }
                    Collections.sort(this.resolutionsLevels);
                }
            }
        }
        double reqx = requestedRes[0];
        double reqy = requestedRes[1];
        Resolution max = this.resolutionsLevels.get(0);
        double requestedScaleFactorX = reqx / max.resolutionX;
        double requestedScaleFactorY = reqy / max.resolutionY;
        boolean leastReduceAxis = !(requestedScaleFactorX <= requestedScaleFactorY);
        double d = requestedScaleFactor = !leastReduceAxis ? requestedScaleFactorX : requestedScaleFactorY;
        if (requestedScaleFactor <= 1.0) {
            return max.imageChoice;
        }
        Resolution min = this.resolutionsLevels.get(this.resolutionsLevels.size() - 1);
        if (requestedScaleFactor >= min.scaleFactor) {
            return min.imageChoice;
        }
        Resolution prev = max;
        int size = this.resolutionsLevels.size();
        for (int i = 1; i < size; ++i) {
            Resolution curr = this.resolutionsLevels.get(i);
            if (curr.scaleFactor == requestedScaleFactor) {
                return curr.imageChoice;
            }
            if (curr.scaleFactor > requestedScaleFactor || i == size - 1) {
                if (policy == Hints.VALUE_OVERVIEW_POLICY_QUALITY) {
                    return prev.imageChoice;
                }
                if (policy == Hints.VALUE_OVERVIEW_POLICY_SPEED) {
                    return curr.imageChoice;
                }
                if (requestedScaleFactor - prev.scaleFactor < curr.scaleFactor - requestedScaleFactor) {
                    return prev.imageChoice;
                }
                return curr.imageChoice;
            }
            prev = curr;
        }
        return max.imageChoice;
    }

    protected final void decimationOnReadingControl(Integer imageChoice, ImageReadParam readP, double[] requestedRes) {
        int h;
        int w;
        double[] selectedRes = new double[2];
        int choice = imageChoice;
        if (choice == 0) {
            w = this.originalGridRange.getLength(0);
            h = this.originalGridRange.getLength(1);
            selectedRes[0] = this.highestRes[0];
            selectedRes[1] = this.highestRes[1];
        } else {
            selectedRes[0] = this.overViewResolutions[choice - 1][0];
            selectedRes[1] = this.overViewResolutions[choice - 1][1];
            w = (int)Math.round(this.originalEnvelope.getLength(0) / selectedRes[0]);
            h = (int)Math.round(this.originalEnvelope.getLength(1) / selectedRes[1]);
        }
        if (requestedRes == null) {
            readP.setSourceSubsampling(1, 1, 0, 0);
        } else {
            int subSamplingFactorX = (int)Math.floor(requestedRes[0] / selectedRes[0]);
            int n = subSamplingFactorX = subSamplingFactorX == 0 ? 1 : subSamplingFactorX;
            while (w / subSamplingFactorX <= 0 && subSamplingFactorX >= 0) {
                --subSamplingFactorX;
            }
            subSamplingFactorX = subSamplingFactorX == 0 ? 1 : subSamplingFactorX;
            int subSamplingFactorY = (int)Math.floor(requestedRes[1] / selectedRes[1]);
            int n2 = subSamplingFactorY = subSamplingFactorY == 0 ? 1 : subSamplingFactorY;
            while (h / subSamplingFactorY <= 0 && subSamplingFactorY >= 0) {
                --subSamplingFactorY;
            }
            subSamplingFactorY = subSamplingFactorY == 0 ? 1 : subSamplingFactorY;
            readP.setSourceSubsampling(subSamplingFactorX, subSamplingFactorY, 0, 0);
        }
    }

    protected final GridCoverage createImageCoverage(PlanarImage image) throws IOException {
        return this.createImageCoverage(image, null);
    }

    protected final GridCoverage createImageCoverage(PlanarImage image, MathTransform raster2Model) throws IOException {
        SampleModel sm = image.getSampleModel();
        ColorModel cm = image.getColorModel();
        int numBands = sm.getNumBands();
        GridSampleDimension[] bands = new GridSampleDimension[numBands];
        for (int i = 0; i < numBands; ++i) {
            ColorInterpretation colorInterpretation = TypeMap.getColorInterpretation(cm, i);
            if (colorInterpretation == null) {
                throw new IOException("Unrecognized sample dimension type");
            }
            bands[i] = new GridSampleDimension(colorInterpretation.name()).geophysics(true);
        }
        if (raster2Model != null) {
            return this.coverageFactory.create(this.coverageName, (RenderedImage)image, this.crs, raster2Model, bands, null, null);
        }
        return this.coverageFactory.create((CharSequence)this.coverageName, (RenderedImage)image, new GeneralEnvelope(this.originalEnvelope), bands, null, null);
    }

    protected static final double[] getResolution(GeneralEnvelope envelope, Rectangle2D dim, CoordinateReferenceSystem crs) throws DataSourceException {
        double[] requestedRes = null;
        try {
            if (dim != null && envelope != null && crs != null) {
                MathTransform tr;
                SingleCRS crs2D = CRS.getHorizontalCRS(envelope.getCoordinateReferenceSystem());
                if (crs2D != null && !CRS.equalsIgnoreMetadata(crs, crs2D) && !(tr = CRS.findMathTransform((CoordinateReferenceSystem)crs2D, crs, true)).isIdentity()) {
                    envelope = CRS.transform(tr, (Envelope)envelope);
                    envelope.setCoordinateReferenceSystem(crs);
                }
                requestedRes = new double[]{envelope.getLength(0) / dim.getWidth(), envelope.getLength(1) / dim.getHeight()};
            }
            return requestedRes;
        }
        catch (TransformException e) {
            throw new DataSourceException("Unable to get resolution", e);
        }
        catch (FactoryException e) {
            throw new DataSourceException("Unable to get resolution", e);
        }
    }

    public final CoordinateReferenceSystem getCrs() {
        return this.crs;
    }

    public final GeneralGridRange getOriginalGridRange() {
        return this.originalGridRange;
    }

    public final GeneralEnvelope getOriginalEnvelope() {
        return this.originalEnvelope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final MathTransform getOriginalGridToWorld(PixelInCell pixInCell) {
        AffineTransform tr;
        AbstractGridCoverage2DReader abstractGridCoverage2DReader = this;
        synchronized (abstractGridCoverage2DReader) {
            if (this.raster2Model == null) {
                GridToEnvelopeMapper geMapper = new GridToEnvelopeMapper(this.originalGridRange, this.originalEnvelope);
                geMapper.setPixelAnchor(PixelInCell.CELL_CENTER);
                this.raster2Model = geMapper.createTransform();
            }
        }
        if (pixInCell == PixelInCell.CELL_CENTER) {
            return this.raster2Model;
        }
        if (this.raster2Model instanceof AffineTransform) {
            tr = new AffineTransform((AffineTransform)this.raster2Model);
            tr.concatenate(AffineTransform.getTranslateInstance(-0.5, -0.5));
            return ProjectiveTransform.create(tr);
        }
        if (this.raster2Model instanceof IdentityTransform) {
            tr = new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
            tr.concatenate(AffineTransform.getTranslateInstance(-0.5, -0.5));
            return ProjectiveTransform.create(tr);
        }
        throw new IllegalStateException("This reader's grid to world transform is invalud!");
    }

    public final Object getSource() {
        return this.source;
    }

    public void dispose() {
        block3: {
            if (this.inStream != null && this.closeMe) {
                try {
                    this.inStream.close();
                }
                catch (IOException e) {
                    if (!LOGGER.isLoggable(Level.FINE)) break block3;
                    LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                }
            }
        }
    }

    public void skip() {
        throw new UnsupportedOperationException("Unsupported opertion.");
    }

    public boolean hasMoreGridCoverages() {
        throw new UnsupportedOperationException("Unsupported opertion.");
    }

    public String[] listSubNames() {
        throw new UnsupportedOperationException("Unsupported opertion.");
    }

    public String getCurrentSubname() {
        throw new UnsupportedOperationException("Unsupported opertion.");
    }

    public String[] getMetadataNames() {
        throw new UnsupportedOperationException("Unsupported opertion.");
    }

    public String getMetadataValue(String name) {
        throw new UnsupportedOperationException("Unsupported opertion.");
    }

    public int getGridCoverageCount() {
        throw new UnsupportedOperationException("Unsupported opertion.");
    }

    public ServiceInfo getInfo() {
        DefaultServiceInfo info = new DefaultServiceInfo();
        info.setDescription(this.source.toString());
        if (this.source instanceof URL) {
            URL url = (URL)this.source;
            info.setTitle(url.getFile());
            try {
                info.setSource(url.toURI());
            }
            catch (URISyntaxException e) {}
        } else if (this.source instanceof File) {
            File file = (File)this.source;
            String filename = file.getName();
            if (filename == null || filename.length() == 0) {
                info.setTitle(file.getName());
            }
            info.setSource(file.toURI());
        }
        return info;
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Resolution
    implements Comparable<Resolution> {
        double scaleFactor;
        double resolutionX;
        double resolutionY;
        int imageChoice;

        public Resolution(double scaleFactor, double resolutionX, double resolutionY, int imageChoice) {
            this.scaleFactor = scaleFactor;
            this.resolutionX = resolutionX;
            this.resolutionY = resolutionY;
            this.imageChoice = imageChoice;
        }

        @Override
        public int compareTo(Resolution other) {
            if (this.scaleFactor > other.scaleFactor) {
                return 1;
            }
            if (this.scaleFactor < other.scaleFactor) {
                return -1;
            }
            return 0;
        }

        public String toString() {
            return "Resolution[Choice=" + this.imageChoice + ",scaleFactor=" + this.scaleFactor + "]";
        }
    }
}

