/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import nom.tam.util.ArrayDataInput;

public class BufferedDataInputStream
extends BufferedInputStream
implements ArrayDataInput {
    private int primitiveArrayCount;
    private byte[] bb = new byte[8];

    public BufferedDataInputStream(InputStream inputStream) {
        super(inputStream, 32768);
    }

    public BufferedDataInputStream(InputStream inputStream, int n) {
        super(inputStream, n);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n2 > 0) {
            int n4 = super.read(byArray, n, n2);
            if (n4 <= 0) {
                if (n3 == 0) {
                    throw new EOFException();
                }
                return n3;
            }
            n2 -= n4;
            n3 += n4;
            n += n4;
        }
        return n3;
    }

    public boolean readBoolean() throws IOException {
        int n = this.read();
        return n == 1;
    }

    public byte readByte() throws IOException {
        return (byte)this.read();
    }

    public int readUnsignedByte() throws IOException {
        return this.read() | 0xFF;
    }

    public int readInt() throws IOException {
        if (this.read(this.bb, 0, 4) < 4) {
            throw new EOFException();
        }
        int n = this.bb[0] << 24 | (this.bb[1] & 0xFF) << 16 | (this.bb[2] & 0xFF) << 8 | this.bb[3] & 0xFF;
        return n;
    }

    public short readShort() throws IOException {
        if (this.read(this.bb, 0, 2) < 2) {
            throw new EOFException();
        }
        short s = (short)(this.bb[0] << 8 | this.bb[1] & 0xFF);
        return s;
    }

    public int readUnsignedShort() throws IOException {
        if (this.read(this.bb, 0, 2) < 2) {
            throw new EOFException();
        }
        return (this.bb[0] & 0xFF) << 8 | this.bb[1] & 0xFF;
    }

    public char readChar() throws IOException {
        byte[] byArray = new byte[2];
        if (this.read(byArray, 0, 2) < 2) {
            throw new EOFException();
        }
        char c = (char)(byArray[0] << 8 | byArray[1] & 0xFF);
        return c;
    }

    public long readLong() throws IOException {
        if (this.read(this.bb, 0, 8) < 8) {
            throw new EOFException();
        }
        int n = this.bb[0] << 24 | (this.bb[1] & 0xFF) << 16 | (this.bb[2] & 0xFF) << 8 | this.bb[3] & 0xFF;
        int n2 = this.bb[4] << 24 | (this.bb[5] & 0xFF) << 16 | (this.bb[6] & 0xFF) << 8 | this.bb[7] & 0xFF;
        return (long)n << 32 | (long)n2 & 0xFFFFFFFFL;
    }

    public float readFloat() throws IOException {
        if (this.read(this.bb, 0, 4) < 4) {
            throw new EOFException();
        }
        int n = this.bb[0] << 24 | (this.bb[1] & 0xFF) << 16 | (this.bb[2] & 0xFF) << 8 | this.bb[3] & 0xFF;
        return Float.intBitsToFloat(n);
    }

    public double readDouble() throws IOException {
        if (this.read(this.bb, 0, 8) < 8) {
            throw new EOFException();
        }
        int n = this.bb[0] << 24 | (this.bb[1] & 0xFF) << 16 | (this.bb[2] & 0xFF) << 8 | this.bb[3] & 0xFF;
        int n2 = this.bb[4] << 24 | (this.bb[5] & 0xFF) << 16 | (this.bb[6] & 0xFF) << 8 | this.bb[7] & 0xFF;
        return Double.longBitsToDouble((long)n << 32 | (long)n2 & 0xFFFFFFFFL);
    }

    public void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IOException("Attempt to read outside byte array");
        }
        if (this.read(byArray, n, n2) < n2) {
            throw new EOFException();
        }
    }

    public int skipBytes(int n) throws IOException {
        int n2 = n;
        while (n2 > 0) {
            int n3 = (int)this.skip(n2);
            if (n3 <= 0) break;
            n2 -= n3;
        }
        if (n2 > 0) {
            throw new EOFException();
        }
        return n;
    }

    public String readUTF() throws IOException {
        DataInputStream dataInputStream = new DataInputStream(this);
        return dataInputStream.readUTF();
    }

    public String readLine() throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this));
        return bufferedReader.readLine();
    }

    public int readPrimitiveArray(Object object) throws IOException {
        this.primitiveArrayCount = 0;
        return this.primitiveArrayRecurse(object);
    }

    public int readArray(Object object) throws IOException {
        this.primitiveArrayCount = 0;
        return this.primitiveArrayRecurse(object);
    }

    protected int primitiveArrayRecurse(Object object) throws IOException {
        if (object == null) {
            return this.primitiveArrayCount;
        }
        String string = object.getClass().getName();
        if (string.charAt(0) != '[') {
            throw new IOException("Invalid object passed to BufferedDataInputStream.readArray:" + string);
        }
        if (string.charAt(1) == '[') {
            int n = 0;
            while (n < ((Object[])object).length) {
                this.primitiveArrayRecurse(((Object[])object)[n]);
                ++n;
            }
        } else {
            switch (string.charAt(1)) {
                case 'Z': {
                    this.primitiveArrayCount += this.read((boolean[])object, 0, ((boolean[])object).length);
                    break;
                }
                case 'B': {
                    int n = this.read((byte[])object, 0, ((byte[])object).length);
                    this.primitiveArrayCount += n;
                    if (n < ((byte[])object).length) {
                        throw new EOFException();
                    }
                    break;
                }
                case 'C': {
                    this.primitiveArrayCount += this.read((char[])object, 0, ((char[])object).length);
                    break;
                }
                case 'S': {
                    this.primitiveArrayCount += this.read((short[])object, 0, ((short[])object).length);
                    break;
                }
                case 'I': {
                    this.primitiveArrayCount += this.read((int[])object, 0, ((int[])object).length);
                    break;
                }
                case 'J': {
                    this.primitiveArrayCount += this.read((long[])object, 0, ((long[])object).length);
                    break;
                }
                case 'F': {
                    this.primitiveArrayCount += this.read((float[])object, 0, ((float[])object).length);
                    break;
                }
                case 'D': {
                    this.primitiveArrayCount += this.read((double[])object, 0, ((double[])object).length);
                    break;
                }
                case 'L': {
                    if (string.equals("[Ljava.lang.Object;")) {
                        int n = 0;
                        while (n < ((Object[])object).length) {
                            this.primitiveArrayRecurse(((Object[])object)[n]);
                            ++n;
                        }
                        break;
                    }
                    throw new IOException("Invalid object passed to BufferedDataInputStream.readArray: " + string);
                }
                default: {
                    throw new IOException("Invalid object passed to BufferedDataInputStream.readArray: " + string);
                }
            }
        }
        return this.primitiveArrayCount;
    }

    private void fillBuf(int n) throws IOException {
        if (this.count > this.pos) {
            System.arraycopy(this.buf, this.pos, this.buf, 0, this.count - this.pos);
            this.count -= this.pos;
            n -= this.count;
            this.pos = 0;
        } else {
            this.count = 0;
            this.pos = 0;
        }
        while (n > 0) {
            int n2 = this.in.read(this.buf, this.count, this.buf.length - this.count);
            if (n2 <= 0) {
                throw new EOFException();
            }
            this.count += n2;
            n -= n2;
        }
    }

    public int read(boolean[] blArray) throws IOException {
        return this.read(blArray, 0, blArray.length);
    }

    public int read(boolean[] blArray, int n, int n2) throws IOException {
        int n3 = n;
        try {
            while (n3 < n + n2) {
                if (this.pos >= this.count) {
                    this.fillBuf(1);
                }
                blArray[n3] = this.buf[this.pos] == 1;
                ++this.pos;
                ++n3;
            }
        }
        catch (EOFException eOFException) {
            return this.eofCheck(eOFException, n3, n, 1);
        }
        return n2;
    }

    public int read(short[] sArray) throws IOException {
        return this.read(sArray, 0, sArray.length);
    }

    public int read(short[] sArray, int n, int n2) throws IOException {
        int n3 = n;
        try {
            while (n3 < n + n2) {
                if (this.count - this.pos < 2) {
                    this.fillBuf(2);
                }
                sArray[n3] = (short)(this.buf[this.pos] << 8 | this.buf[this.pos + 1] & 0xFF);
                this.pos += 2;
                ++n3;
            }
        }
        catch (EOFException eOFException) {
            return this.eofCheck(eOFException, n3, n, 2);
        }
        return 2 * n2;
    }

    public int read(char[] cArray) throws IOException {
        return this.read(cArray, 0, cArray.length);
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        int n3 = n;
        try {
            while (n3 < n + n2) {
                if (this.count - this.pos < 2) {
                    this.fillBuf(2);
                }
                cArray[n3] = (char)(this.buf[this.pos] << 8 | this.buf[this.pos + 1] & 0xFF);
                this.pos += 2;
                ++n3;
            }
        }
        catch (EOFException eOFException) {
            return this.eofCheck(eOFException, n3, n, 2);
        }
        return 2 * n2;
    }

    public int read(int[] nArray) throws IOException {
        return this.read(nArray, 0, nArray.length);
    }

    public int read(int[] nArray, int n, int n2) throws IOException {
        int n3 = n;
        try {
            while (n3 < n + n2) {
                if (this.count - this.pos < 4) {
                    this.fillBuf(4);
                }
                nArray[n3] = this.buf[this.pos] << 24 | (this.buf[this.pos + 1] & 0xFF) << 16 | (this.buf[this.pos + 2] & 0xFF) << 8 | this.buf[this.pos + 3] & 0xFF;
                this.pos += 4;
                ++n3;
            }
        }
        catch (EOFException eOFException) {
            return this.eofCheck(eOFException, n3, n, 4);
        }
        return nArray.length * 4;
    }

    public int read(long[] lArray) throws IOException {
        return this.read(lArray, 0, lArray.length);
    }

    public int read(long[] lArray, int n, int n2) throws IOException {
        int n3 = n;
        try {
            while (n3 < n + n2) {
                if (this.count - this.pos < 8) {
                    this.fillBuf(8);
                }
                int n4 = this.buf[this.pos] << 24 | (this.buf[this.pos + 1] & 0xFF) << 16 | (this.buf[this.pos + 2] & 0xFF) << 8 | this.buf[this.pos + 3] & 0xFF;
                int n5 = this.buf[this.pos + 4] << 24 | (this.buf[this.pos + 5] & 0xFF) << 16 | (this.buf[this.pos + 6] & 0xFF) << 8 | this.buf[this.pos + 7] & 0xFF;
                lArray[n3] = (long)n4 << 32 | (long)n5 & 0xFFFFFFFFL;
                this.pos += 8;
                ++n3;
            }
        }
        catch (EOFException eOFException) {
            return this.eofCheck(eOFException, n3, n, 8);
        }
        return 8 * n2;
    }

    public int read(float[] fArray) throws IOException {
        return this.read(fArray, 0, fArray.length);
    }

    public int read(float[] fArray, int n, int n2) throws IOException {
        int n3 = n;
        try {
            while (n3 < n + n2) {
                if (this.count - this.pos < 4) {
                    this.fillBuf(4);
                }
                int n4 = this.buf[this.pos] << 24 | (this.buf[this.pos + 1] & 0xFF) << 16 | (this.buf[this.pos + 2] & 0xFF) << 8 | this.buf[this.pos + 3] & 0xFF;
                fArray[n3] = Float.intBitsToFloat(n4);
                this.pos += 4;
                ++n3;
            }
        }
        catch (EOFException eOFException) {
            return this.eofCheck(eOFException, n3, n, 4);
        }
        return 4 * n2;
    }

    public int read(double[] dArray) throws IOException {
        return this.read(dArray, 0, dArray.length);
    }

    public int read(double[] dArray, int n, int n2) throws IOException {
        int n3 = n;
        try {
            while (n3 < n + n2) {
                if (this.count - this.pos < 8) {
                    this.fillBuf(8);
                }
                int n4 = this.buf[this.pos] << 24 | (this.buf[this.pos + 1] & 0xFF) << 16 | (this.buf[this.pos + 2] & 0xFF) << 8 | this.buf[this.pos + 3] & 0xFF;
                int n5 = this.buf[this.pos + 4] << 24 | (this.buf[this.pos + 5] & 0xFF) << 16 | (this.buf[this.pos + 6] & 0xFF) << 8 | this.buf[this.pos + 7] & 0xFF;
                dArray[n3] = Double.longBitsToDouble((long)n4 << 32 | (long)n5 & 0xFFFFFFFFL);
                this.pos += 8;
                ++n3;
            }
        }
        catch (EOFException eOFException) {
            return this.eofCheck(eOFException, n3, n, 8);
        }
        return 8 * n2;
    }

    private int eofCheck(EOFException eOFException, int n, int n2, int n3) throws EOFException {
        if (n == n2) {
            throw eOFException;
        }
        return (n - n2) * n3;
    }

    public String toString() {
        return super.toString() + "[count=" + this.count + ",pos=" + this.pos + "]";
    }
}

