/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import java.io.IOException;
import java.lang.reflect.Array;
import nom.tam.fits.Data;
import nom.tam.fits.FitsException;
import nom.tam.fits.FitsUtil;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCard;
import nom.tam.fits.HeaderCardException;
import nom.tam.fits.TableData;
import nom.tam.util.ArrayDataInput;
import nom.tam.util.ArrayDataOutput;
import nom.tam.util.ArrayFuncs;
import nom.tam.util.ByteFormatter;
import nom.tam.util.ByteParser;
import nom.tam.util.Cursor;
import nom.tam.util.FormatException;
import nom.tam.util.RandomAccess;
import nom.tam.util.TruncationException;

public class AsciiTable
extends Data
implements TableData {
    private int nRows;
    private int nFields;
    private int rowLen;
    private String[] nulls;
    private Class[] types;
    private int[] offsets;
    private int[] lengths;
    private byte[] buffer;
    private boolean[] isNull;
    private Object[] data;
    ByteParser bp;
    ArrayDataInput currInput;
    static /* synthetic */ Class class$java$lang$String;

    public AsciiTable(Header header) throws FitsException {
        this.nRows = header.getIntValue("NAXIS2");
        this.nFields = header.getIntValue("TFIELDS");
        this.rowLen = header.getIntValue("NAXIS1");
        this.types = new Class[this.nFields];
        this.offsets = new int[this.nFields];
        this.lengths = new int[this.nFields];
        this.nulls = new String[this.nFields];
        int n = 0;
        while (n < this.nFields) {
            this.offsets[n] = header.getIntValue("TBCOL" + (n + 1)) - 1;
            String string = header.getStringValue("TFORM" + (n + 1));
            if (this.offsets[n] < 0 || string == null) {
                throw new FitsException("Invalid Specification for column:" + (n + 1));
            }
            string = string.trim();
            char c = string.charAt(0);
            if ((string = string.substring(1)).indexOf(46) > 0) {
                string = string.substring(0, string.indexOf(46));
            }
            this.lengths[n] = Integer.parseInt(string);
            switch (c) {
                case 'A': {
                    this.types[n] = class$java$lang$String == null ? AsciiTable.class$("java.lang.String") : class$java$lang$String;
                    break;
                }
                case 'I': {
                    if (this.lengths[n] > 10) {
                        this.types[n] = Long.TYPE;
                        break;
                    }
                    this.types[n] = Integer.TYPE;
                    break;
                }
                case 'E': 
                case 'F': {
                    this.types[n] = Float.TYPE;
                    break;
                }
                case 'D': {
                    this.types[n] = Double.TYPE;
                }
            }
            this.nulls[n] = header.getStringValue("TNULL" + (n + 1));
            if (this.nulls[n] != null) {
                this.nulls[n] = this.nulls[n].trim();
            }
            ++n;
        }
    }

    public AsciiTable() {
        this.data = new Object[0];
        this.buffer = null;
        this.nFields = 0;
        this.nRows = 0;
        this.rowLen = 0;
        this.types = new Class[0];
        this.lengths = new int[0];
        this.offsets = new int[0];
        this.nulls = new String[0];
    }

    public void read(ArrayDataInput arrayDataInput) throws FitsException {
        this.setFileOffset(arrayDataInput);
        this.currInput = arrayDataInput;
        if (arrayDataInput instanceof RandomAccess) {
            try {
                arrayDataInput.skipBytes(this.nRows * this.rowLen);
            }
            catch (IOException iOException) {
                throw new FitsException("Error skipping data: " + iOException);
            }
        }
        try {
            this.getBuffer(this.rowLen * this.nRows, 0L);
        }
        catch (IOException iOException) {
            throw new FitsException("Error reading ASCII table:" + iOException);
        }
        try {
            arrayDataInput.skipBytes(FitsUtil.padding(this.nRows * this.rowLen));
        }
        catch (IOException iOException) {
            throw new FitsException("Error skipping padding:" + iOException);
        }
    }

    private void getBuffer(int n, long l) throws IOException, FitsException {
        if (this.currInput == null) {
            throw new IOException("No stream open to read");
        }
        this.buffer = new byte[n];
        if (l != 0L) {
            FitsUtil.reposition(this.currInput, l);
        }
        this.currInput.readFully(this.buffer);
        if (this.bp == null) {
            this.bp = new ByteParser(this.buffer);
        }
        this.bp.setBuffer(this.buffer);
    }

    public Object getData() throws FitsException {
        if (this.data == null) {
            this.data = new Object[this.nFields];
            int n = 0;
            while (n < this.nFields) {
                this.data[n] = ArrayFuncs.newInstance(this.types[n], this.nRows);
                ++n;
            }
            if (this.buffer == null) {
                long l = FitsUtil.findOffset(this.currInput);
                try {
                    this.getBuffer(this.nRows * this.rowLen, this.fileOffset);
                }
                catch (IOException iOException) {
                    throw new FitsException("Error in deferred read -- file closed prematurely?:" + iOException);
                }
                FitsUtil.reposition(this.currInput, l);
            }
            this.bp.setOffset(0);
            int n2 = 0;
            while (n2 < this.nRows) {
                int n3 = this.rowLen * n2;
                int n4 = 0;
                while (n4 < this.nFields) {
                    if (!this.extractElement(n3 + this.offsets[n4], this.lengths[n4], this.data, n4, n2, this.nulls[n4])) {
                        if (this.isNull == null) {
                            this.isNull = new boolean[this.nRows * this.nFields];
                        }
                        this.isNull[n4 + n2 * this.nFields] = true;
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return this.data;
    }

    private boolean extractElement(int n, int n2, Object[] objectArray, int n3, int n4, String string) throws FitsException {
        block9: {
            this.bp.setOffset(n);
            if (string != null) {
                String string2 = this.bp.getString(n2);
                if (string2.trim().equals(string)) {
                    return false;
                }
                this.bp.skip(-n2);
            }
            try {
                if (objectArray[n3] instanceof String[]) {
                    ((String[])objectArray[n3])[n4] = this.bp.getString(n2);
                    break block9;
                }
                if (objectArray[n3] instanceof int[]) {
                    ((int[])objectArray[n3])[n4] = this.bp.getInt(n2);
                    break block9;
                }
                if (objectArray[n3] instanceof float[]) {
                    ((float[])objectArray[n3])[n4] = this.bp.getFloat(n2);
                    break block9;
                }
                if (objectArray[n3] instanceof double[]) {
                    ((double[])objectArray[n3])[n4] = this.bp.getDouble(n2);
                    break block9;
                }
                if (objectArray[n3] instanceof long[]) {
                    ((long[])objectArray[n3])[n4] = this.bp.getLong(n2);
                    break block9;
                }
                throw new FitsException("Invalid type for ASCII table conversion:" + objectArray[n3]);
            }
            catch (FormatException formatException) {
                throw new FitsException("Error parsing data at row,col:" + n4 + "," + n3 + "  " + formatException);
            }
        }
        return true;
    }

    public Object getColumn(int n) throws FitsException {
        if (this.data == null) {
            this.buffer = null;
            this.getData();
        }
        return this.data[n];
    }

    public Object[] getRow(int n) throws FitsException {
        if (this.data != null) {
            return this.singleRow(n);
        }
        return this.parseSingleRow(n);
    }

    public Object getElement(int n, int n2) throws FitsException {
        if (this.data != null) {
            return this.singleElement(n, n2);
        }
        return this.parseSingleElement(n, n2);
    }

    private Object[] singleRow(int n) {
        Object[] objectArray = new Object[this.nFields];
        int n2 = 0;
        while (n2 < this.nFields) {
            if (this.isNull == null || !this.isNull[n * this.nFields + n2]) {
                objectArray[n2] = ArrayFuncs.newInstance(this.types[n2], 1);
                System.arraycopy(this.data[n2], n, objectArray[n2], 0, 1);
            }
            ++n2;
        }
        return objectArray;
    }

    private Object singleElement(int n, int n2) {
        Object object = null;
        if (this.isNull == null || !this.isNull[n * this.nFields + n2]) {
            object = ArrayFuncs.newInstance(this.types[n2], 1);
            System.arraycopy(this.data[n2], n, object, 0, 1);
        }
        return object;
    }

    private Object[] parseSingleRow(int n) throws FitsException {
        int n2 = n * this.rowLen;
        Object[] objectArray = new Object[this.nFields];
        try {
            this.getBuffer(this.rowLen, this.fileOffset + (long)(n * this.rowLen));
        }
        catch (IOException iOException) {
            throw new FitsException("Unable to read row");
        }
        int n3 = 0;
        while (n3 < this.nFields) {
            objectArray[n3] = ArrayFuncs.newInstance(this.types[n3], 1);
            if (!this.extractElement(this.offsets[n3], this.lengths[n3], objectArray, n3, 0, this.nulls[n3])) {
                objectArray[n3] = null;
            }
            ++n3;
        }
        return objectArray;
    }

    private Object parseSingleElement(int n, int n2) throws FitsException {
        Object[] objectArray = new Object[1];
        try {
            this.getBuffer(this.lengths[n2], this.fileOffset + (long)(n * this.rowLen) + (long)this.offsets[n2]);
        }
        catch (IOException iOException) {
            throw new FitsException("Unable to read element");
        }
        objectArray[0] = ArrayFuncs.newInstance(this.types[n2], 1);
        if (this.extractElement(0, this.lengths[n2], objectArray, 0, 0, this.nulls[n2])) {
            return objectArray[0];
        }
        return null;
    }

    public void write(ArrayDataOutput arrayDataOutput) throws FitsException {
        int n;
        if (this.data == null) {
            throw new FitsException("Attempt to write undefined data");
        }
        this.buffer = new byte[this.nRows * this.rowLen];
        this.bp = new ByteParser(this.buffer);
        int n2 = 0;
        while (n2 < this.buffer.length) {
            this.buffer[n2] = 32;
            ++n2;
        }
        ByteFormatter byteFormatter = new ByteFormatter();
        byteFormatter.setTruncationThrow(false);
        byteFormatter.setTruncateOnOverflow(true);
        int n3 = 0;
        while (n3 < this.nRows) {
            int n4 = 0;
            while (n4 < this.nFields) {
                n = n3 * this.rowLen + this.offsets[n4];
                int n5 = this.lengths[n4];
                try {
                    Object[] objectArray;
                    if (this.isNull != null && this.isNull[n3 * this.nFields + n4]) {
                        if (this.nulls[n4] == null) {
                            throw new FitsException("No null value set when needed");
                        }
                        byteFormatter.format(this.nulls[n4], this.buffer, n, n5);
                    } else if (this.types[n4] == (class$java$lang$String == null ? AsciiTable.class$("java.lang.String") : class$java$lang$String)) {
                        objectArray = (String[])this.data[n4];
                        byteFormatter.format(objectArray[n3], this.buffer, n, n5);
                    } else if (this.types[n4] == Integer.TYPE) {
                        objectArray = (int[])this.data[n4];
                        byteFormatter.format((int)objectArray[n3], this.buffer, n, n5);
                    } else if (this.types[n4] == Float.TYPE) {
                        objectArray = (float[])this.data[n4];
                        byteFormatter.format((float)objectArray[n3], this.buffer, n, n5);
                    } else if (this.types[n4] == Double.TYPE) {
                        objectArray = (double[])this.data[n4];
                        byteFormatter.format((double)objectArray[n3], this.buffer, n, n5);
                    } else if (this.types[n4] == Long.TYPE) {
                        objectArray = (long[])this.data[n4];
                        byteFormatter.format((long)objectArray[n3], this.buffer, n, n5);
                    }
                }
                catch (TruncationException truncationException) {
                    System.err.println("Ignoring truncation error:" + n3 + "," + n4);
                }
                ++n4;
            }
            ++n3;
        }
        try {
            arrayDataOutput.write(this.buffer);
            byte[] byArray = new byte[FitsUtil.padding(this.buffer.length)];
            n = 0;
            while (n < byArray.length) {
                byArray[n] = 32;
                ++n;
            }
            if (this.buffer.length > 0) {
                arrayDataOutput.write(byArray);
            }
            arrayDataOutput.flush();
        }
        catch (IOException iOException) {
            throw new FitsException("Error writing ASCII Table data");
        }
    }

    public void setColumn(int n, Object object) throws FitsException {
        if (this.data == null) {
            this.buffer = null;
            this.getData();
        }
        if (n < 0 || n >= this.nFields || object.getClass() != this.data[n].getClass() || Array.getLength(object) != Array.getLength(this.data[n])) {
            throw new FitsException("Invalid column/column mismatch:" + n);
        }
        this.data[n] = object;
    }

    public void setRow(int n, Object[] objectArray) throws FitsException {
        if (n < 0 || n > this.nRows) {
            throw new FitsException("Invalid row in setRow");
        }
        if (this.data == null) {
            this.buffer = null;
            this.getData();
        }
        int n2 = 0;
        while (n2 < this.nFields) {
            try {
                System.arraycopy(objectArray[n2], 0, this.data[n2], n, 1);
            }
            catch (Exception exception) {
                throw new FitsException("Unable to modify row: incompatible data:" + n);
            }
            ++n2;
        }
    }

    public void setElement(int n, int n2, Object object) throws FitsException {
        if (this.data == null) {
            this.buffer = null;
            this.getData();
        }
        try {
            System.arraycopy(object, 0, this.data[n2], n, 1);
        }
        catch (Exception exception) {
            throw new FitsException("Incompatible element:" + n + "," + n2);
        }
    }

    public void setNull(int n, int n2, boolean bl) {
        if (bl) {
            if (this.isNull == null) {
                this.isNull = new boolean[this.nRows * this.nFields];
            }
            this.isNull[n2 + n * this.nFields] = true;
        } else if (this.isNull != null) {
            this.isNull[n2 + n * this.nFields] = false;
        }
    }

    public boolean isNull(int n, int n2) {
        if (this.isNull != null) {
            return this.isNull[n * this.nFields + n2];
        }
        return false;
    }

    public int addColumn(Object object) throws FitsException {
        int n = 0;
        if (object instanceof String[]) {
            String[] stringArray = (String[])object;
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (stringArray[n2] != null && stringArray[n2].length() > n) {
                    n = stringArray[n2].length();
                }
                ++n2;
            }
        } else if (object instanceof double[]) {
            n = 24;
        } else if (object instanceof int[]) {
            n = 10;
        } else if (object instanceof long[]) {
            n = 20;
        } else if (object instanceof float[]) {
            n = 16;
        }
        this.addColumn(object, n);
        return this.nFields;
    }

    public int addColumn(Object object, int n) throws FitsException {
        if (this.nFields > 0 && Array.getLength(object) != this.nRows) {
            throw new FitsException("New column has different number of rows");
        }
        if (this.nFields == 0) {
            this.nRows = Array.getLength(object);
        }
        Object[] objectArray = new Object[this.nFields + 1];
        int[] nArray = new int[this.nFields + 1];
        int[] nArray2 = new int[this.nFields + 1];
        Class[] classArray = new Class[this.nFields + 1];
        String[] stringArray = new String[this.nFields + 1];
        System.arraycopy(this.data, 0, objectArray, 0, this.nFields);
        System.arraycopy(this.offsets, 0, nArray, 0, this.nFields);
        System.arraycopy(this.lengths, 0, nArray2, 0, this.nFields);
        System.arraycopy(this.types, 0, classArray, 0, this.nFields);
        System.arraycopy(this.nulls, 0, stringArray, 0, this.nFields);
        this.data = objectArray;
        this.offsets = nArray;
        this.lengths = nArray2;
        this.types = classArray;
        this.nulls = stringArray;
        objectArray[this.nFields] = object;
        this.offsets[this.nFields] = this.rowLen + 1;
        this.lengths[this.nFields] = n;
        this.types[this.nFields] = ArrayFuncs.getBaseClass(object);
        this.rowLen += n + 1;
        if (this.isNull != null) {
            boolean[] blArray = new boolean[this.nRows * (this.nFields + 1)];
            int n2 = 0;
            int n3 = 0;
            while (n3 < this.isNull.length) {
                if (n3 % this.nFields == 0) {
                    ++n2;
                }
                if (this.isNull[n3]) {
                    blArray[n3 + n2] = true;
                }
                ++n3;
            }
            this.isNull = blArray;
        }
        ++this.nFields;
        return this.nFields;
    }

    public int addRow(Object[] objectArray) throws FitsException {
        if (this.nFields == 0) {
            int n = 0;
            while (n < objectArray.length) {
                this.addColumn(objectArray[n]);
                ++n;
            }
        } else {
            int n = 0;
            while (n < this.nFields) {
                try {
                    Object object = ArrayFuncs.newInstance(this.types[n], this.nRows + 1);
                    System.arraycopy(this.data[n], 0, object, 0, this.nRows);
                    System.arraycopy(objectArray[n], 0, object, this.nRows, 1);
                    this.data[n] = object;
                }
                catch (Exception exception) {
                    throw new FitsException("Error adding row:" + exception);
                }
                ++n;
            }
            ++this.nRows;
        }
        return this.nRows;
    }

    void setNullString(int n, String string) {
        if (n >= 0 && n < this.nulls.length) {
            this.nulls[n] = string;
        }
    }

    protected int getTrueSize() {
        return this.nRows * this.rowLen;
    }

    public void fillHeader(Header header) {
        try {
            header.setXtension("TABLE");
            header.setBitpix(8);
            header.setNaxes(2);
            header.setNaxis(1, this.rowLen);
            header.setNaxis(2, this.nRows);
            Cursor cursor = header.iterator();
            cursor.setKey("NAXIS2");
            cursor.next();
            cursor.add("PCOUNT", new HeaderCard("PCOUNT", 0, "No group data"));
            cursor.add("GCOUNT", new HeaderCard("GCOUNT", 1, "One group"));
            cursor.add("TFIELDS", new HeaderCard("TFIELDS", this.nFields, "Number of fields in table"));
            int n = 0;
            while (n < this.nFields) {
                this.addColInfo(n, cursor);
                ++n;
            }
        }
        catch (HeaderCardException headerCardException) {
            System.err.println("ImpossibleException in fillHeader:" + headerCardException);
        }
    }

    int addColInfo(int n, Cursor cursor) throws HeaderCardException {
        String string = null;
        if (this.types[n] == (class$java$lang$String == null ? (class$java$lang$String = AsciiTable.class$("java.lang.String")) : class$java$lang$String)) {
            string = "A" + this.lengths[n];
        } else if (this.types[n] == Integer.TYPE || this.types[n] == Long.TYPE) {
            string = "I" + this.lengths[n];
        } else if (this.types[n] == Float.TYPE) {
            string = "E" + this.lengths[n] + ".0";
        } else if (this.types[n] == Double.TYPE) {
            string = "D" + this.lengths[n] + ".0";
        }
        String string2 = "TFORM" + (n + 1);
        cursor.add(string2, new HeaderCard(string2, string, null));
        string2 = "TBCOL" + (n + 1);
        cursor.add(string2, new HeaderCard(string2, this.offsets[n] + 1, null));
        return this.lengths[n];
    }

    public int getNRows() {
        return this.nRows;
    }

    public int getNCols() {
        return this.nFields;
    }

    public int getRowLen() {
        return this.rowLen;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

