/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2000g;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSVarDescription;
import jams.tools.JAMSTools;
import java.util.HashMap;
import org.unijena.j2k.J2KFunctions;

public class j2000gGroundwaterParaReader
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Hydrogeology parameter file name")
    public Attribute.String gwFileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Collection of hru objects")
    public Attribute.EntityCollection hrus;

    public void init() {
        Attribute.EntityCollection gwTypes = this.getModel().getRuntime().getDataFactory().createEntityCollection();
        gwTypes.setEntities(J2KFunctions.readParas(JAMSTools.CreateAbsoluteFileName((String)this.getModel().getWorkspaceDirectory().getPath(), (String)this.gwFileName.getValue()), this.getModel()));
        HashMap<Double, Attribute.Entity> gwMap = new HashMap<Double, Attribute.Entity>();
        for (Attribute.Entity gw : gwTypes.getEntities()) {
            gwMap.put(gw.getDouble("GID"), gw);
        }
        for (Attribute.Entity e : this.hrus.getEntities()) {
            Attribute.Entity gw;
            gw = (Attribute.Entity)gwMap.get(e.getDouble("hgeoID"));
            e.setObject("hgeoType", (Object)gw);
            Object[] attrs = gw.getKeys();
            for (int i = 0; i < attrs.length; ++i) {
                Object o = gw.getObject((String)attrs[i]);
                if (o instanceof Attribute.String) continue;
                e.setObject((String)attrs[i], o);
            }
        }
        this.getModel().getRuntime().println("Groundwater parameter file processed ...", 2);
    }
}

